/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diff.encoding.test;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modelevolution.conflicts.detection.impl.MultivaluedFeatureUpdateConflictDetector;
import org.modelevolution.multiview.diff.encoding.engine.impl.Sequence2SATEncodingEngine;
import org.modelevolution.multiview.diff.encoding.service.EncodingService;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;
import org.modelversioning.core.diff.service.DiffService;
import org.modelversioning.core.impl.UUIDResourceFactoryImpl;
import org.modelversioning.core.match.service.MatchService;

public class EncodingEngineTest {
    public static final String FILE_EXTENSION = ".mvml";
    public static final String ORIGIN_FILE = "origin";
    public static final String WCP1_FILE = "working_copy_1";
    public static final String WCP2_FILE = "working_copy_2";
    public static final String path = "models/generated/big/";
    Resource origin = null;
    Resource workingCopy1 = null;
    Resource workingCopy2 = null;
    ComparisonResourceSnapshot leftCRS2 = null;
    ComparisonResourceSnapshot rightCRS2 = null;
    ThreeWayDiffProvider threeWayDiffProvider = null;
    EList<Conflict> conflicts = null;
    EList<EquivalentChange> equivalentChanges = null;

    @Before
    public void setUp() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(FILE_EXTENSION, new UUIDResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new UUIDResourceFactoryImpl());
        URI fileURI_id = URI.createFileURI(new File("models/generated/big/origin.mvml").getAbsolutePath());
        this.origin = resourceSet.getResource(fileURI_id, true);
        URI fileURI1_id = URI.createFileURI(new File("models/generated/big/working_copy_1.mvml").getAbsolutePath());
        this.workingCopy1 = resourceSet.getResource(fileURI1_id, true);
        URI fileURI2_id = URI.createFileURI(new File("models/generated/big/working_copy_2.mvml").getAbsolutePath());
        this.workingCopy2 = resourceSet.getResource(fileURI2_id, true);
        MatchService matchService = new MatchService();
        DiffService diffService = new DiffService();
        this.leftCRS2 = diffService.generateComparisonResourceSnapshot(matchService.generateMatchModel(this.origin, this.workingCopy1));
        this.rightCRS2 = diffService.generateComparisonResourceSnapshot(matchService.generateMatchModel(this.origin, this.workingCopy2));
        this.threeWayDiffProvider = new ThreeWayDiffProvider(this.leftCRS2, this.rightCRS2);
        this.conflicts = new BasicEList<Conflict>();
        this.equivalentChanges = new BasicEList<EquivalentChange>();
        MultivaluedFeatureUpdateConflictDetector operationConflictDetector = new MultivaluedFeatureUpdateConflictDetector();
        operationConflictDetector.detectOverlappingChanges(this.threeWayDiffProvider, this.conflicts, this.equivalentChanges, new NullProgressMonitor());
    }

    @After
    public void tearDown() throws Exception {
        this.origin.unload();
        this.workingCopy1.unload();
        this.workingCopy2.unload();
    }

    @Test
    public void testGenerateSATEncoding() {
        EncodingService encodingService = new EncodingService(new Sequence2SATEncodingEngine());
        File encodingOutput = new File("models/generated/big/encoding.cnf");
        try {
            encodingService.generateEncodedDiffModel(this.conflicts, this.threeWayDiffProvider, encodingOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

