/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diff.encoding.test;

import java.io.File;
import java.util.Random;
import org.modelevolution.multiview.diff.encoding.test.ModelVerifier;
import org.modelevolution.multiview.modelgenerator.Bounds;
import org.modelevolution.multiview.modelgenerator.SequenceGenerator;
import org.modelevolution.multiview.modelgenerator.StatemachineGenerator;

public class GeneratorTester {
    public static final String FILE_EXTENSION = ".mvml";
    public static final String ORIGIN_FILE = "origin";
    public static final String WCP1_FILE = "working_copy_1";
    public static final String WCP2_FILE = "working_copy_2";
    public static final String path = "models/generated/";
    Random random;

    public GeneratorTester(long seed) {
        this.random = new Random(seed);
    }

    private File generateStatemachines(int nrStatemachines, Bounds nrStates, Bounds nrTransitions, String filename) {
        System.out.println("Generating Statemachines ");
        System.out.println("**************************************************");
        StatemachineGenerator generator = new StatemachineGenerator(filename, this.random);
        File file = new File(filename);
        int i = 0;
        while (i < nrStatemachines) {
            System.out.println("STATEMACHINE " + i);
            file = generator.generateStatemachine(nrStates, nrTransitions, false, filename);
            ++i;
        }
        System.out.println();
        return file;
    }

    public File generateSequenceDiagram(int nrLifelines, int nrMessages, File file, boolean copy, String filename) {
        System.out.println("Generating Sequence ");
        System.out.println("**************************************************");
        SequenceGenerator generator = new SequenceGenerator(file, this.random);
        File sequence = generator.generateSequence(nrLifelines, nrMessages, copy, filename);
        System.out.println();
        return sequence;
    }

    public static void main(String[] args) {
        long seed = System.currentTimeMillis();
        GeneratorTester tester = new GeneratorTester(seed);
        ModelVerifier verifier = new ModelVerifier();
        String folder = Long.toString(System.currentTimeMillis());
        int nrStatemachines = 2;
        Bounds nrStates = new Bounds(1, 10);
        Bounds nrTransitions = new Bounds(1, 35);
        folder = "5-SM_100-msg";
        File statemachineView = tester.generateStatemachines(nrStatemachines, nrStates, nrTransitions, path + folder + "/" + ORIGIN_FILE + FILE_EXTENSION);
        File sequenceViewOriginal = tester.generateSequenceDiagram(8, 50, statemachineView, false, "");
        if (verifier.verify(sequenceViewOriginal)) {
            System.out.println("Model " + sequenceViewOriginal.getName() + " is VALID\n");
        } else {
            System.err.println("Model " + sequenceViewOriginal.getName() + " is INVALID\n");
        }
        File sequenceViewWC1 = tester.generateSequenceDiagram(3, 20, sequenceViewOriginal, true, path + folder + "/" + WCP1_FILE + FILE_EXTENSION);
        if (verifier.verify(sequenceViewWC1)) {
            System.out.println("Model " + sequenceViewWC1.getName() + " is VALID\n");
        } else {
            System.err.println("Model " + sequenceViewWC1.getName() + " is INVALID\n");
        }
        File sequenceViewWC2 = tester.generateSequenceDiagram(1, 30, sequenceViewOriginal, true, path + folder + "/" + WCP2_FILE + FILE_EXTENSION);
        if (verifier.verify(sequenceViewWC2)) {
            System.out.println("Model " + sequenceViewWC2.getName() + " is VALID\n");
        } else {
            System.err.println("Model " + sequenceViewWC2.getName() + " is INVALID\n");
        }
        System.out.println("SEED: " + seed);
    }
}

