/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diff.encoding.test;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.LifelineElement;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.Transition;
import org.modelversioning.core.impl.UUIDResourceFactoryImpl;

public class ModelVerifier {
    private static final Logger evalLogger = Logger.getLogger("org.modelevolution.multiview.diff.encoding.eval");
    public static final String FILE_EXTENSION = "mvml";
    public static final String DEFAULT_NAME = "DEFAULT";
    private static final boolean DEBUG = false;

    public boolean verify(File file) {
        boolean valid = false;
        ResourceSetImpl resourceSet = null;
        Resource resource = null;
        MultiviewModel mmmodel = null;
        HashMap<Object, Object> lifelineToMessages = new HashMap();
        resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(FILE_EXTENSION, new UUIDResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new UUIDResourceFactoryImpl());
        URI fileURI_id = URI.createFileURI(file.getAbsolutePath());
        resource = resourceSet.getResource(fileURI_id, true);
        mmmodel = (MultiviewModel)resource.getContents().get(0);
        lifelineToMessages = this.getMap(mmmodel);
        valid = true;
        for (Lifeline lifeline : lifelineToMessages.keySet()) {
            Region sm;
            EList<State> startStates;
            boolean found;
            if (lifeline.getClass_() == null || lifeline.getClass_().getStatemachine() == null) {
                lifeline.initDummyStatemachine();
            }
            if (found = this.searchPaths(startStates = this.getStartStates(sm = lifeline.getClass_().getStatemachine(), (Message)((EList)lifelineToMessages.get(lifeline)).get(0)), (EList)lifelineToMessages.get(lifeline))) continue;
            evalLogger.log(Level.WARNING, "Lifeline {0} is INVALID.", lifeline.getName());
            valid = false;
        }
        resource.unload();
        return valid;
    }

    private EList<State> getStartStates(Region sm, Message m) {
        BasicEList<State> states = new BasicEList<State>();
        for (State state : sm.getStates()) {
            for (Transition t : state.getIncoming()) {
                if (t.getSource() == null || !t.getTrigger().equals(m.getBody())) continue;
                states.add(state);
            }
        }
        return states;
    }

    private boolean searchPaths(EList<State> startStates, EList<Message> messages) {
        for (Message message : messages) {
        }
        for (State start : startStates) {
            boolean found = this.searchPath(start, messages);
            if (!found) continue;
            return true;
        }
        return false;
    }

    private boolean searchPath(State start, EList<Message> messages) {
        int index = 1;
        State currState = start;
        while (index < messages.size()) {
            Message currMessage = (Message)messages.get(index);
            if ((currState = this.getNextState(currState, currMessage)) == null) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private State getNextState(State state, Message m) {
        State next = null;
        for (Transition outTrans : state.getOutgoing()) {
            if (!outTrans.getTrigger().equals(m.getBody())) continue;
            next = outTrans.getTarget();
        }
        return next;
    }

    private HashMap<Lifeline, EList<Message>> getMap(MultiviewModel mmmodel) {
        EList<Lifeline> lifelines = mmmodel.getSequenceview().getLifelines();
        HashMap<Lifeline, EList<Message>> lifelineToMessages = new HashMap<Lifeline, EList<Message>>();
        for (Lifeline l : lifelines) {
            if (l == null) continue;
            for (LifelineElement le : l.getElements()) {
                if (!(le instanceof ReceiveEvent)) continue;
                if (!lifelineToMessages.containsKey(l)) {
                    lifelineToMessages.put(l, new BasicEList());
                }
                lifelineToMessages.get(l).add(((ReceiveEvent)le).getMessage());
            }
        }
        return lifelineToMessages;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            EPackage.Registry.INSTANCE.put(MultiviewPackage.eINSTANCE.getNsURI(), MultiviewPackage.eINSTANCE);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(FILE_EXTENSION, new UUIDResourceFactoryImpl());
        }
        if (args.length == 1 && new File(args[0]).isDirectory()) {
            ModelVerifier.runModelVerifierRecursively(new File(args[0]));
        } else if (args.length == 1 && args[0].substring(args[0].lastIndexOf(".") + 1, args[0].length()).equals(FILE_EXTENSION)) {
            ModelVerifier verifier = new ModelVerifier();
            boolean valid = verifier.verify(new File(args[0]));
            if (valid) {
                System.out.println("Model " + args[0] + " is VALID");
            } else {
                System.out.println("Model " + args[0] + " is INVALID");
            }
        } else {
            System.out.println("SYNOPSIS \nModelVerifier SOURCE_FILE/DIR \n\nDESCRIPTION \nVerifies all .mvml models in SOURCE_DIR. \n\n");
        }
    }

    private static void runModelVerifierRecursively(File file) {
        if (file.isDirectory()) {
            File[] files;
            ModelVerifier.verifyDir(file);
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    ModelVerifier.runModelVerifierRecursively(f);
                }
                ++n2;
            }
        }
    }

    private static void verifyDir(File path) {
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length()).equals(FILE_EXTENSION)) {
                ModelVerifier verifier = new ModelVerifier();
                boolean valid = verifier.verify(file);
                if (valid) {
                    System.out.println("Model " + file.getName() + " is VALID");
                } else {
                    System.out.println("Model " + file.getName() + " is INVALID");
                }
            }
            ++n2;
        }
    }
}

