/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diff.encoding.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.conflictreport.ConflictReport;
import org.modelevolution.multiview.conflictreport.ConflictReportFactory;
import org.modelevolution.multiview.diff.encoding.engine.ICnfParser;
import org.modelevolution.multiview.diff.encoding.engine.ILogObservable;
import org.modelevolution.multiview.diff.encoding.engine.impl.Sequence2SATDIMACSEncodingEngine;
import org.modelevolution.multiview.diff.encoding.service.EncodingService;
import org.modelevolution.multiview.diff.encoding.test.ModelVerifier;
import org.modelevolution.multiview.merge.MergeAdvice;
import org.modelevolution.multiview.merge.engine.impl.MultiviewMergeEngine;
import org.modelevolution.multiview.merge.service.MergeService;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;
import org.modelversioning.core.diff.service.DiffService;
import org.modelversioning.core.impl.UUIDResourceFactoryImpl;
import org.modelversioning.core.match.MatchException;
import org.modelversioning.core.match.engine.impl.DefaultMatchEngineSelector;
import org.modelversioning.core.match.service.MatchService;
import org.modelversioning.core.util.UUIDUtil;

public class SATEncodingTester
implements ILogObservable {
    private static final Logger logger = Logger.getLogger("org.modelevolution.multiview");
    private static Handler loggerHandler;
    private static final Logger evalLogger;
    private static Handler evalLoggerHandler;
    private static final Logger timeLogger;
    private static Handler timeLoggerHandler;
    public static String MODEL_NAME;
    public static final String MODEL_NAME_REGEX;
    public static String CNF_FILE;
    public static String SOLUTION_FILE;
    public static final String MVML_FILE_EXTENSION = "mvml";
    public static final String MVCR_FILE_EXTENSION = "mvcr";
    public static String ORIGIN_FILE;
    public static String WCP1_FILE;
    public static String WCP2_FILE;
    public static String CR_FILE;
    public static String MERGED_MODEL_NAME;
    public static long MAX_MODELS;
    public static String PICOSAT_PATH;
    private ResourceSet resourceSet = null;
    private Resource origin = null;
    private Resource workingCopy1 = null;
    private Resource workingCopy2 = null;
    private Resource mergedModelResource = null;
    private Resource conflictModelResource = null;
    private ComparisonResourceSnapshot leftCRS2 = null;
    private ComparisonResourceSnapshot rightCRS2 = null;
    private ThreeWayDiffProvider threeWayDiff = null;
    private ConflictReport conflictReport = null;
    private EncodingService encodingService = null;
    private MergeService mergeService = null;
    private ModelVerifier verifier = null;
    private long startTime = 0L;
    private long currentModelTime = 0L;
    private long totalTime = 0L;
    private static int testInstanceCounter;
    private long nrModels = 0L;
    private long nrInvalidModels = 0L;

    static {
        evalLogger = Logger.getLogger("org.modelevolution.multiview.eval");
        timeLogger = Logger.getLogger("org.modelevolution.multiview.eval.time");
        MODEL_NAME = "model";
        MODEL_NAME_REGEX = String.valueOf(MODEL_NAME) + "\\d+";
        CNF_FILE = "out.cnf";
        SOLUTION_FILE = "solution";
        ORIGIN_FILE = "origin";
        WCP1_FILE = "working_copy_1";
        WCP2_FILE = "working_copy_2";
        CR_FILE = "conflictreport";
        MERGED_MODEL_NAME = "merged";
        MAX_MODELS = Long.MAX_VALUE;
        PICOSAT_PATH = new File("models/picosat-936/picosat").getAbsolutePath();
        testInstanceCounter = 0;
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream("SDMerger.properties"));
            if (prop.getProperty("path.picosat") != null) {
                PICOSAT_PATH = new File(prop.getProperty("path.picosat")).getAbsolutePath();
            }
            if (prop.getProperty("name.origin") != null) {
                ORIGIN_FILE = prop.getProperty("name.origin");
            }
            if (prop.getProperty("name.working_copy1") != null) {
                WCP1_FILE = prop.getProperty("name.working_copy1");
            }
            if (prop.getProperty("name.working_copy2") != null) {
                WCP2_FILE = prop.getProperty("name.working_copy2");
            }
            if (prop.getProperty("name.conflictreport") != null) {
                CR_FILE = prop.getProperty("name.conflictreport");
            }
            if (prop.getProperty("name.merged") != null) {
                MERGED_MODEL_NAME = prop.getProperty("name.merged");
            }
            if (prop.getProperty("value.max_models") != null) {
                if (prop.getProperty("value.max_models").equals("Long.MAX_VALUE")) {
                    MAX_MODELS = Long.MAX_VALUE;
                } else if (prop.getProperty("value.max_models").equals("Long.MIN_VALUE")) {
                    MAX_MODELS = Long.MIN_VALUE;
                } else {
                    try {
                        MAX_MODELS = Long.parseLong(prop.getProperty("value.max_models"));
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.WARNING, "Unexpected value of property max_models: {0}. Falling back to default value: {1}", new Object[]{prop.getProperty("value.max_models"), MAX_MODELS});
                    }
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public SATEncodingTester() {
        logger.log(Level.INFO, "Starting {0}", this.getClass().getName());
        this.encodingService = new EncodingService(new Sequence2SATDIMACSEncodingEngine());
        this.mergeService = new MergeService(new MultiviewMergeEngine());
        this.verifier = new ModelVerifier();
    }

    public void performMerge(String path) {
        block8: {
            logger.log(Level.INFO, "Starting {0} with path {1}.", new Object[]{this.encodingService.getEncodingEngine().getClass().getName(), path});
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(path) + File.separator;
            }
            try {
                this.setUp(path);
                File encodingOutput = new File(String.valueOf(path) + CNF_FILE);
                this.encodingService.generateEncodedDiffModel(this.threeWayDiff, this.conflictReport, encodingOutput);
                this.conflictModelResource.save(Collections.EMPTY_MAP);
                logObservations.put(ILogObservable.LogObservation.ENC, ((ILogObservable)((Object)this.encodingService.getEncodingEngine())).getLogObservation(ILogObservable.LogObservation.ENC));
                logObservations.put(ILogObservable.LogObservation.DIFF_POST, ((ILogObservable)((Object)this.encodingService.getEncodingEngine())).getLogObservation(ILogObservable.LogObservation.DIFF_POST));
                logObservations.put(ILogObservable.LogObservation.CNF_VAR_COUNT, ((ILogObservable)((Object)this.encodingService.getEncodingEngine())).getLogObservation(ILogObservable.LogObservation.CNF_VAR_COUNT));
                logObservations.put(ILogObservable.LogObservation.CNF_CLAUSE_COUNT, ((ILogObservable)((Object)this.encodingService.getEncodingEngine())).getLogObservation(ILogObservable.LogObservation.CNF_CLAUSE_COUNT));
                this.getModels(path);
                ++testInstanceCounter;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
                this.tearDown();
                break block8;
            }
            catch (MatchException e) {
                try {
                    logger.log(Level.SEVERE, e.getMessage());
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.tearDown();
                }
            }
            this.tearDown();
        }
        logger.log(Level.INFO, "Sequence2SATEncodingEngine with path {0} done.", path);
        evalLogger.log(Level.INFO, "Test instance: {0}\nSolutions found: {1}\nInvalid solutions: {2}\nOrigin Msg Count: {3}\nAdded Msg Count: {4}\n", new Object[]{path, this.nrModels, this.nrInvalidModels, this.getLogObservation(ILogObservable.LogObservation.MSG_COUNT), this.getLogObservation(ILogObservable.LogObservation.ADD_MSG_COUNT)});
    }

    private void getModels(String path) {
        logger.log(Level.INFO, "Starting SAT solver.");
        File cnfFile = new File(String.valueOf(path) + CNF_FILE);
        this.nrModels = 0L;
        this.nrInvalidModels = 0L;
        this.startTime = System.currentTimeMillis();
        File solution = this.runSATsolver(cnfFile, path);
        logObservations.put(ILogObservable.LogObservation.SAT, System.currentTimeMillis() - this.startTime);
        while (this.isSAT(solution) && this.nrModels < MAX_MODELS) {
            logger.log(Level.INFO, "Solution found. Starting variable extraction.");
            this.startTime = System.currentTimeMillis();
            ++this.nrModels;
            List<Integer> vars = this.extractVars(solution);
            logger.log(Level.INFO, "Starting mergeAdvice extraction.");
            MergeAdvice mergeAdvice = this.getMergeAdvice(vars);
            logObservations.put(ILogObservable.LogObservation.DEC, System.currentTimeMillis() - this.startTime);
            logger.log(Level.INFO, "Starting model merger.");
            this.startTime = System.currentTimeMillis();
            File model = this.buildModel(mergeAdvice, this.nrModels, path);
            logObservations.put(ILogObservable.LogObservation.MERGE, System.currentTimeMillis() - this.startTime);
            logger.log(Level.INFO, "Starting verifier.");
            this.startTime = System.currentTimeMillis();
            if (!this.verifier.verify(model)) {
                evalLogger.log(Level.SEVERE, "Model {0} is INVALID!", model.getAbsolutePath());
                ++this.nrInvalidModels;
                System.exit(0);
            }
            logObservations.put(ILogObservable.LogObservation.VERIFY, System.currentTimeMillis() - this.startTime);
            this.logTimeObservation();
            logger.log(Level.INFO, "Starting addToCNF.");
            this.startTime = System.currentTimeMillis();
            cnfFile = this.addToCNF(vars, cnfFile);
            logger.log(Level.INFO, "Starting increaseClauses.");
            cnfFile = this.increaseNrClauses(cnfFile, 1);
            logObservations.put(ILogObservable.LogObservation.ENC, System.currentTimeMillis() - this.startTime);
            logger.log(Level.INFO, "Starting SAT solver.");
            this.startTime = System.currentTimeMillis();
            solution = this.runSATsolver(cnfFile, path);
            logObservations.put(ILogObservable.LogObservation.SAT, System.currentTimeMillis() - this.startTime);
        }
        if (!this.isSAT(solution)) {
            logger.log(Level.INFO, "No solution found.");
            this.logTimeObservation(-1L);
        }
    }

    private File addToCNF(List<Integer> vars, File cnfFile) {
        try {
            BufferedWriter cnf = new BufferedWriter(new FileWriter(cnfFile, true));
            for (int var : vars) {
                String originVar = ((ICnfParser)((Object)this.encodingService.getEncodingEngine())).getVariable(var);
                if (originVar == null || !originVar.endsWith(Sequence2SATDIMACSEncodingEngine.VAR_EXT_MESSAGE)) continue;
                cnf.write("-" + var + " ");
            }
            cnf.write("0\n");
            cnf.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return cnfFile;
    }

    private MergeAdvice getMergeAdvice(List<Integer> vars) {
        MergeAdvice mergeAdvice = new MergeAdvice();
        for (int var : vars) {
            String originVar = ((ICnfParser)((Object)this.encodingService.getEncodingEngine())).getVariable(var);
            if (originVar == null || !originVar.endsWith(Sequence2SATDIMACSEncodingEngine.VAR_EXT_MESSAGE)) continue;
            mergeAdvice.addPosition(((ICnfParser)((Object)this.encodingService.getEncodingEngine())).getVariable(var));
        }
        return mergeAdvice;
    }

    private File buildModel(MergeAdvice mergeAdvice, long count, String path) {
        File model = new File(String.valueOf(path) + MERGED_MODEL_NAME + count + "." + MVML_FILE_EXTENSION);
        try {
            this.mergedModelResource = this.resourceSet.createResource(URI.createFileURI(model.getAbsolutePath()));
            this.mergeService.generateMergedModel(this.threeWayDiff, mergeAdvice, this.mergedModelResource, this.conflictModelResource);
            this.mergedModelResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        this.mergedModelResource.unload();
        return model;
    }

    private File increaseNrClauses(File cnf, int nrIncrease) {
        File newFile = new File(String.valueOf(cnf.getAbsolutePath()) + ".tmp");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(cnf));
            PrintWriter writer = new PrintWriter(new FileWriter(newFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("p")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, " ");
                    writer.print(String.valueOf(tokenizer.nextToken()) + " ");
                    writer.print(String.valueOf(tokenizer.nextToken()) + " ");
                    writer.print(String.valueOf(tokenizer.nextToken()) + " ");
                    int nrClauses = Integer.parseInt(tokenizer.nextToken()) + nrIncrease;
                    writer.print(String.valueOf(nrClauses) + " ");
                    writer.println();
                    logObservations.put(ILogObservable.LogObservation.CNF_CLAUSE_COUNT, new Long(nrClauses));
                    continue;
                }
                writer.println(line);
            }
            reader.close();
            writer.close();
            SATEncodingTester.moveFile(newFile, cnf);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return cnf;
    }

    private List<Integer> extractVars(File solution) {
        ArrayList<Integer> vars = new ArrayList<Integer>();
        try {
            Scanner scanner = new Scanner(solution);
            scanner.nextLine();
            while (scanner.hasNext()) {
                String currVar = scanner.next();
                if (currVar.startsWith("-") || currVar.startsWith("v")) continue;
                vars.add(Integer.parseInt(currVar));
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return vars;
    }

    private boolean isSAT(File solution) {
        try {
            Scanner scanner = new Scanner(solution);
            scanner.skip("s");
            String result = scanner.next();
            if (result.equals("SATISFIABLE")) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return false;
    }

    private File runSATsolver(File cnf, String path) {
        String cnfPath = cnf.getAbsolutePath();
        try {
            String line;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(new String[]{PICOSAT_PATH, cnfPath});
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            FileWriter fstream = new FileWriter(String.valueOf(path) + File.separator + SOLUTION_FILE);
            BufferedWriter out = new BufferedWriter(fstream);
            while (!reader.ready()) {
            }
            while ((line = reader.readLine()) != null) {
                out.write(String.valueOf(line) + "\n");
            }
            p.waitFor();
            out.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return new File(String.valueOf(path) + File.separator + SOLUTION_FILE);
    }

    private void setUp(String path) throws MatchException {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(MVML_FILE_EXTENSION, new UUIDResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(MVCR_FILE_EXTENSION, new UUIDResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new UUIDResourceFactoryImpl());
        URI fileURI_id = URI.createFileURI(new File(String.valueOf(path) + ORIGIN_FILE + "." + MVML_FILE_EXTENSION).getAbsolutePath());
        this.origin = this.resourceSet.getResource(fileURI_id, true);
        URI fileURI1_id = URI.createFileURI(new File(String.valueOf(path) + WCP1_FILE + "." + MVML_FILE_EXTENSION).getAbsolutePath());
        this.workingCopy1 = this.resourceSet.getResource(fileURI1_id, true);
        UUIDUtil.addUUIDs((EObject)this.workingCopy1.getContents().get(0));
        URI fileURI2_id = URI.createFileURI(new File(String.valueOf(path) + WCP2_FILE + "." + MVML_FILE_EXTENSION).getAbsolutePath());
        this.workingCopy2 = this.resourceSet.getResource(fileURI2_id, true);
        UUIDUtil.addUUIDs((EObject)this.workingCopy2.getContents().get(0));
        URI fileURI_cr = URI.createFileURI(new File(String.valueOf(path) + CR_FILE + "." + MVCR_FILE_EXTENSION).getAbsolutePath());
        this.conflictModelResource = this.resourceSet.createResource(fileURI_cr);
        try {
            this.workingCopy1.save(Collections.EMPTY_MAP);
            this.workingCopy2.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        this.startTime = System.currentTimeMillis();
        MatchService matchService = new MatchService(new DefaultMatchEngineSelector(false));
        DiffService diffService = new DiffService();
        this.leftCRS2 = diffService.generateComparisonResourceSnapshot(matchService.generateMatchModel(this.origin, this.workingCopy1));
        this.rightCRS2 = diffService.generateComparisonResourceSnapshot(matchService.generateMatchModel(this.origin, this.workingCopy2));
        this.threeWayDiff = new ThreeWayDiffProvider(this.leftCRS2, this.rightCRS2);
        logObservations.put(ILogObservable.LogObservation.DIFF_EMF, System.currentTimeMillis() - this.startTime);
        this.conflictReport = ConflictReportFactory.eINSTANCE.createConflictReport();
        this.conflictReport.setLeftComparisonSnapshot(this.leftCRS2);
        this.conflictReport.setRightComparisonSnapshot(this.rightCRS2);
        this.conflictModelResource.getContents().add(this.conflictReport);
        logObservations.put(ILogObservable.LogObservation.MSG_COUNT, new Long(((MultiviewModel)this.origin.getContents().get(0)).getSequenceview().getMessages().size()));
        long nrAddedMessages = 0L;
        for (EObject o : this.threeWayDiff.getAddedEObjects(Side.LEFT, true)) {
            if (!(o instanceof Message)) continue;
            ++nrAddedMessages;
        }
        for (EObject o : this.threeWayDiff.getAddedEObjects(Side.RIGHT, true)) {
            if (!(o instanceof Message)) continue;
            ++nrAddedMessages;
        }
        logObservations.put(ILogObservable.LogObservation.ADD_MSG_COUNT, nrAddedMessages);
        long nrStates = 0L;
        long nrTransitions = 0L;
        for (Region r : ((MultiviewModel)this.origin.getContents().get(0)).getStateview().getStatemachines()) {
            nrStates += (long)r.getStates().size();
            for (State s : r.getStates()) {
                nrTransitions += (long)s.getIncoming().size();
            }
        }
        logObservations.put(ILogObservable.LogObservation.STATE_COUNT, nrStates);
        logObservations.put(ILogObservable.LogObservation.TRANSITION_COUNT, nrTransitions);
    }

    private void tearDown() {
        try {
            this.conflictModelResource.save(Collections.EMPTY_MAP);
            this.conflictModelResource.unload();
            this.origin.unload();
            this.workingCopy1.unload();
            this.workingCopy2.unload();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }

    public static void main(String[] args) throws SecurityException, IOException {
        int i = 0;
        while (i < 1000) {
            String logname = "";
            if (args.length == 1) {
                logname = args[0].replace(File.separator, "-");
            } else if (args.length == 2) {
                logname = args[1].replace(File.separator, "-");
            }
            FileHandler fh = new FileHandler(String.valueOf(logname) + "_" + new Date().getTime() + ".log", true);
            fh.setFormatter(new SimpleFormatter());
            evalLogger.addHandler(fh);
            evalLogger.setLevel(Level.ALL);
            FileHandler fh1 = new FileHandler(String.valueOf(logname) + "_heartbeat_" + new Date().getTime() + ".log", true);
            fh1.setFormatter(new SimpleFormatter());
            logger.setLevel(Level.OFF);
            if (args.length > 0) {
                EPackage.Registry.INSTANCE.put(MultiviewPackage.eINSTANCE.getNsURI(), MultiviewPackage.eINSTANCE);
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(MVML_FILE_EXTENSION, new UUIDResourceFactoryImpl());
            }
            if (args.length == 1 && SATEncodingTester.isTestFolder(new File(args[0]))) {
                File srcDir = new File(args[0]);
                SATEncodingTester tester = new SATEncodingTester();
                tester.performMerge(srcDir.getPath());
            } else if (args.length == 2 && args[0].equals("-r") && new File(args[1]).isDirectory()) {
                SATEncodingTester.runSATEncodingTesterRecursively(new File(args[1]));
            } else {
                System.out.println("SYNOPSIS \nSATEncodingTester [OPTION] SOURCE_DIR \n\nDESCRIPTION \nEncodes the Merge Problem of the given SOURCE_DIR in SAT. \n\n-r \t follow directory tree recursively. \n");
            }
            evalLogger.log(Level.INFO, "Done. {0} instances performed.", testInstanceCounter);
            ++i;
        }
    }

    private static void initTimeLogger(String path) throws IOException {
        Handler[] handlerArray = timeLogger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            h.flush();
            h.close();
            timeLogger.removeHandler(h);
            ++n2;
        }
        timeLoggerHandler = new FileHandler(String.valueOf(path) + File.separator + path.replaceAll(File.separator, "_") + "-" + new Date() + "_time.log", false);
        timeLoggerHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formatMessage(record));
                return builder.toString();
            }
        });
        timeLogger.addHandler(timeLoggerHandler);
        timeLogger.setLevel(Level.INFO);
        timeLogger.setUseParentHandlers(false);
        timeLogger.log(Level.INFO, "nr\tdiff_emf\tdiff_post\tenc\tsat\tdec\tmerge\tverify\tsum\tssum\tmsg\tmsg_add\tstates\ttransitions\tvar\tclauses\tvalid\n");
    }

    private static void runSATEncodingTesterRecursively(File file) {
        if (file.isDirectory()) {
            File[] files;
            if (SATEncodingTester.isTestFolder(file)) {
                try {
                    SATEncodingTester.initTimeLogger(file.getPath().toString());
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage());
                }
                SATEncodingTester tester = new SATEncodingTester();
                tester.performMerge(file.getPath());
            }
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    SATEncodingTester.runSATEncodingTesterRecursively(f);
                }
                ++n2;
            }
        }
    }

    private static boolean isTestFolder(File file) {
        return file.isDirectory() && new File(String.valueOf(file.getPath()) + File.separator + ORIGIN_FILE + "." + MVML_FILE_EXTENSION).exists() && new File(String.valueOf(file.getPath()) + File.separator + WCP1_FILE + "." + MVML_FILE_EXTENSION).exists() && new File(String.valueOf(file.getPath()) + File.separator + WCP2_FILE + "." + MVML_FILE_EXTENSION).exists();
    }

    public static void moveFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            long count = 0L;
            long size = source.size();
            while ((count += ((FileChannel)destination).transferFrom(source, count, size - count)) < size) {
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        sourceFile.delete();
    }

    @Override
    public Long getLogObservation(ILogObservable.LogObservation observation) {
        if (logObservations.containsKey((Object)observation)) {
            return (Long)logObservations.get((Object)observation);
        }
        return 0L;
    }

    private void logTimeObservation() {
        this.logTimeObservation(this.nrModels);
    }

    private void logTimeObservation(long modelCounter) {
        String emptyVal = "X";
        long emptyTime = -1L;
        this.currentModelTime = this.getLogObservation(ILogObservable.LogObservation.DIFF_EMF) + this.getLogObservation(ILogObservable.LogObservation.DIFF_POST) + this.getLogObservation(ILogObservable.LogObservation.ENC) + this.getLogObservation(ILogObservable.LogObservation.SAT) + this.getLogObservation(ILogObservable.LogObservation.DEC) + this.getLogObservation(ILogObservable.LogObservation.MERGE) + this.getLogObservation(ILogObservable.LogObservation.VERIFY);
        this.totalTime += this.currentModelTime;
        timeLogger.log(Level.INFO, "{0}\t{1}\t{2}\t{3}\t{4}\t{5}\t{6}\t{7}\t{8}\t{9}\t{10}\t{11}\t{12}\t{13}\t{14}\t{15}\t{16}\n", new Object[]{modelCounter != emptyTime ? Long.valueOf(modelCounter) : emptyVal, this.getLogObservation(ILogObservable.LogObservation.DIFF_EMF) != emptyTime ? this.getLogObservation(ILogObservable.LogObservation.DIFF_EMF) : emptyVal, this.getLogObservation(ILogObservable.LogObservation.DIFF_POST) != emptyTime ? this.getLogObservation(ILogObservable.LogObservation.DIFF_POST) : emptyVal, this.getLogObservation(ILogObservable.LogObservation.ENC) != emptyTime ? this.getLogObservation(ILogObservable.LogObservation.ENC) : emptyVal, this.getLogObservation(ILogObservable.LogObservation.SAT) != emptyTime ? this.getLogObservation(ILogObservable.LogObservation.SAT) : emptyVal, this.getLogObservation(ILogObservable.LogObservation.DEC) != emptyTime ? this.getLogObservation(ILogObservable.LogObservation.DEC) : emptyVal, this.getLogObservation(ILogObservable.LogObservation.MERGE) != emptyTime ? this.getLogObservation(ILogObservable.LogObservation.MERGE) : emptyVal, this.getLogObservation(ILogObservable.LogObservation.VERIFY) != emptyTime ? this.getLogObservation(ILogObservable.LogObservation.VERIFY) : emptyVal, this.currentModelTime, this.totalTime, this.getLogObservation(ILogObservable.LogObservation.MSG_COUNT), this.getLogObservation(ILogObservable.LogObservation.ADD_MSG_COUNT), this.getLogObservation(ILogObservable.LogObservation.STATE_COUNT), this.getLogObservation(ILogObservable.LogObservation.TRANSITION_COUNT), this.getLogObservation(ILogObservable.LogObservation.CNF_VAR_COUNT), this.getLogObservation(ILogObservable.LogObservation.CNF_CLAUSE_COUNT), this.getLogObservation(ILogObservable.LogObservation.VALID)});
        logObservations.put(ILogObservable.LogObservation.DIFF_EMF, emptyTime);
        logObservations.put(ILogObservable.LogObservation.DIFF_POST, emptyTime);
        logObservations.put(ILogObservable.LogObservation.ENC, emptyTime);
        logObservations.put(ILogObservable.LogObservation.SAT, emptyTime);
        logObservations.put(ILogObservable.LogObservation.DEC, emptyTime);
        logObservations.put(ILogObservable.LogObservation.MERGE, emptyTime);
        logObservations.put(ILogObservable.LogObservation.VERIFY, emptyTime);
        logObservations.put(ILogObservable.LogObservation.VALID, emptyTime);
    }
}

