/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diff.encoding.test;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelversioning.core.impl.UUIDResourceFactoryImpl;

public class StateMachineSimplifyer {
    private static final Logger logger = Logger.getLogger("org.modelevolution.multiview.StateMachineSimplifyer");
    public static final String MVML_FILE_EXTENSION = "mvml";
    public static final String SIMPLE_FILE_POSTFIX = "_simple";
    private ResourceSet resourceSet = null;
    private Resource originModel = null;
    private Resource simpleModel = null;
    private MultiviewModel mvmlModel = null;
    private Hashtable<String, EList<Message>> symbolMessageTable;

    public StateMachineSimplifyer(String modelPath) {
        EPackage.Registry.INSTANCE.put(MultiviewPackage.eINSTANCE.getNsURI(), MultiviewPackage.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(MVML_FILE_EXTENSION, new UUIDResourceFactoryImpl());
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(MVML_FILE_EXTENSION, new UUIDResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new UUIDResourceFactoryImpl());
        URI originModelURI = URI.createFileURI(new File(modelPath).getAbsolutePath());
        this.originModel = this.resourceSet.getResource(originModelURI, true);
        URI simpleModelURI = URI.createFileURI(new File(modelPath.replaceFirst(".mvml", "_simple.mvml")).getAbsolutePath());
        this.simpleModel = this.resourceSet.createResource(simpleModelURI);
        if (this.originModel.getContents().get(0) instanceof MultiviewModel) {
            this.mvmlModel = (MultiviewModel)this.originModel.getContents().get(0);
            BasicEList<Region> removeRegions = new BasicEList<Region>();
            BasicEList<State> removeStates = new BasicEList<State>();
            for (Region r : this.mvmlModel.getStateview().getStatemachines()) {
                if (r.getClass_().getLifelines() == null || r.getClass_().getLifelines().isEmpty()) {
                    logger.log(Level.INFO, "Region {0} unused.", r.getName());
                    removeRegions.add(r);
                    continue;
                }
                Transition initialTransition = r.getInitialTransition();
                if (initialTransition != null && !this.hasMessage(initialTransition.getTrigger())) {
                    logger.log(Level.INFO, "Transition {0}-{1}-{2} unused.", new Object[]{initialTransition.getSource().getName(), initialTransition.getTrigger().getName(), initialTransition.getTarget().getName()});
                    r.setInitialTransition(null);
                    initialTransition.getTarget().getIncoming().remove(initialTransition);
                    initialTransition = null;
                }
                for (State s : r.getStates()) {
                    BasicEList<Transition> removeTransitions = new BasicEList<Transition>();
                    for (Transition t : s.getOutgoing()) {
                        if (this.hasMessage(t.getTrigger())) continue;
                        logger.log(Level.INFO, "Transition {0}-{1}-{2} unused.", new Object[]{t.getSource().getName(), t.getTrigger().getName(), t.getTarget().getName()});
                        removeTransitions.add(t);
                    }
                    s.getOutgoing().removeAll(removeTransitions);
                    for (Transition rt : removeTransitions) {
                        if (rt.getTarget() == null || rt.getTarget().getIncoming() == null) continue;
                        rt.getTarget().getIncoming().remove(rt);
                    }
                    if ((s.getOutgoing() != null && !s.getOutgoing().isEmpty() || s.getIncoming() != null) && !s.getIncoming().isEmpty()) continue;
                    removeStates.add(s);
                }
                r.getStates().removeAll(removeStates);
            }
            this.mvmlModel.getStateview().getStatemachines().removeAll(removeRegions);
            for (Region rr : removeRegions) {
                rr.getClass_().setStatemachine(null);
            }
            this.simpleModel.getContents().add(this.mvmlModel);
            try {
                this.simpleModel.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        } else {
            logger.log(Level.WARNING, "No valid MVML originModel");
        }
    }

    private boolean hasMessage(Symbol symbol) {
        String symbolName = symbol.getName();
        if (this.symbolMessageTable == null) {
            this.symbolMessageTable = new Hashtable();
            for (Message m : this.mvmlModel.getSequenceview().getMessages()) {
                EList<Object> msg;
                String s = m.getBody().getName();
                if (this.symbolMessageTable.contains(s)) {
                    msg = this.symbolMessageTable.get(s);
                    msg.add(m);
                    this.symbolMessageTable.put(s, msg);
                    continue;
                }
                msg = new BasicEList<Message>();
                msg.add(m);
                this.symbolMessageTable.put(s, msg);
            }
        }
        boolean hasMessage = this.symbolMessageTable.containsKey(symbolName);
        return hasMessage;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            logger.addHandler(new ConsoleHandler());
            logger.setLevel(Level.SEVERE);
            new StateMachineSimplifyer(args[0]);
        } else {
            System.out.println("SYNOPSIS \nStateMachineSimplifyer PATH/TO/MODEL.mvml");
        }
    }
}

