/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.merge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.emf.common.util.BasicEList;
import org.modelevolution.multiview.merge.MergePosition;
import org.modelevolution.multiview.merge.MergeType;

public class MergeAdvice {
    public static final String POS_REGEX = "\\d+-[LOR]-\\d+.*";
    private SortedMap<Integer, MergePosition> mergePositions = new TreeMap<Integer, MergePosition>();

    public MergeAdvice() {
    }

    public MergeAdvice(File mergeAdvice) throws IOException {
        String line;
        FileReader fr = new FileReader(mergeAdvice);
        BufferedReader br = new BufferedReader(fr);
        while ((line = br.readLine()) != null) {
            if (!line.matches(POS_REGEX)) continue;
            String[] words = line.substring(2).split("-");
            this.mergePositions.put(Integer.parseInt(words[0].trim()), new MergePosition(Integer.parseInt(words[2].trim()), MergeType.valueOf(words[1].trim())));
        }
        fr.close();
    }

    public void addPosition(int position, MergePosition mergePosition) {
        this.mergePositions.put(position, mergePosition);
    }

    public void addPosition(int newPosition, MergeType type, int prevPosition) {
        this.mergePositions.put(newPosition, new MergePosition(prevPosition, type));
    }

    public void addPosition(String variable) {
        if (variable.matches(POS_REGEX)) {
            String[] words = variable.split("_")[0].split("-");
            int newPosition = Integer.parseInt(words[0].trim());
            int oldPosition = Integer.parseInt(words[2].trim());
            MergeType type = MergeType.valueOf(words[1].trim());
            this.mergePositions.put(newPosition, new MergePosition(oldPosition, type));
        }
    }

    public BasicEList.UnmodifiableEList<MergePosition> getMergePositions() {
        return new BasicEList.UnmodifiableEList<MergePosition>(this.mergePositions.size(), this.mergePositions.values().toArray());
    }
}

