/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.merge.engine.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.ConflictReport;
import org.modelevolution.multiview.conflictreport.MergeOption;
import org.modelevolution.multiview.merge.MergeAdvice;
import org.modelevolution.multiview.merge.MergePosition;
import org.modelevolution.multiview.merge.MergeType;
import org.modelevolution.multiview.merge.engine.IMergeEngine;
import org.modelversioning.conflictreport.ConflictReportFactory;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;
import org.modelversioning.core.util.UUIDUtil;
import org.modelversioning.merge.IMerger;
import org.modelversioning.merge.impl.MergeSpecificChangeStrategy;
import org.modelversioning.merge.impl.MergerImpl;

public class MultiviewMergeEngine
implements IMergeEngine {
    private static final Logger logger = Logger.getLogger("org.modelevolution.multiview");
    private ConflictReport conflictReport = null;
    private MultiviewModel mergedModel = null;

    @Override
    public void merge(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice, Resource mergedModelResource) {
        MergeSpecificChangeStrategy mergeStrategy = new MergeSpecificChangeStrategy();
        mergeStrategy.setChangesToMerge(this.getChangesToMerge(threeWayDiff));
        MergerImpl merger = new MergerImpl();
        merger.setMergeStrategy(mergeStrategy);
        merger.merge(ConflictReportFactory.eINSTANCE.createConflictReport(), threeWayDiff.getComparisonSnapshot(Side.LEFT), threeWayDiff.getComparisonSnapshot(Side.RIGHT), mergedModelResource, new NullProgressMonitor());
        this.mergedModel = (MultiviewModel)mergedModelResource.getContents().get(0);
    }

    @Override
    public void merge(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice, Resource mergedModelResource, Resource conflictModelResource) {
        if (conflictModelResource != null) {
            this.conflictReport = (ConflictReport)conflictModelResource.getContents().get(0);
        }
        if (this.conflictReport == null || this.conflictReport.getMergedVersions() == null || this.conflictReport.getMergedVersions().isEmpty()) {
            this.merge(threeWayDiff, mergeAdvice, mergedModelResource);
        } else {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            this.mergedModel = (MultiviewModel)copier.copy((EObject)this.conflictReport.getMergedVersions().get(0));
            copier.copyReferences();
            mergedModelResource.getContents().add(this.mergedModel);
            for (EObject origin : copier.keySet()) {
                UUIDUtil.copyUUID(origin, (EObject)copier.get(origin));
            }
        }
        this.sortMessages(threeWayDiff, mergeAdvice);
        if (this.conflictReport != null) {
            this.conflictReport.getMergedVersions().add(this.mergedModel);
            EList<EObject> leftAddedEObjects = threeWayDiff.getAddedEObjects(Side.LEFT, true);
            EList<EObject> rightAddedEObjects = threeWayDiff.getAddedEObjects(Side.RIGHT, true);
            EList<EObject> leftUpdatedEObjects = threeWayDiff.getUpdatedEObjects(Side.LEFT, true);
            EList<EObject> rightUpdatedEObjects = threeWayDiff.getUpdatedEObjects(Side.RIGHT, true);
            EList<EObject> leftDeletedEObjects = threeWayDiff.getDeletedEObjects(Side.LEFT, true);
            EList<EObject> rightDeletedEObjects = threeWayDiff.getDeletedEObjects(Side.RIGHT, true);
            for (ConflictFragment c : this.conflictReport.getConflicts()) {
                Message lastOriginMsgCopy = null;
                Message nextOriginMessageCopy = null;
                MergeOption mergeOption = org.modelevolution.multiview.conflictreport.ConflictReportFactory.eINSTANCE.createMergeOption();
                if (c.getLastOrigin() != null) {
                    lastOriginMsgCopy = this.findMessageByFragment(c.getLastOrigin());
                }
                if (c.getNextOrigin() != null) {
                    nextOriginMessageCopy = this.findMessageByFragment(c.getNextOrigin());
                }
                Message startMsg = lastOriginMsgCopy == null ? (Message)this.mergedModel.getSequenceview().getOrderedMessages().get(0) : (Message)this.mergedModel.getSequenceview().getOrderedMessages().get(this.mergedModel.getSequenceview().getOrderedMessages().indexOf(lastOriginMsgCopy) + 1);
                Message endMsg = nextOriginMessageCopy == null ? (Message)this.mergedModel.getSequenceview().getOrderedMessages().get(this.mergedModel.getSequenceview().getMessages().size() - 1) : (Message)this.mergedModel.getSequenceview().getOrderedMessages().get(this.mergedModel.getSequenceview().getOrderedMessages().indexOf(nextOriginMessageCopy) - 1);
                mergeOption.setStartMessage(startMsg);
                mergeOption.setEndMessage(endMsg);
                EList<Message> orderedMessages = this.mergedModel.getSequenceview().getOrderedMessages();
                int i = orderedMessages.indexOf(startMsg);
                while (i <= orderedMessages.indexOf(endMsg)) {
                    Message m = (Message)orderedMessages.get(i);
                    if (this.findEObjectByFragment(m, leftAddedEObjects) != null) {
                        mergeOption.getLeftAddedMessages().add(m);
                    } else if (this.findEObjectByFragment(m, rightAddedEObjects) != null) {
                        mergeOption.getRightAddedMessages().add(m);
                    } else if (this.findEObjectByFragment(m, leftDeletedEObjects) != null) {
                        mergeOption.getLeftDeletedMessages().add(m);
                    } else if (this.findEObjectByFragment(m, rightDeletedEObjects) != null) {
                        mergeOption.getRightDeletedMessages().add(m);
                    } else if (this.findEObjectByFragment(m, leftUpdatedEObjects) != null) {
                        mergeOption.getLeftUpdatedMessages().add(m);
                    } else if (this.findEObjectByFragment(m, rightUpdatedEObjects) != null) {
                        mergeOption.getRightUpdatedMessages().add(m);
                    }
                    ++i;
                }
                c.getMergeOptions().add(mergeOption);
            }
        }
    }

    private void sortMessages(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice) {
        for (MergePosition mp : mergeAdvice.getMergePositions()) {
            Message msg = null;
            Message msgCopy = null;
            if (mp.getType().equals((Object)MergeType.O)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getOriginModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else if (mp.getType().equals((Object)MergeType.L)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getLeftModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else if (mp.getType().equals((Object)MergeType.R)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getRightModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else {
                logger.log(Level.SEVERE, "Message with mergeType {0} on index {1} not found.", new Object[]{mp.getType(), mp.getIndex()});
            }
            msgCopy = this.findMessageByFragment(msg);
            SendEvent sendEventCopy = msgCopy.getSender();
            ReceiveEvent receiveEventCopy = msgCopy.getReceiver();
            Lifeline senderLifelineCopy = sendEventCopy.getLifeline();
            Lifeline receiverLifelineCopy = receiveEventCopy.getLifeline();
            senderLifelineCopy.getElements().move(senderLifelineCopy.getElements().size() - 1, sendEventCopy);
            receiverLifelineCopy.getElements().move(receiverLifelineCopy.getElements().size() - 1, receiveEventCopy);
        }
    }

    private void sortMessages(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice, IMerger merger) {
        Message msgCopy;
        Message msg;
        for (MergePosition mp : mergeAdvice.getMergePositions()) {
            msg = null;
            msgCopy = null;
            if (mp.getType().equals((Object)MergeType.O)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getOriginModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else if (mp.getType().equals((Object)MergeType.L)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getLeftModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else if (mp.getType().equals((Object)MergeType.R)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getRightModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else {
                logger.log(Level.SEVERE, "Message with mergeType {0} on index {1} not found.", new Object[]{mp.getType(), mp.getIndex()});
            }
            msgCopy = (Message)merger.getCorrespondingMergedObject(msg);
            if (msgCopy == null) {
                msgCopy = this.findMessageByFragment(msg);
            }
            SendEvent sendEventCopy = msgCopy.getSender();
            ReceiveEvent receiveEventCopy = msgCopy.getReceiver();
            Lifeline senderLifelineCopy = sendEventCopy.getLifeline();
            Lifeline receiverLifelineCopy = receiveEventCopy.getLifeline();
            senderLifelineCopy.getElements().move(senderLifelineCopy.getElements().size() - 1, sendEventCopy);
            receiverLifelineCopy.getElements().move(receiverLifelineCopy.getElements().size() - 1, receiveEventCopy);
        }
        for (MergePosition mp : mergeAdvice.getMergePositions()) {
            msg = null;
            msgCopy = null;
            if (mp.getType().equals((Object)MergeType.O)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getOriginModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else if (mp.getType().equals((Object)MergeType.L)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getLeftModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else if (mp.getType().equals((Object)MergeType.R)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getRightModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else {
                logger.log(Level.SEVERE, "Message with mergeType {0} on index {1} not found.", new Object[]{mp.getType(), mp.getIndex()});
            }
            msgCopy = (Message)merger.getCorrespondingMergedObject(msg);
            if (msgCopy == null) {
                msgCopy = this.findMessageByFragment(msg);
            }
            if (((Message)this.mergedModel.getSequenceview().getOrderedMessages().get(mp.getIndex() - 1)).equals(msgCopy)) continue;
            logger.log(Level.SEVERE, "Message {0} found on Position {2}, but Message {1} expected.", new Object[]{this.mergedModel.getSequenceview().getOrderedMessages().get(mp.getIndex() - 1), msgCopy, mp.getIndex() - 1});
        }
    }

    private boolean checkSorting(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice) {
        for (MergePosition mp : mergeAdvice.getMergePositions()) {
            Message msg = null;
            Message msgCopy = null;
            Message msgMerged = null;
            if (mp.getType().equals((Object)MergeType.O)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getOriginModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else if (mp.getType().equals((Object)MergeType.L)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getLeftModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else if (mp.getType().equals((Object)MergeType.R)) {
                msg = (Message)((MultiviewModel)threeWayDiff.getRightModel().get(0)).getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            } else {
                logger.log(Level.SEVERE, "Message with mergeType {0} on index {1} not found.", new Object[]{mp.getType(), mp.getIndex()});
                return false;
            }
            msgCopy = this.findMessageByFragment(msg);
            msgMerged = (Message)this.mergedModel.getSequenceview().getOrderedMessages().get(mp.getIndex() - 1);
            if (msgMerged.equals(msgCopy)) continue;
            logger.log(Level.SEVERE, "Message {0} found on Position {2}, but Message {1} expected.", new Object[]{this.mergedModel.getSequenceview().getOrderedMessages().get(mp.getIndex() - 1), msgCopy, mp.getIndex() - 1});
            return false;
        }
        return true;
    }

    private EList<DiffElement> getChangesToMerge(ThreeWayDiffProvider threeWayDiff) {
        BasicEList<DiffElement> diffs = new BasicEList<DiffElement>();
        EList<EObject> allLeftImplicitlyAddedObjects = threeWayDiff.getAddedEObjects(Side.LEFT, true);
        EList<EObject> allRightImplicitlyAddedObjects = threeWayDiff.getAddedEObjects(Side.RIGHT, true);
        for (DiffElement diff : threeWayDiff.getEffectiveDiffElements(Side.LEFT)) {
            diffs.add(diff);
        }
        for (DiffElement diff : threeWayDiff.getEffectiveDiffElements(Side.RIGHT)) {
            diffs.add(diff);
        }
        return diffs;
    }

    private Message findMessageByFragment(Message msg) {
        for (Message o : this.mergedModel.getSequenceview().getMessages()) {
            if (!EcoreUtil.getURI(o).fragment().equals(EcoreUtil.getURI(msg).fragment()) || !(o instanceof Message)) continue;
            return o;
        }
        return null;
    }

    private EObject findEObjectByFragment(EObject eObject, EList<EObject> list) {
        for (EObject o : list) {
            if (!EcoreUtil.getURI(o).fragment().equals(EcoreUtil.getURI(eObject).fragment())) continue;
            return o;
        }
        return null;
    }
}

