/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.modelgenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.modelevolution.multiview.Class;
import org.modelevolution.multiview.ClassView;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.LifelineElement;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelversioning.core.impl.UUIDResourceFactoryImpl;

public class SequenceGenerator {
    public static final String FILE_EXTENSION = "mvml";
    public static final boolean IGNORE_EFFECTS = false;
    private static final boolean DEBUG = false;
    private Random random;
    private Resource resource;
    private ResourceSet resourceSet;
    private ClassView classView;
    private SequenceView sequenceView;
    private Map<Lifeline, State> currentStates;
    private Set<Symbol> effects;
    private File file;
    private MultiviewModel mvmodel;

    public SequenceGenerator(File file, Random random) {
        this.random = random;
        this.file = file;
        EPackage.Registry.INSTANCE.put(MultiviewPackage.eINSTANCE.getNsURI(), MultiviewPackage.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(FILE_EXTENSION, new UUIDResourceFactoryImpl());
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(FILE_EXTENSION, new UUIDResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new UUIDResourceFactoryImpl());
        URI fileURI_id = URI.createFileURI(file.getAbsolutePath());
        this.resource = this.resourceSet.getResource(fileURI_id, true);
        this.mvmodel = (MultiviewModel)this.resource.getContents().get(0);
        if (this.mvmodel.getStateview() == null || this.mvmodel.getClassview() == null) {
            System.err.println("Cannot create SequenceGenerator because there is no State Machine");
            return;
        }
        this.classView = this.mvmodel.getClassview();
        if (this.mvmodel.getSequenceview() == null) {
            this.sequenceView = MultiviewFactory.eINSTANCE.createSequenceView();
            this.mvmodel.setSequenceview(this.sequenceView);
        } else {
            this.sequenceView = this.mvmodel.getSequenceview();
            for (Lifeline lifeline : this.sequenceView.getLifelines()) {
                if (lifeline.getClass_() != null && lifeline.getClass_().getStatemachine() != null) continue;
                lifeline.initDummyStatemachine();
            }
        }
        this.effects = new HashSet<Symbol>();
        StateView stateView = this.mvmodel.getStateview();
        for (Region statemachine : stateView.getStatemachines()) {
            for (State state : statemachine.getStates()) {
                for (Transition transition : state.getIncoming()) {
                    for (Symbol effect : transition.getEffects()) {
                        this.effects.add(effect);
                    }
                }
            }
        }
    }

    public File generateSequence(int nrLifelines, int nrMessages, boolean copy, String filename) {
        System.out.println("Generating " + nrLifelines + " lifelines");
        this.generateLifelines(nrLifelines);
        this.setCurrentStates();
        System.out.println("Generating " + nrMessages + " messages");
        this.generateMessages(nrMessages);
        if (copy) {
            File newFile = new File(filename);
            URI fileURI = URI.createFileURI(newFile.getAbsolutePath());
            Resource newResource = this.resourceSet.createResource(fileURI);
            newResource.getContents().add(this.mvmodel);
            try {
                newResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return newFile;
        }
        try {
            this.resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.file;
    }

    private void generateMessages(int nrMessages) {
        int i = 0;
        Message message = this.getMessage();
        if (message != null) {
            this.sequenceView.getMessages().add(message);
        }
        while (i < nrMessages && message != null) {
            message = this.getMessage();
            if (message != null) {
                this.sequenceView.getMessages().add(message);
            }
            ++i;
        }
        if (message == null && i < nrMessages) {
            System.err.println(" Due to deadlock only " + i + " messages out of " + nrMessages + " could be generated.");
        }
    }

    private Message getMessage() {
        Lifeline receiveLL;
        boolean emptyOK = true;
        if (this.sequenceView.getMessages().size() > 0) {
            emptyOK = this.random.nextBoolean();
        }
        if ((receiveLL = this.getReceiverLifeline(emptyOK)) == null) {
            return null;
        }
        Symbol body = this.getSymbol(receiveLL);
        if (body == null) {
            return null;
        }
        emptyOK = receiveLL.getElements().size() != 1 || this.sequenceView.getMessages().size() <= 1;
        Lifeline sendLL = this.getSenderLifeline(body, emptyOK);
        if (sendLL == null) {
            return null;
        }
        SendEvent sendEvent = MultiviewFactory.eINSTANCE.createSendEvent();
        sendEvent.setName(this.getSendEventName(body, sendLL));
        sendEvent.setLifeline(sendLL);
        ReceiveEvent receiveEvent = MultiviewFactory.eINSTANCE.createReceiveEvent();
        receiveEvent.setName(this.getReceiveEventName(body, receiveLL));
        receiveEvent.setLifeline(receiveLL);
        Message message = MultiviewFactory.eINSTANCE.createMessage();
        message.setReceiver(receiveEvent);
        message.setBody(body);
        message.setSender(sendEvent);
        return message;
    }

    private Lifeline getReceiverLifeline(boolean emptyOK) {
        Lifeline lifeline2;
        ArrayList<Lifeline> possibleLifelines = new ArrayList<Lifeline>();
        for (Lifeline lifeline2 : this.currentStates.keySet()) {
            if (this.currentStates.get(lifeline2) != null && this.currentStates.get(lifeline2).getOutgoing().size() <= 0 || !emptyOK && lifeline2.getElements().size() <= 0) continue;
            possibleLifelines.add(lifeline2);
        }
        if (possibleLifelines.size() == 0) {
            return null;
        }
        lifeline2 = (Lifeline)possibleLifelines.get(this.random.nextInt(possibleLifelines.size()));
        return lifeline2;
    }

    private Lifeline getSenderLifeline(Symbol symbol, boolean emptyOK) {
        Lifeline lifeline2;
        ArrayList<Lifeline> possibleLifelines = new ArrayList<Lifeline>();
        for (Lifeline lifeline2 : this.sequenceView.getLifelines()) {
            if (!this.effectInStatemachine(symbol, lifeline2.getClass_().getStatemachine()) || !emptyOK && lifeline2.getElements().size() <= 0) continue;
            possibleLifelines.add(lifeline2);
        }
        if (possibleLifelines.size() == 0) {
            return null;
        }
        lifeline2 = (Lifeline)possibleLifelines.get(this.random.nextInt(possibleLifelines.size()));
        return lifeline2;
    }

    private boolean effectInStatemachine(Symbol effect, Region statemachine) {
        for (State state : statemachine.getStates()) {
            for (Transition transition : state.getIncoming()) {
                if (!transition.getEffects().contains(effect)) continue;
                return true;
            }
        }
        return false;
    }

    private void setCurrentStates() {
        this.currentStates = new HashMap<Lifeline, State>();
        for (Lifeline lifeline : this.sequenceView.getLifelines()) {
            if (lifeline.getElements().isEmpty()) {
                this.currentStates.put(lifeline, null);
                continue;
            }
            State state = this.getCurrentState(lifeline);
            this.currentStates.put(lifeline, state);
        }
    }

    private void generateLifelines(int nrLifelines) {
        Lifeline lifeline;
        Class class_;
        Iterator iterator = this.classView.getClasses().iterator();
        int i = 0;
        while (i < nrLifelines && iterator.hasNext()) {
            class_ = (Class)iterator.next();
            if (class_.getStatemachine() != null) {
                lifeline = MultiviewFactory.eINSTANCE.createLifeline();
                lifeline.setClass(class_);
                lifeline.setName(this.getLLName(class_.getName()));
                this.sequenceView.getLifelines().add(lifeline);
            }
            ++i;
        }
        while (i < nrLifelines) {
            class_ = (Class)this.classView.getClasses().get(this.random.nextInt(this.classView.getClasses().size()));
            if (class_.getStatemachine() != null) {
                lifeline = MultiviewFactory.eINSTANCE.createLifeline();
                lifeline.setClass(class_);
                lifeline.setName(this.getLLName(class_.getName()));
                this.sequenceView.getLifelines().add(lifeline);
            }
            ++i;
        }
    }

    private String getLLName(String name) {
        return String.valueOf(name) + "-" + this.sequenceView.getLifelines().size();
    }

    private String getReceiveEventName(Symbol body, Lifeline lifeline) {
        return "RCV-" + body.getName() + "-" + lifeline.getElements().size();
    }

    private String getSendEventName(Symbol body, Lifeline lifeline) {
        return "SND-" + body.getName() + "-" + lifeline.getElements().size();
    }

    private State getCurrentState(Lifeline lifeline) {
        List<Message> messages = this.getMessages(lifeline);
        Region sm = lifeline.getClass_().getStatemachine();
        if (messages.isEmpty()) {
            return null;
        }
        List<State> startStates = this.getStartStates(sm, messages.get(0));
        if (startStates.isEmpty()) {
            return null;
        }
        State state = this.searchPaths(startStates, messages);
        return state;
    }

    private List<Message> getMessages(Lifeline lifeline) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (lifeline != null) {
            for (LifelineElement le : lifeline.getElements()) {
                if (!(le instanceof ReceiveEvent)) continue;
                messages.add(((ReceiveEvent)le).getMessage());
            }
        }
        return messages;
    }

    private List<State> getStartStates(Region sm, Message m) {
        ArrayList<State> states = new ArrayList<State>();
        for (State state : sm.getStates()) {
            for (Transition t : state.getIncoming()) {
                if (t.getSource() == null || !t.getTrigger().equals(m.getBody())) continue;
                states.add(state);
            }
        }
        return states;
    }

    private State searchPaths(List<State> startStates, List<Message> messages) {
        State state = null;
        Collections.shuffle(startStates);
        Iterator<State> iterator = startStates.iterator();
        while (state == null && iterator.hasNext()) {
            state = this.searchPath(iterator.next(), messages);
        }
        return state;
    }

    private State searchPath(State start, List<Message> messages) {
        int index = 1;
        State currState = start;
        while (index < messages.size()) {
            Message currMessage = messages.get(index);
            if ((currState = this.getNextState(currState, currMessage)) == null) {
                return currState;
            }
            ++index;
        }
        return currState;
    }

    private State getNextState(State state, Message m) {
        State next = null;
        for (Transition outTrans : state.getOutgoing()) {
            if (!outTrans.getTrigger().equals(m.getBody())) continue;
            next = outTrans.getTarget();
        }
        return next;
    }

    private Symbol getSymbol(Lifeline receiveLL) {
        Transition transition2;
        State state = this.currentStates.get(receiveLL);
        ArrayList<Transition> possibleTransitions = new ArrayList<Transition>();
        List<Transition> transitions = state == null ? this.getTransitions(receiveLL.getClass_().getStatemachine()) : state.getOutgoing();
        for (Transition transition2 : transitions) {
            if (!this.effects.contains(transition2.getTrigger())) continue;
            possibleTransitions.add(transition2);
        }
        if (possibleTransitions.size() == 0) {
            return null;
        }
        transition2 = (Transition)possibleTransitions.get(this.random.nextInt(possibleTransitions.size()));
        this.currentStates.put(receiveLL, transition2.getTarget());
        return transition2.getTrigger();
    }

    private List<Transition> getTransitions(Region statemachine) {
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (State state : statemachine.getStates()) {
            for (Transition transition : state.getIncoming()) {
                transitions.add(transition);
            }
        }
        return transitions;
    }
}

