/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.modelgenerator;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.modelevolution.multiview.Class;
import org.modelevolution.multiview.ClassView;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.modelgenerator.Bounds;
import org.modelversioning.core.impl.UUIDResourceFactoryImpl;

public class StatemachineGenerator {
    private static final String FILE_EXTENSION = "mvml";
    private static final String PATH = "~/Documents/SVN-FAME/dev/test/org.modelevolution.core.diff.encoding.test/models/";
    private static final double PROB_NEW_SYMBOL = 0.0;
    private static final int MAX_NUMBER_EFFECTS = 4;
    private Random random;
    private EList<Symbol> alphabet;
    private MultiviewModel mvmodel;
    private StateView stateView;
    private ClassView classView;
    private Resource resource;
    private ResourceSet resourceSet;
    private File file;

    public StatemachineGenerator(String filename, Random random) {
        this.random = random;
        this.file = new File(filename);
        URI fileURI_id = URI.createFileURI(this.file.getAbsolutePath());
        this.resourceSet = this.getResourceSet();
        this.resource = this.resourceSet.createResource(fileURI_id);
        this.mvmodel = MultiviewFactory.eINSTANCE.createMultiviewModel();
        this.resource.getContents().add(this.mvmodel);
        this.setUp();
    }

    public StatemachineGenerator(File file, Random random) {
        this.random = random;
        this.file = file;
        URI fileURI_id = URI.createFileURI(file.getAbsolutePath());
        this.resourceSet = this.getResourceSet();
        this.resource = this.resourceSet.getResource(fileURI_id, true);
        this.mvmodel = (MultiviewModel)this.resource.getContents().get(0);
        this.setUp();
    }

    private void setUp() {
        if (this.mvmodel.getClassview() == null) {
            this.classView = MultiviewFactory.eINSTANCE.createClassView();
            this.mvmodel.setClassview(this.classView);
        } else {
            this.classView = this.mvmodel.getClassview();
        }
        if (this.mvmodel.getStateview() == null) {
            this.stateView = MultiviewFactory.eINSTANCE.createStateView();
            this.mvmodel.setStateview(this.stateView);
        } else {
            this.stateView = this.mvmodel.getStateview();
        }
        this.instantiateAlphabet(this.stateView);
        this.alphabet = this.mvmodel.getStateview().getAlphabet();
    }

    private ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            EPackage.Registry.INSTANCE.put(MultiviewPackage.eINSTANCE.getNsURI(), MultiviewPackage.eINSTANCE);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(FILE_EXTENSION, new UUIDResourceFactoryImpl());
            this.resourceSet = new ResourceSetImpl();
            this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(FILE_EXTENSION, new UUIDResourceFactoryImpl());
            this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new UUIDResourceFactoryImpl());
        }
        return this.resourceSet;
    }

    private void instantiateAlphabet(StateView stateView) {
        if (stateView.getAlphabet().isEmpty()) {
            Symbol symbol1 = MultiviewFactory.eINSTANCE.createSymbol();
            symbol1.setName("1");
            stateView.getAlphabet().add(symbol1);
            Symbol symbol2 = MultiviewFactory.eINSTANCE.createSymbol();
            symbol2.setName("2");
            stateView.getAlphabet().add(symbol2);
        }
    }

    public File generateStatemachine(Bounds states, Bounds transitions, boolean copy, String filename) {
        int nrStates = this.random.nextInt(states.getUpper() - states.getLower() + 1) + states.getLower();
        int nrTransitions = this.random.nextInt(transitions.getUpper() - transitions.getLower() + 1) + transitions.getLower();
        return this.generateStatemachine(nrStates, nrTransitions, copy, filename);
    }

    public File generateStatemachine(int nrStates, int nrTransitions, boolean copy, String filename) {
        String name = Long.toString(System.currentTimeMillis());
        System.out.println("Generating " + nrStates + " states");
        System.out.println("Generating " + nrTransitions + " transitions");
        Region statemachine = this.getRandomStatemachine(nrStates, nrTransitions, this.stateView);
        statemachine.setName(name);
        Class class_ = MultiviewFactory.eINSTANCE.createClass();
        class_.setName(name);
        this.classView.getClasses().add(class_);
        class_.setStatemachine(statemachine);
        this.stateView.getStatemachines().add(statemachine);
        if (copy) {
            File newFile = new File(filename);
            URI fileURI = URI.createFileURI(newFile.getAbsolutePath());
            Resource newResource = this.resourceSet.createResource(fileURI);
            newResource.getContents().add(this.mvmodel);
            try {
                newResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return newFile;
        }
        try {
            this.resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.file;
    }

    private Region getRandomStatemachine(int nrStates, int nrTransitions, StateView stateView) {
        int j;
        Transition transition;
        Region statemachine = MultiviewFactory.eINSTANCE.createRegion();
        System.out.println("Generating " + nrStates + " states");
        int i = 0;
        while (i < nrStates) {
            State state = MultiviewFactory.eINSTANCE.createState();
            state.setName(Integer.toString(i));
            statemachine.getStates().add(state);
            ++i;
        }
        System.out.println("Generating " + nrTransitions + " transitions");
        Iterator iterator = statemachine.getStates().iterator();
        int i2 = 0;
        int nrEffects = 0;
        while (i2 < nrTransitions && iterator.hasNext()) {
            transition = MultiviewFactory.eINSTANCE.createTransition();
            nrEffects = this.random.nextInt(4);
            if (this.random.nextDouble() < 0.5) {
                transition.setSource((State)iterator.next());
                transition.setTarget((State)statemachine.getStates().get(this.random.nextInt(statemachine.getStates().size())));
            } else {
                transition.setTarget((State)iterator.next());
                transition.setSource((State)statemachine.getStates().get(this.random.nextInt(statemachine.getStates().size())));
            }
            transition.setTrigger(this.getSymbol(transition.getSource(), false));
            j = 0;
            while (j < nrEffects) {
                transition.getEffects().add(this.getSymbol(transition.getSource(), false));
                ++j;
            }
            ++i2;
        }
        while (i2 < nrTransitions) {
            transition = MultiviewFactory.eINSTANCE.createTransition();
            nrEffects = this.random.nextInt(4);
            transition.setTarget((State)statemachine.getStates().get(this.random.nextInt(statemachine.getStates().size())));
            transition.setSource((State)statemachine.getStates().get(this.random.nextInt(statemachine.getStates().size())));
            transition.setTrigger(this.getSymbol(transition.getSource(), false));
            j = 0;
            while (j < nrEffects) {
                transition.getEffects().add(this.getSymbol(transition.getSource(), false));
                ++j;
            }
            ++i2;
        }
        return statemachine;
    }

    private Symbol getSymbol(State origin, boolean createNew) {
        Symbol symbol;
        if (createNew || this.random.nextDouble() < 0.0) {
            int label = this.alphabet.size() + 1;
            symbol = MultiviewFactory.eINSTANCE.createSymbol();
            symbol.setName(Integer.toString(label));
            this.alphabet.add(symbol);
        } else {
            symbol = (Symbol)this.alphabet.get(this.random.nextInt(this.alphabet.size()));
        }
        for (Transition trans : origin.getOutgoing()) {
            if (trans.getTrigger() == null || !trans.getTrigger().equals(symbol)) continue;
            return this.getSymbol(origin, true);
        }
        return symbol;
    }
}

