/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflictreport.conflict;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ViolationSeverity implements Enumerator
{
    INFO(0, "INFO", "INFO"),
    WARNING(1, "WARNING", "WARNING"),
    ERROR(2, "ERROR", "ERROR");

    public static final int INFO_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int ERROR_VALUE = 2;
    private static final ViolationSeverity[] VALUES_ARRAY;
    public static final List<ViolationSeverity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ViolationSeverity[]{INFO, WARNING, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ViolationSeverity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ViolationSeverity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ViolationSeverity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ViolationSeverity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ViolationSeverity get(int value) {
        switch (value) {
            case 0: {
                return INFO;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return ERROR;
            }
        }
        return null;
    }

    private ViolationSeverity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

