/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.conflictreport.ConflictReport;
import org.modelversioning.conflictreport.ConflictReportFactory;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.conflicts.detection.engine.IConflictDetectionEngine;
import org.modelversioning.conflicts.detection.engine.IOverlappingChangeDetector;
import org.modelversioning.conflicts.detection.engine.IViolationDetector;
import org.modelversioning.conflicts.detection.impl.DeleteUpdateConflictDetector;
import org.modelversioning.conflicts.detection.impl.DeleteUseConflictDetector;
import org.modelversioning.conflicts.detection.impl.MoveMoveConflictDetector;
import org.modelversioning.conflicts.detection.impl.OperationContractViolationDetector;
import org.modelversioning.conflicts.detection.impl.UpdateUpdateConflictDetector;
import org.modelversioning.merge.IMerger;
import org.modelversioning.merge.impl.MergerImpl;

public class ConflictDetectionEngineImpl
implements IConflictDetectionEngine {
    private List<IOverlappingChangeDetector> overlappingChangeDetectors = new ArrayList<IOverlappingChangeDetector>();
    private List<IViolationDetector> violationDetectors = new ArrayList<IViolationDetector>();
    private boolean operationContractViolationAware = true;
    private OperationContractViolationDetector operationContractViolationDetector = new OperationContractViolationDetector();
    private IMerger merger = new MergerImpl();

    public ConflictDetectionEngineImpl() {
        this.overlappingChangeDetectors.add(new UpdateUpdateConflictDetector());
        this.overlappingChangeDetectors.add(new DeleteUpdateConflictDetector());
        this.overlappingChangeDetectors.add(new DeleteUseConflictDetector());
        this.overlappingChangeDetectors.add(new MoveMoveConflictDetector());
    }

    public ConflictDetectionEngineImpl(List<IOverlappingChangeDetector> overlappingChangeDetectors, List<IViolationDetector> violationDetectors) {
        this.overlappingChangeDetectors.addAll(overlappingChangeDetectors);
        this.violationDetectors.addAll(violationDetectors);
    }

    public boolean isOperationContractViolationAware() {
        return this.operationContractViolationAware;
    }

    public void setOperationContractViolationAware(boolean operationContractViolationAware) {
        this.operationContractViolationAware = operationContractViolationAware;
    }

    @Override
    public ConflictReport detectConflicts(IThreeWayDiffProvider threeWayDiff, IProgressMonitor monitor) {
        ConflictReport report = ConflictReportFactory.eINSTANCE.createConflictReport();
        this.detectConflicts(threeWayDiff, report.getConflicts(), report.getEquivalentChanges(), monitor);
        report.setLeftVersion(threeWayDiff.getComparisonSnapshot(Side.LEFT));
        report.setRightVersion(threeWayDiff.getComparisonSnapshot(Side.RIGHT));
        return report;
    }

    private void detectConflicts(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor) {
        int additionalTicks = this.operationContractViolationAware ? 1 : 0;
        monitor.beginTask("Detecting Conflicts", this.overlappingChangeDetectors.size() + this.violationDetectors.size() + additionalTicks);
        try {
            for (IOverlappingChangeDetector detector : this.overlappingChangeDetectors) {
                monitor.subTask(detector.getName());
                detector.initialize();
                detector.detectOverlappingChanges(threeWayDiff, conflicts, equivalentChanges, new SubProgressMonitor(monitor, 1));
                monitor.worked(1);
            }
            if (this.operationContractViolationAware) {
                this.operationContractViolationDetector.detectOperationContractViolations(threeWayDiff, conflicts, equivalentChanges, new SubProgressMonitor(monitor, 1));
                monitor.worked(1);
            }
            if (this.violationDetectors.size() > 0) {
                Resource mergedModel = null;
                for (IViolationDetector detector : this.violationDetectors) {
                    monitor.subTask(detector.getName());
                    detector.initialize();
                    detector.detectViolations(mergedModel, threeWayDiff, conflicts, equivalentChanges, new SubProgressMonitor(monitor, 1));
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IOverlappingChangeDetector> getOverlappingChangeDetectors() {
        return this.overlappingChangeDetectors;
    }

    @Override
    public List<IViolationDetector> getViolationDetectors() {
        return this.violationDetectors;
    }
}

