/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflictreport.conflict.DeleteUpdate;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.conflicts.detection.engine.IOverlappingChangeDetector;
import org.modelversioning.core.util.EcoreUtil;

public class DeleteUpdateConflictDetector
implements IOverlappingChangeDetector {
    private static final String DIFF_HASH_SEP = "|";
    private static final String NAME = "Delete Update Conflict Detector";
    private Set<DiffElement> ignoredDiffElements = new HashSet<DiffElement>();
    private Set<String> reportedConflictHashes = new HashSet<String>();

    @Override
    public String getId() {
        return "org.modelversioning.conflicts.detection.deleteUpdate";
    }

    @Override
    public String getTargetModelNsURI() {
        return "*";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void detectOverlappingChanges(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor) {
        this.ignoredDiffElements.clear();
        this.reportedConflictHashes.clear();
        monitor.beginTask("Searching for Delete Update conflicts", 2);
        try {
            this.findConflicts(threeWayDiff, conflicts, equivalentChanges, new SubProgressMonitor(monitor, 1), Side.LEFT);
            this.findConflicts(threeWayDiff, conflicts, equivalentChanges, new SubProgressMonitor(monitor, 1), Side.RIGHT);
        }
        finally {
            monitor.done();
        }
    }

    private void findConflicts(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor, Side side) {
        Side opposite = Side.LEFT.equals(side) ? Side.RIGHT : Side.LEFT;
        EList<EObject> updatedEObjects = threeWayDiff.getUpdatedEObjects(side, true);
        monitor.beginTask("Examining " + side + " updates", updatedEObjects.size());
        try {
            for (EObject updatedObject : updatedEObjects) {
                if (threeWayDiff.isDeleted(updatedObject, opposite, true)) {
                    Set<DiffElement> updateElements = threeWayDiff.getUpdateElements(updatedObject, side);
                    ModelElementChange deleteElement = threeWayDiff.getDeleteElement(updatedObject, opposite);
                    for (DiffElement updateElement : updateElements) {
                        this.checkIfConflicting(conflicts, equivalentChanges, side, deleteElement, updateElement);
                    }
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void checkIfConflicting(EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, Side side, ModelElementChange deleteElement, DiffElement diffElement) {
        if (!(this._shouldIgnore(diffElement, deleteElement, equivalentChanges, side) || this.shouldIgnore(diffElement) || this.shouldIgnore(deleteElement) || this.shouldIgnore(diffElement, deleteElement))) {
            DeleteUpdate deleteUpdate = CONFLICT_FACTORY.createDeleteUpdate();
            if (Side.LEFT.equals(side)) {
                deleteUpdate.setLeftChange(diffElement);
                deleteUpdate.setRightChange(deleteElement);
            } else {
                deleteUpdate.setRightChange(diffElement);
                deleteUpdate.setLeftChange(deleteElement);
            }
            this.addToReportedConflicts(deleteUpdate);
            conflicts.add(deleteUpdate);
        }
    }

    private String toHash(DiffElement diffElement1, DiffElement diffElement2) {
        return String.valueOf(diffElement1.hashCode()) + DIFF_HASH_SEP + diffElement2.hashCode();
    }

    private void addToReportedConflicts(DeleteUpdate deleteUpdate) {
        this.reportedConflictHashes.add(this.toHash(deleteUpdate.getLeftChange(), deleteUpdate.getRightChange()));
        this.reportedConflictHashes.add(this.toHash(deleteUpdate.getRightChange(), deleteUpdate.getLeftChange()));
    }

    private boolean haveAlreadyReported(DiffElement diffElement1, DiffElement diffElement2) {
        String hash = this.toHash(diffElement1, diffElement2);
        return this.reportedConflictHashes.contains(hash);
    }

    private boolean _shouldIgnore(DiffElement updateElement, ModelElementChange modelElementChange, EList<EquivalentChange> equivalentChanges, Side updateSide) {
        if (this.haveAlreadyReported(updateElement, modelElementChange)) {
            return true;
        }
        if (modelElementChange instanceof ModelElementChangeRightTarget) {
            ModelElementChangeRightTarget updateAsDeletion;
            EObject deletedObjectByUpdate;
            UpdateReference updateReference;
            ModelElementChangeRightTarget deleteElement = (ModelElementChangeRightTarget)modelElementChange;
            EObject deletedObject = deleteElement.getRightElement();
            if (updateElement instanceof MoveModelElement || updateElement instanceof ReferenceChangeRightTarget) {
                return true;
            }
            if (updateElement instanceof UpdateReference && (updateReference = (UpdateReference)updateElement).getLeftElement().eGet(updateReference.getReference()) == null) {
                return true;
            }
            if (updateElement instanceof ModelElementChangeRightTarget && ((deletedObjectByUpdate = (updateAsDeletion = (ModelElementChangeRightTarget)updateElement).getRightElement()).equals(deletedObject) || EcoreUtil.createParentList(deletedObjectByUpdate).contains(deletedObject))) {
                EquivalentChange equivalentChange = CONFLICT_REPORT_FACTORY.createEquivalentChange();
                if (Side.LEFT.equals(updateSide)) {
                    equivalentChange.setLeftChange(updateElement);
                    equivalentChange.setRightChange(deleteElement);
                    equivalentChange.setPreferSide(Side.RIGHT);
                } else {
                    equivalentChange.setRightChange(updateElement);
                    equivalentChange.setLeftChange(deleteElement);
                    equivalentChange.setPreferSide(Side.LEFT);
                }
                equivalentChanges.add(equivalentChange);
                return true;
            }
        }
        return false;
    }

    protected boolean shouldIgnore(DiffElement diffElement) {
        return this.ignoredDiffElements.contains(diffElement);
    }

    protected boolean shouldIgnore(DiffElement leftDiffElement, DiffElement rightDiffElement) {
        return false;
    }

    @Override
    public void initialize() {
    }
}

