/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FeatureUpdates {
    private Map<EStructuralFeature, Set<DiffElement>> featureUpdateMap = new HashMap<EStructuralFeature, Set<DiffElement>>();
    private Set<DiffElement> allDiffElements = new HashSet<DiffElement>();

    public void add(EStructuralFeature feature, DiffElement diffElement) {
        Set<Object> diffElements = null;
        if (this.featureUpdateMap.containsKey(feature)) {
            diffElements = this.featureUpdateMap.get(feature);
        } else {
            diffElements = new HashSet();
            this.featureUpdateMap.put(feature, diffElements);
        }
        diffElements.add(diffElement);
        this.allDiffElements.add(diffElement);
    }

    public void remove(EStructuralFeature feature) {
        this.allDiffElements.removeAll((Collection)this.featureUpdateMap.get(feature));
        this.featureUpdateMap.remove(feature);
    }

    public void remove(EStructuralFeature feature, DiffElement diffElement) {
        Set<DiffElement> diffElements = this.featureUpdateMap.get(feature);
        if (diffElements != null) {
            this.allDiffElements.remove(diffElement);
            diffElements.remove(diffElement);
            if (diffElements.size() == 0) {
                this.featureUpdateMap.remove(feature);
            }
        }
    }

    public Set<DiffElement> getDiffElements() {
        if (this.allDiffElements != null) {
            return this.allDiffElements;
        }
        return Collections.emptySet();
    }

    public Set<DiffElement> getDiffElements(EStructuralFeature feature) {
        Set<DiffElement> set = this.featureUpdateMap.get(feature);
        if (set != null) {
            return set;
        }
        return Collections.emptySet();
    }

    public boolean contains(EStructuralFeature feature) {
        return this.featureUpdateMap.containsKey(feature);
    }
}

