/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflictreport.conflict.MoveMove;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.conflicts.detection.engine.IOverlappingChangeDetector;
import org.modelversioning.core.util.EcoreUtil;

public class MoveMoveConflictDetector
implements IOverlappingChangeDetector {
    private static final String NAME = "Move Move Conflict Detector";

    @Override
    public String getId() {
        return "org.modelversioning.conflicts.detection.moveMove";
    }

    @Override
    public String getTargetModelNsURI() {
        return "*";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void detectOverlappingChanges(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor) {
        EList<EObject> movedEObjects = threeWayDiff.getMovedEObjects(Side.LEFT, false);
        monitor.beginTask("Searching for Move Move conflicts", movedEObjects.size());
        try {
            for (EObject movedObject : movedEObjects) {
                MoveModelElement leftMove = threeWayDiff.getMoveElement(movedObject, Side.LEFT);
                if (threeWayDiff.isMoved(movedObject, Side.RIGHT, false)) {
                    MoveModelElement rightMove = threeWayDiff.getMoveElement(movedObject, Side.RIGHT);
                    EObject leftTarget = threeWayDiff.getMatchingEObject(leftMove.getRightTarget(), Side.LEFT, true);
                    EObject rightTarget = threeWayDiff.getMatchingEObject(rightMove.getRightTarget(), Side.RIGHT, true);
                    if (leftTarget != null && rightTarget != null && leftTarget.equals(rightTarget)) {
                        if (leftMove.getLeftElement().eContainmentFeature().equals(rightMove.getLeftElement().eContainmentFeature())) {
                            EquivalentChange equivalentChange = CONFLICT_REPORT_FACTORY.createEquivalentChange();
                            equivalentChange.setLeftChange(leftMove);
                            equivalentChange.setRightChange(rightMove);
                            equivalentChange.setPreferSide(Side.LEFT);
                            equivalentChanges.add(equivalentChange);
                        } else {
                            this.raiseConflict(leftMove, rightMove, conflicts);
                        }
                    } else {
                        this.raiseConflict(leftMove, rightMove, conflicts);
                    }
                } else {
                    for (EObject rightMovedObject : threeWayDiff.getMovedEObjects(Side.RIGHT, false)) {
                        MoveModelElement rightMove = threeWayDiff.getMoveElement(rightMovedObject, Side.RIGHT);
                        if (rightMove.getRightTarget() != null && leftMove.getRightElement() != null && rightMove.getRightTarget().equals(leftMove.getRightElement())) {
                            this.raiseConflict(leftMove, rightMove, conflicts);
                            continue;
                        }
                        List<EObject> rightTargetParents = EcoreUtil.createParentList(rightMove.getRightTarget());
                        if (!rightTargetParents.contains(leftMove.getRightElement())) continue;
                        this.raiseConflict(leftMove, rightMove, conflicts);
                    }
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void raiseConflict(MoveModelElement leftMove, MoveModelElement rightMove, EList<Conflict> conflicts) {
        MoveMove moveMove = CONFLICT_FACTORY.createMoveMove();
        moveMove.setLeftChange(leftMove);
        moveMove.setRightChange(rightMove);
        conflicts.add(moveMove);
    }

    @Override
    public void initialize() {
    }
}

