/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.BindingSizeDifference;
import org.modelversioning.conflictreport.conflict.ConditionViolation;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflictreport.conflict.ConflictFactory;
import org.modelversioning.conflictreport.conflict.DifferentBindingSize;
import org.modelversioning.conflictreport.conflict.MatchingNegativeApplicationCondition;
import org.modelversioning.conflictreport.conflict.MissingObject;
import org.modelversioning.conflictreport.conflict.OperationContractDiagnostics;
import org.modelversioning.conflictreport.conflict.OperationContractViolation;
import org.modelversioning.conflictreport.conflict.ViolatedPrecondition;
import org.modelversioning.conflictreport.conflict.ViolationSeverity;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.EvaluationResult;
import org.modelversioning.core.conditions.FeatureCondition;
import org.modelversioning.core.conditions.RefinementTemplate;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.UnsupportedConditionLanguage;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingsImpl;
import org.modelversioning.core.conditions.templatebindings.TemplateBinding;
import org.modelversioning.core.conditions.templatebindings.TemplateBindingCollection;
import org.modelversioning.core.conditions.templatebindings.util.TemplateBindingsUtil;
import org.modelversioning.core.conditions.util.ConditionsUtil;
import org.modelversioning.operations.NegativeApplicationConditionResult;
import org.modelversioning.operations.OperationSpecification;
import org.modelversioning.operations.detection.operationoccurrence.OperationOccurrence;
import org.modelversioning.operations.execution.IOperationBinding;
import org.modelversioning.operations.execution.engines.IOperationBindingGenerator;
import org.modelversioning.operations.execution.engines.impl.OperationBindingGeneratorImpl;
import org.modelversioning.operations.util.OperationsUtil;

public class OperationContractViolationDetector {
    IOperationBindingGenerator bindingGenerator;
    private Map<OperationOccurrence, ITemplateBinding> unselectedBindingMap;

    protected IOperationBindingGenerator getOperationBindingGenerator() {
        if (this.bindingGenerator == null) {
            this.bindingGenerator = new OperationBindingGeneratorImpl();
        }
        return this.bindingGenerator;
    }

    protected void setOperationBindingGenerator(IOperationBindingGenerator bindingGenerator) {
        this.bindingGenerator = bindingGenerator;
    }

    public void detectOperationContractViolations(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, SubProgressMonitor subProgressMonitor) {
        this.unselectedBindingMap = new HashMap<OperationOccurrence, ITemplateBinding>();
        Set<OperationOccurrence> leftOccurrences = this.getOperationOccurrences(threeWayDiff.getComparisonSnapshot(Side.LEFT));
        Set<OperationOccurrence> rightOccurrences = this.getOperationOccurrences(threeWayDiff.getComparisonSnapshot(Side.RIGHT));
        try {
            this.fillUnselectedBindingMap(leftOccurrences);
            this.fillUnselectedBindingMap(rightOccurrences);
            this.doDetectOperationContractViolations(leftOccurrences, threeWayDiff, conflicts, Side.LEFT);
            this.doDetectOperationContractViolations(rightOccurrences, threeWayDiff, conflicts, Side.RIGHT);
        }
        catch (UnsupportedConditionLanguage e) {
            e.printStackTrace();
        }
    }

    private void doDetectOperationContractViolations(Set<OperationOccurrence> occurrences, IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, Side side) throws UnsupportedConditionLanguage {
        Side oppositeSide = this.getOppositeSide(side);
        for (OperationOccurrence occurrence : occurrences) {
            try {
                ITemplateBindings rewiredTemplateBinding = this.rewireBinding(occurrence.getPreConditionBinding(), threeWayDiff, oppositeSide);
                ITemplateBinding preBinding = this.createFixedPreBinding(rewiredTemplateBinding, occurrence.getAppliedOperation());
                IOperationBinding operationBinding = this.getOperationBindingGenerator().generateOperationBinding(occurrence.getAppliedOperation(), preBinding);
                if (!operationBinding.validate().isOK()) {
                    throw new InvalidOperationBindingException(operationBinding);
                }
                ITemplateBindings allPossibleBindings = operationBinding.getTemplateBinding();
                ITemplateBinding unselectedBinding = this.unselectedBindingMap.get(occurrence);
                this.removeUnselectedBindings(allPossibleBindings, unselectedBinding, rewiredTemplateBinding, threeWayDiff, oppositeSide);
                this.checkForDifferentBindingSize(allPossibleBindings, rewiredTemplateBinding, conflicts, occurrence, side);
            }
            catch (MissingObjectsForBindingException e) {
                this.handleMissingObjects(e.getMissingObjects(), occurrence, threeWayDiff, conflicts, side);
            }
            catch (InvalidOperationBindingException e) {
                this.handleInvalidOperationBinding(e.operationBinding, occurrence, threeWayDiff, conflicts, side);
            }
            catch (UnselectBindingsFailedException e) {
                this.handleFailingUnselectionFromBinding(e.getOriginalRewiredBinding(), occurrence, threeWayDiff, conflicts, side);
            }
        }
    }

    private Side getOppositeSide(Side side) {
        return Side.LEFT.equals(side) ? Side.RIGHT : Side.LEFT;
    }

    private void handleFailingUnselectionFromBinding(ITemplateBindings originalRewiredBinding, OperationOccurrence occurrence, IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, Side side) throws UnsupportedConditionLanguage {
        IOperationBinding operationBinding = this.evaluateBindings(originalRewiredBinding, occurrence.getAppliedOperation());
        this.handleInvalidOperationBinding(operationBinding, occurrence, threeWayDiff, conflicts, side);
    }

    private void handleMissingObjects(Map<Template, EList<EObject>> missingObjects, OperationOccurrence occurrence, IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, Side side) {
        MissingObject diagnostics = ConflictFactory.eINSTANCE.createMissingObject();
        Map.Entry<Template, EList<EObject>> entry = missingObjects.entrySet().iterator().next();
        diagnostics.setMissingObject((EObject)entry.getValue().get(0));
        diagnostics.setTemplate(entry.getKey());
        OperationContractViolation contractViolation = this.createOperationContractViolation(diagnostics, occurrence, side);
        Side oppositeSide = this.getOppositeSide(side);
        DiffElement diffElement = this.guessCausingChange(diagnostics, threeWayDiff, oppositeSide);
        if (diffElement != null) {
            if (Side.LEFT.equals(oppositeSide)) {
                contractViolation.setLeftChange(diffElement);
            } else {
                contractViolation.setRightChange(diffElement);
            }
        }
        conflicts.add(contractViolation);
    }

    private DiffElement guessCausingChange(MissingObject diagnostics, IThreeWayDiffProvider threeWayDiff, Side side) {
        return threeWayDiff.getDeleteElement(diagnostics.getMissingObject(), side);
    }

    private void handleInvalidOperationBinding(IOperationBinding operationBinding, OperationOccurrence occurrence, IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, Side side) {
        for (NegativeApplicationConditionResult nacResult : operationBinding.getNegativeApplicationConditionResults()) {
            if (nacResult.isOK()) continue;
            conflicts.add(this.createMatchingNACDViolation(nacResult, occurrence, threeWayDiff, side));
            return;
        }
        EvaluationResult evaluationResult = operationBinding.getTemplateBinding().validate();
        conflicts.add(this.createViolatedPreconditionViolation(evaluationResult, occurrence, threeWayDiff, side));
    }

    private OperationContractViolation createViolatedPreconditionViolation(EvaluationResult evaluationResult, OperationOccurrence occurrence, IThreeWayDiffProvider threeWayDiff, Side side) {
        ViolatedPrecondition diagnostics = ConflictFactory.eINSTANCE.createViolatedPrecondition();
        for (EvaluationResult subResult : evaluationResult.getSubResults()) {
            if (subResult.getFailedCandidate() == null || subResult.getFailedCondition() == null) continue;
            ConditionViolation conditionViolation = ConflictFactory.eINSTANCE.createConditionViolation();
            conditionViolation.setViolatedCondition(subResult.getFailedCondition());
            conditionViolation.setViolatingObject(subResult.getFailedCandidate());
            diagnostics.getConditionViolations().add(conditionViolation);
        }
        OperationContractViolation contractViolation = this.createOperationContractViolation(diagnostics, occurrence, side);
        Side oppositeSide = this.getOppositeSide(side);
        DiffElement diffElement = this.guessCausingChange(diagnostics, occurrence, threeWayDiff, oppositeSide);
        if (diffElement != null) {
            if (Side.LEFT.equals(oppositeSide)) {
                contractViolation.setLeftChange(diffElement);
            } else {
                contractViolation.setRightChange(diffElement);
            }
        }
        return contractViolation;
    }

    private DiffElement guessCausingChange(ViolatedPrecondition diagnostics, OperationOccurrence occurrence, IThreeWayDiffProvider threeWayDiff, Side side) {
        for (ConditionViolation violation : diagnostics.getConditionViolations()) {
            DiffElement causingDiff;
            Condition condition = violation.getViolatedCondition();
            EObject eObject = violation.getViolatingObject();
            EObject originalEObject = threeWayDiff.getMatchingEObject(eObject, side, true);
            if (originalEObject == null || (causingDiff = this.guessCausingChangeForCondition(condition, originalEObject, occurrence, threeWayDiff, side)) == null) continue;
            return causingDiff;
        }
        return null;
    }

    private DiffElement guessCausingChangeForCondition(Condition condition, EObject originalEObject, OperationOccurrence occurrence, IThreeWayDiffProvider threeWayDiff, Side side) {
        FeatureCondition featureCondition;
        Set<DiffElement> updateElements;
        if (condition instanceof FeatureCondition && (updateElements = threeWayDiff.getUpdateElements(originalEObject, (featureCondition = (FeatureCondition)condition).getFeature(), side)) != null && updateElements.size() > 0) {
            return updateElements.iterator().next();
        }
        String expression = ConditionsUtil.getExpression(condition);
        Set<String> referencedTemplateNames = ConditionsUtil.getReferencedUnprefixedTemplateNames(expression);
        for (String referencedTemplateName : referencedTemplateNames) {
            List<EObject> boundObjects = this.getBoundObjects(referencedTemplateName, occurrence.getPreConditionBinding());
            Template referencedTemplate = ConditionsUtil.getTemplateByName(referencedTemplateName, occurrence.getAppliedOperation().getPreconditions());
            Set<String> featureNames = ConditionsUtil.getReferencedFeatureNames(referencedTemplateName, expression);
            Set<EStructuralFeature> features = this.getFeaturesByName(featureNames, referencedTemplate);
            for (EObject boundObject : boundObjects) {
                ModelElementChange deleteElement = threeWayDiff.getDeleteElement(boundObject, side);
                if (deleteElement != null) {
                    return deleteElement;
                }
                for (EStructuralFeature feature : features) {
                    Set<DiffElement> updateElements2 = threeWayDiff.getUpdateElements(boundObject, feature, side);
                    if (updateElements2 == null || updateElements2.size() <= 0) continue;
                    return updateElements2.iterator().next();
                }
            }
        }
        return null;
    }

    private Set<EStructuralFeature> getFeaturesByName(Set<String> featureNames, Template template) {
        HashSet<EStructuralFeature> features = new HashSet<EStructuralFeature>();
        for (String featureName : featureNames) {
            EStructuralFeature feature = this.getFeatureByName(featureName, template);
            if (feature == null) continue;
            features.add(feature);
        }
        return features;
    }

    private EStructuralFeature getFeatureByName(String featureName, Template template) {
        EList<EStructuralFeature> features = template.getRepresentative().eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!featureName.equals(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    private List<EObject> getBoundObjects(String templateName, TemplateBindingCollection bindings) {
        for (TemplateBinding binding : bindings.getBindings()) {
            if (!templateName.equals(binding.getTemplateName())) continue;
            return binding.getEObjects();
        }
        return null;
    }

    private OperationContractViolation createMatchingNACDViolation(NegativeApplicationConditionResult nacResult, OperationOccurrence occurrence, IThreeWayDiffProvider threeWayDiff, Side side) {
        MatchingNegativeApplicationCondition diagnostics = ConflictFactory.eINSTANCE.createMatchingNegativeApplicationCondition();
        diagnostics.setNegativeApplicationCondition(nacResult.getNegativeApplicationCondition());
        diagnostics.setNacBinding(nacResult.getBinding());
        OperationContractViolation contractViolation = this.createOperationContractViolation(diagnostics, occurrence, side);
        Side oppositeSide = this.getOppositeSide(side);
        DiffElement diffElement = this.guessCausingChange(diagnostics, occurrence, threeWayDiff, oppositeSide);
        if (diffElement != null) {
            if (Side.LEFT.equals(oppositeSide)) {
                contractViolation.setLeftChange(diffElement);
            } else {
                contractViolation.setRightChange(diffElement);
            }
        }
        return contractViolation;
    }

    private DiffElement guessCausingChange(MatchingNegativeApplicationCondition diagnostics, OperationOccurrence occurrence, IThreeWayDiffProvider threeWayDiff, Side side) {
        List<EObject> boundObjects;
        ConditionsModel nacConditionsModel = diagnostics.getNegativeApplicationCondition().getConditions();
        for (Template nacTemplate : this.getNACTemplates(nacConditionsModel)) {
            boundObjects = this.getBoundObjects(nacTemplate.getName(), diagnostics.getNacBinding());
            if (boundObjects == null) continue;
            for (EObject boundObject : boundObjects) {
                ModelElementChange addElement = threeWayDiff.getAddElement(boundObject, side);
                if (addElement == null) continue;
                return addElement;
            }
        }
        for (Template template : ConditionsUtil.getAllTemplates(nacConditionsModel)) {
            boundObjects = this.getBoundObjects(template.getName(), diagnostics.getNacBinding());
            for (Condition condition : template.getSpecifications()) {
                for (EObject boundObject : boundObjects) {
                    EObject originalEObject = threeWayDiff.getMatchingEObject(boundObject, side, true);
                    DiffElement causingDiff = this.guessCausingChangeForCondition(condition, originalEObject, occurrence, threeWayDiff, side);
                    if (causingDiff == null) continue;
                    return causingDiff;
                }
            }
        }
        return null;
    }

    private Set<Template> getNACTemplates(ConditionsModel nacConditionsModel) {
        HashSet<Template> nacTemplates = new HashSet<Template>();
        for (Template template : ConditionsUtil.getAllTemplates(nacConditionsModel)) {
            if (template instanceof RefinementTemplate) continue;
            nacTemplates.add(template);
        }
        return nacTemplates;
    }

    private void checkForDifferentBindingSize(ITemplateBindings bindings, ITemplateBindings originalBindings, EList<Conflict> conflicts, OperationOccurrence occurrence, Side side) {
        boolean foundToBeBigger = false;
        boolean foundToBeSmaller = false;
        for (Template template : bindings.getTemplates()) {
            HashSet<EObject> originalObjects = new HashSet<EObject>(originalBindings.getBoundObjects(template));
            HashSet<EObject> newObjects = new HashSet<EObject>(bindings.getBoundObjects(template));
            for (EObject originalObject : originalObjects) {
                if (newObjects.contains(originalObject)) {
                    newObjects.remove(originalObject);
                    continue;
                }
                foundToBeSmaller = true;
            }
            if (newObjects.size() <= 0) continue;
            foundToBeBigger = true;
        }
        if (foundToBeBigger || foundToBeSmaller) {
            BindingSizeDifference differenceKind;
            DifferentBindingSize differentBindingSize = ConflictFactory.eINSTANCE.createDifferentBindingSize();
            differentBindingSize.setNewBinding(TemplateBindingsUtil.convert(bindings));
            differentBindingSize.setOldBinding(TemplateBindingsUtil.convert(originalBindings));
            BindingSizeDifference bindingSizeDifference = differenceKind = foundToBeSmaller ? BindingSizeDifference.DECREASED : BindingSizeDifference.INCREASED;
            if (foundToBeBigger && foundToBeSmaller) {
                differenceKind = BindingSizeDifference.BOTH;
            }
            differentBindingSize.setDifferenceKind(differenceKind);
            OperationContractViolation contractViolation = this.createOperationContractViolation(differentBindingSize, occurrence, side);
            if (BindingSizeDifference.INCREASED.equals(differenceKind)) {
                contractViolation.setSeverity(ViolationSeverity.INFO);
            } else {
                contractViolation.setSeverity(ViolationSeverity.WARNING);
            }
            conflicts.add(contractViolation);
        }
    }

    private void removeUnselectedBindings(ITemplateBindings allBindings, ITemplateBinding unselectedBinding, ITemplateBindings rewiredTemplateBinding, IThreeWayDiffProvider threeWayDiff, Side oppositeSide) throws UnselectBindingsFailedException {
        for (Template template : unselectedBinding.getTemplates()) {
            for (EObject eObject : unselectedBinding.getBoundObjects(template)) {
                EObject matchingObject = threeWayDiff.getMatchingEObject(eObject, oppositeSide, false);
                if (matchingObject == null) continue;
                if (allBindings.isRemovable(matchingObject, template)) {
                    allBindings.remove(matchingObject, template);
                    continue;
                }
                throw new UnselectBindingsFailedException(allBindings, unselectedBinding, rewiredTemplateBinding);
            }
        }
    }

    private IOperationBinding evaluateBindings(ITemplateBindings bindings, OperationSpecification operationSpecification) throws UnsupportedConditionLanguage {
        ITemplateBinding mergedTemplateBinding = ConditionsUtil.mergeTemplateBindings(bindings);
        Assert.isTrue(this.getOperationBindingGenerator().getEvaluationEngine().isComplete(mergedTemplateBinding), "Template must be complete, otherwise a missing object exception would have been thrown");
        return this.getOperationBindingGenerator().generateOperationBinding(operationSpecification, mergedTemplateBinding);
    }

    private ITemplateBindings rewireBinding(TemplateBindingCollection preConditionBinding, IThreeWayDiffProvider threeWayDiff, Side side) throws MissingObjectsForBindingException {
        ITemplateBindings originalBindings = TemplateBindingsUtil.convert(preConditionBinding);
        TemplateBindingsImpl rewiredBindings = new TemplateBindingsImpl(originalBindings.getRootTemplate());
        HashMap<Template, EList<EObject>> missingObjects = new HashMap<Template, EList<EObject>>();
        for (ITemplateBinding originalBinding : originalBindings.getAllPossibleBindings()) {
            TemplateBindingImpl rewiredBinding = new TemplateBindingImpl();
            boolean hadNoObjectForTemplate = false;
            for (Template template : originalBinding.getTemplates()) {
                for (EObject originalObject : originalBinding.getBoundObjects(template)) {
                    EObject matchingObject = threeWayDiff.getMatchingEObject(originalObject, side, false);
                    if (matchingObject == null) continue;
                    rewiredBinding.add(template, matchingObject);
                }
                if (rewiredBinding.getBoundObjects(template) != null && rewiredBinding.getBoundObjects(template).size() != 0) continue;
                missingObjects.put(template, new BasicEList<EObject>(originalBinding.getBoundObjects(template)));
                hadNoObjectForTemplate = true;
            }
            if (hadNoObjectForTemplate) continue;
            rewiredBindings.getAllPossibleBindings().add(rewiredBinding);
        }
        if (rewiredBindings.getAllPossibleBindings().size() < 1) {
            throw new MissingObjectsForBindingException(missingObjects);
        }
        return rewiredBindings;
    }

    private void fillUnselectedBindingMap(Set<OperationOccurrence> occurrences) throws UnsupportedConditionLanguage {
        for (OperationOccurrence occurrence : occurrences) {
            ITemplateBindings actualBinding = TemplateBindingsUtil.convert(occurrence.getPreConditionBinding());
            ITemplateBinding fixedPreBinding = this.createFixedPreBinding(actualBinding, occurrence.getAppliedOperation());
            ITemplateBindings allPossibleBindings = this.getOperationBindingGenerator().generateOperationBinding(occurrence.getAppliedOperation(), fixedPreBinding).getTemplateBinding();
            TemplateBindingImpl unselectedBinding = new TemplateBindingImpl();
            for (Template template : new HashSet<Template>(allPossibleBindings.getTemplates())) {
                HashSet<EObject> boundObjects = new HashSet<EObject>(allPossibleBindings.getBoundObjects(template));
                boundObjects.removeAll(actualBinding.getBoundObjects(template));
                if (boundObjects.size() <= 0) continue;
                unselectedBinding.add(template, boundObjects);
            }
            this.unselectedBindingMap.put(occurrence, unselectedBinding);
        }
    }

    private ITemplateBinding createFixedPreBinding(ITemplateBindings inputBinding, OperationSpecification operationSpecification) {
        TemplateBindingImpl binding = new TemplateBindingImpl();
        for (Template template : new HashSet<Template>(inputBinding.getTemplates())) {
            if (!this.isPartOfFixedPreBinding(template, operationSpecification)) continue;
            for (EObject boundObject : inputBinding.getBoundObjects(template)) {
                binding.add(template, boundObject);
            }
        }
        return binding;
    }

    private boolean isPartOfFixedPreBinding(Template template, OperationSpecification operationSpecification) {
        return !OperationsUtil.isIterated(template, operationSpecification) && !OperationsUtil.isParentIterated(template, operationSpecification);
    }

    private Set<OperationOccurrence> getOperationOccurrences(ComparisonResourceSnapshot comparisonSnapshot) {
        HashSet<OperationOccurrence> occurrences = new HashSet<OperationOccurrence>();
        occurrences.addAll(this.getOperationOccurrences(comparisonSnapshot.getDiff().getOwnedElements()));
        return occurrences;
    }

    private Collection<OperationOccurrence> getOperationOccurrences(EList<DiffElement> diffElements) {
        HashSet<OperationOccurrence> occurrences = new HashSet<OperationOccurrence>();
        for (DiffElement diffElement : diffElements) {
            if (diffElement instanceof OperationOccurrence) {
                occurrences.add((OperationOccurrence)diffElement);
                continue;
            }
            occurrences.addAll(this.getOperationOccurrences(diffElement.getSubDiffElements()));
        }
        return occurrences;
    }

    private OperationContractViolation createOperationContractViolation(OperationContractDiagnostics diagnostics, OperationOccurrence occurrence, Side side) {
        OperationContractViolation contractViolation = ConflictFactory.eINSTANCE.createOperationContractViolation();
        if (Side.LEFT.equals(side)) {
            contractViolation.setLeftChange(occurrence);
        } else {
            contractViolation.setRightChange(occurrence);
        }
        contractViolation.setSeverity(ViolationSeverity.ERROR);
        contractViolation.setDiagnostics(diagnostics);
        return contractViolation;
    }

    private class InvalidOperationBindingException
    extends Exception {
        private static final long serialVersionUID = -1112982653808286644L;
        private IOperationBinding operationBinding;

        protected InvalidOperationBindingException(IOperationBinding operationBinding) {
            this.operationBinding = operationBinding;
        }
    }

    private class MissingObjectsForBindingException
    extends Exception {
        private static final long serialVersionUID = -2252862119466955186L;
        private Map<Template, EList<EObject>> missingObject = new HashMap<Template, EList<EObject>>();

        protected MissingObjectsForBindingException(Map<Template, EList<EObject>> missingObjects) {
            this.missingObject = missingObjects;
        }

        protected Map<Template, EList<EObject>> getMissingObjects() {
            return this.missingObject;
        }
    }

    private class UnselectBindingsFailedException
    extends Exception {
        private static final long serialVersionUID = 8813757100547429989L;
        private ITemplateBindings allBindings;
        private ITemplateBinding unselectedBinding;
        private ITemplateBindings originalRewiredBinding;

        protected UnselectBindingsFailedException(ITemplateBindings allBindings, ITemplateBinding unselectedBinding, ITemplateBindings originalRewiredBinding) {
            this.allBindings = allBindings;
            this.unselectedBinding = unselectedBinding;
            this.originalRewiredBinding = originalRewiredBinding;
        }

        protected ITemplateBindings getOriginalRewiredBinding() {
            return this.originalRewiredBinding;
        }
    }
}

