/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.conflicts.detection.impl.FeatureUpdates;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.core.util.EcoreUtil;

public class ThreeWayDiffProvider
implements IThreeWayDiffProvider {
    private ComparisonResourceSnapshot leftComparison;
    private ComparisonResourceSnapshot rightComparison;
    private EList<DiffElement> leftEffectiveDiffs;
    private EList<DiffElement> rightEffectiveDiffs;
    private EList<EObject> leftUpdatedEObjects;
    private EList<EObject> leftImplicitlyUpdatedEObjects;
    private Map<EObject, FeatureUpdates> leftUpdatedFeatureMap;
    private EList<EObject> rightUpdatedEObjects;
    private EList<EObject> rightImplicitlyUpdatedEObjects;
    private Map<EObject, FeatureUpdates> rightUpdatedFeatureMap;
    private Map<EObject, EList<DiffElement>> leftImplicitUpdateElements;
    private Map<EObject, EList<DiffElement>> rightImplicitUpdateElements;
    private EList<EObject> leftAddReferencedEObjects;
    private EList<EObject> rightAddReferencedEObjects;
    private Map<EObject, Set<DiffElement>> leftAddReferenceElements;
    private Map<EObject, Set<DiffElement>> rightAddReferenceElements;
    private EList<EObject> leftAddedEObjects;
    private EList<EObject> leftImplicitlyAddedEObjects;
    private EList<EObject> rightAddedEObjects;
    private EList<EObject> rightImplicitlyAddedEObjects;
    private Map<EObject, ModelElementChange> leftAddElements;
    private Map<EObject, ModelElementChange> rightAddElements;
    private EList<EObject> leftDeletedEObjects;
    private EList<EObject> leftImplicitlyDeletedEObjects;
    private EList<EObject> rightDeletedEObjects;
    private EList<EObject> rightImplicitlyDeletedEObjects;
    private Map<EObject, ModelElementChange> leftDeleteElements;
    private Map<EObject, ModelElementChange> rightDeleteElements;
    private EList<EObject> leftMovedEObjects;
    private EList<EObject> leftImplicitlyMovedEObjects;
    private EList<EObject> rightMovedEObjects;
    private EList<EObject> rightImplicitlyMovedEObjects;
    private Map<EObject, MoveModelElement> leftMoveElements;
    private Map<EObject, MoveModelElement> rightMoveElements;
    private Map<EObject, EObject> leftMatchMap;
    private Map<EObject, EObject> rightMatchMap;

    public ThreeWayDiffProvider(ComparisonResourceSnapshot leftComparison, ComparisonResourceSnapshot rightComparison) {
        this.leftComparison = leftComparison;
        this.rightComparison = rightComparison;
        for (EObject originObject : leftComparison.getMatch().getLeftRoots()) {
            Assert.isTrue(rightComparison.getMatch().getLeftRoots().contains(originObject));
        }
        this.initialize();
    }

    private void initialize() {
        this.leftEffectiveDiffs = DiffUtil.getEffectiveDiffElements(this.leftComparison.getDiff());
        this.rightEffectiveDiffs = DiffUtil.getEffectiveDiffElements(this.rightComparison.getDiff());
        this.fillMatchMaps();
        this.initializeLeftListsAndMaps();
        this.initializeRightListsAndMaps();
        this.sortIn(this.leftEffectiveDiffs, Side.LEFT);
        this.sortIn(this.rightEffectiveDiffs, Side.RIGHT);
    }

    private void fillMatchMaps() {
        this.leftMatchMap = new HashMap<EObject, EObject>();
        this.rightMatchMap = new HashMap<EObject, EObject>();
        this.fillMatchMap(this.leftMatchMap, this.leftComparison.getMatch());
        this.fillMatchMap(this.rightMatchMap, this.rightComparison.getMatch());
    }

    private void fillMatchMap(Map<EObject, EObject> matchMap, MatchModel match) {
        this.fillMatchMap(matchMap, match.getMatchedElements());
    }

    private void fillMatchMap(Map<EObject, EObject> matchMap, EList<MatchElement> matchedElements) {
        for (MatchElement matchElement : matchedElements) {
            if (matchElement instanceof Match2Elements) {
                Match2Elements match2Elements = (Match2Elements)matchElement;
                matchMap.put(match2Elements.getLeftElement(), match2Elements.getRightElement());
                matchMap.put(match2Elements.getRightElement(), match2Elements.getLeftElement());
            }
            this.fillMatchMap(matchMap, matchElement.getSubMatchElements());
        }
    }

    private void initializeRightListsAndMaps() {
        this.rightAddedEObjects = new BasicEList<EObject>();
        this.rightAddElements = new HashMap<EObject, ModelElementChange>();
        this.rightAddReferencedEObjects = new BasicEList<EObject>();
        this.rightAddReferenceElements = new HashMap<EObject, Set<DiffElement>>();
        this.rightDeletedEObjects = new BasicEList<EObject>();
        this.rightDeleteElements = new HashMap<EObject, ModelElementChange>();
        this.rightImplicitlyAddedEObjects = new BasicEList<EObject>();
        this.rightImplicitlyDeletedEObjects = new BasicEList<EObject>();
        this.rightImplicitlyMovedEObjects = new BasicEList<EObject>();
        this.rightImplicitlyUpdatedEObjects = new BasicEList<EObject>();
        this.rightImplicitUpdateElements = new HashMap<EObject, EList<DiffElement>>();
        this.rightMovedEObjects = new BasicEList<EObject>();
        this.rightMoveElements = new HashMap<EObject, MoveModelElement>();
        this.rightUpdatedEObjects = new BasicEList<EObject>();
        this.rightUpdatedFeatureMap = new HashMap<EObject, FeatureUpdates>();
    }

    private void initializeLeftListsAndMaps() {
        this.leftAddedEObjects = new BasicEList<EObject>();
        this.leftAddElements = new HashMap<EObject, ModelElementChange>();
        this.leftAddReferencedEObjects = new BasicEList<EObject>();
        this.leftAddReferenceElements = new HashMap<EObject, Set<DiffElement>>();
        this.leftDeletedEObjects = new BasicEList<EObject>();
        this.leftDeleteElements = new HashMap<EObject, ModelElementChange>();
        this.leftImplicitlyAddedEObjects = new BasicEList<EObject>();
        this.leftImplicitlyDeletedEObjects = new BasicEList<EObject>();
        this.leftImplicitlyMovedEObjects = new BasicEList<EObject>();
        this.leftImplicitlyUpdatedEObjects = new BasicEList<EObject>();
        this.leftImplicitUpdateElements = new HashMap<EObject, EList<DiffElement>>();
        this.leftMovedEObjects = new BasicEList<EObject>();
        this.leftMoveElements = new HashMap<EObject, MoveModelElement>();
        this.leftUpdatedEObjects = new BasicEList<EObject>();
        this.leftUpdatedFeatureMap = new HashMap<EObject, FeatureUpdates>();
    }

    private void sortIn(EList<DiffElement> diffElements, Side side) {
        for (DiffElement diffElement : diffElements) {
            ReferenceChangeLeftTarget addReferenceTarget;
            Set<DiffElement> referenceChanges;
            EObject referencedObject;
            if (diffElement instanceof ModelElementChangeRightTarget) {
                ModelElementChangeRightTarget deleteElement = (ModelElementChangeRightTarget)diffElement;
                EObject deletedObject = deleteElement.getRightElement();
                this.getDeletedEObjects(side).add(deletedObject);
                EList<EObject> implicitlyDeletedObjects = this.getAllChildren(deletedObject);
                this.getImplicitlyDeletedEObjects(side).addAll(implicitlyDeletedObjects);
                this.getDeleteElements(side).put(deletedObject, deleteElement);
                for (EObject implicitlyDeletedObject : implicitlyDeletedObjects) {
                    this.getDeleteElements(side).put(implicitlyDeletedObject, deleteElement);
                }
                if (deletedObject.eContainmentFeature() == null) continue;
                this.fillInFeatureUpdate(deletedObject.eContainer(), deletedObject.eContainmentFeature(), diffElement, side);
                continue;
            }
            if (diffElement instanceof ModelElementChangeLeftTarget) {
                EObject matchingContainer;
                ModelElementChangeLeftTarget addElement = (ModelElementChangeLeftTarget)diffElement;
                EObject addedObject = addElement.getLeftElement();
                this.getAddedEObjects(side).add(addedObject);
                EList<EObject> implicitlyAddedObjects = this.getAllChildren(addedObject);
                this.getImplicitlyAddedEObjects(side).addAll(implicitlyAddedObjects);
                this.fillInImplicitlyAddedReferences(side, addedObject, diffElement);
                this.getAddElements(side).put(addedObject, addElement);
                for (EObject implicitlyAddedObject : implicitlyAddedObjects) {
                    this.getAddElements(side).put(implicitlyAddedObject, addElement);
                    this.fillInImplicitlyAddedReferences(side, implicitlyAddedObject, diffElement);
                }
                if (addedObject.eContainmentFeature() == null || (matchingContainer = this.getMatchingEObject(addedObject.eContainer(), side, true)) == null) continue;
                this.fillInFeatureUpdate(matchingContainer, addedObject.eContainmentFeature(), diffElement, side);
                continue;
            }
            if (diffElement instanceof MoveModelElement) {
                MoveModelElement moveElement = (MoveModelElement)diffElement;
                EObject movedObject = moveElement.getRightElement();
                this.getMovedEObjects(side).add(movedObject);
                EList<EObject> implicitlyMovedObjects = this.getAllChildren(movedObject);
                this.getImplicitlyMovedEObjects(side).addAll(implicitlyMovedObjects);
                this.getMoveElements(side).put(movedObject, moveElement);
                for (EObject implicitlyMovedObject : implicitlyMovedObjects) {
                    this.getMoveElements(side).put(implicitlyMovedObject, moveElement);
                }
                if (movedObject.eContainmentFeature() == null) continue;
                this.fillInFeatureUpdate(movedObject.eContainer(), movedObject.eContainmentFeature(), diffElement, side);
                EObject targetContainer = this.getMatchingEObject(moveElement.getLeftElement().eContainer(), side, true);
                if (targetContainer == null) continue;
                this.fillInFeatureUpdate(targetContainer, movedObject.eContainmentFeature(), diffElement, side);
                continue;
            }
            if (diffElement instanceof AttributeChange) {
                AttributeChange attributeChange = (AttributeChange)diffElement;
                this.fillInFeatureUpdate(attributeChange.getRightElement(), attributeChange.getAttribute(), diffElement, side);
                continue;
            }
            if (!(diffElement instanceof ReferenceChange)) continue;
            ReferenceChange referenceChange = (ReferenceChange)diffElement;
            this.fillInFeatureUpdate(referenceChange.getRightElement(), referenceChange.getReference(), diffElement, side);
            if (referenceChange instanceof UpdateReference) {
                UpdateReference updateReference = (UpdateReference)referenceChange;
                referencedObject = this.getMatchingEObject(updateReference.getLeftTarget(), side, true);
                if (referencedObject == null || updateReference.getLeftElement().eGet(updateReference.getReference()) == null) continue;
                this.getAddReferencedEObjectsSet(side).add(referencedObject);
                referenceChanges = this.getAddReferenceElements(side).get(referencedObject);
                if (referenceChanges == null) {
                    referenceChanges = new HashSet<DiffElement>();
                    this.getAddReferenceElements(side).put(referencedObject, referenceChanges);
                }
                referenceChanges.add(referenceChange);
                continue;
            }
            if (!(referenceChange instanceof ReferenceChangeLeftTarget) || (referencedObject = this.getMatchingEObject((addReferenceTarget = (ReferenceChangeLeftTarget)referenceChange).getRightTarget(), side, true)) == null) continue;
            this.getAddReferencedEObjectsSet(side).add(referencedObject);
            referenceChanges = this.getAddReferenceElements(side).get(referencedObject);
            if (referenceChanges == null) {
                referenceChanges = new HashSet<DiffElement>();
                this.getAddReferenceElements(side).put(referencedObject, referenceChanges);
            }
            referenceChanges.add(referenceChange);
        }
    }

    private void fillInImplicitlyAddedReferences(Side side, EObject addedObject, DiffElement diffElement) {
        for (EObject referencedObjectInRevisedModel : addedObject.eCrossReferences()) {
            EObject referencedObject = this.getMatchingEObject(referencedObjectInRevisedModel, side, true);
            this.getAddReferencedEObjectsSet(side).add(referencedObject);
            Set<DiffElement> referenceChanges = this.getAddReferenceElements(side).get(referencedObject);
            if (referenceChanges == null) {
                referenceChanges = new HashSet<DiffElement>();
                this.getAddReferenceElements(side).put(referencedObject, referenceChanges);
            }
            referenceChanges.add(diffElement);
        }
    }

    private EList<EObject> getAddReferencedEObjectsSet(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftAddReferencedEObjects;
        }
        return this.rightAddReferencedEObjects;
    }

    private Map<EObject, Set<DiffElement>> getAddReferenceElements(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftAddReferenceElements;
        }
        return this.rightAddReferenceElements;
    }

    private Map<EObject, MoveModelElement> getMoveElements(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftMoveElements;
        }
        return this.rightMoveElements;
    }

    private List<EObject> getImplicitlyMovedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftImplicitlyMovedEObjects;
        }
        return this.rightImplicitlyMovedEObjects;
    }

    private EList<EObject> getMovedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftMovedEObjects;
        }
        return this.rightMovedEObjects;
    }

    private Map<EObject, ModelElementChange> getAddElements(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftAddElements;
        }
        return this.rightAddElements;
    }

    private List<EObject> getImplicitlyAddedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftImplicitlyAddedEObjects;
        }
        return this.rightImplicitlyAddedEObjects;
    }

    private EList<EObject> getAddedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftAddedEObjects;
        }
        return this.rightAddedEObjects;
    }

    private void fillInFeatureUpdate(EObject eObject, EStructuralFeature feature, DiffElement diffElement, Side side) {
        if (!this.getUpdatedEObjects(side).contains(eObject)) {
            this.getUpdatedEObjects(side).add(eObject);
        }
        this.addFeatureUpdate(eObject, feature, diffElement, side);
        for (EObject parent : EcoreUtil.createParentList(eObject)) {
            if (!this.getImplicitlyUpdatedEObjects(side).contains(parent)) {
                this.getImplicitlyUpdatedEObjects(side).add(parent);
            }
            this.addImplicitUpdate(parent, diffElement, side);
        }
    }

    public void addImplicitUpdate(EObject eObject, DiffElement diffElement, Side side) {
        Map<EObject, EList<DiffElement>> implicitUpdateElements = this.getImplicitUpdateElements(side);
        EList<Object> diffList = null;
        if (!implicitUpdateElements.containsKey(eObject)) {
            diffList = new BasicEList();
            implicitUpdateElements.put(eObject, diffList);
        } else {
            diffList = implicitUpdateElements.get(eObject);
        }
        if (!diffList.contains(diffElement)) {
            diffList.add(diffElement);
        }
    }

    public Map<EObject, EList<DiffElement>> getImplicitUpdateElements(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftImplicitUpdateElements;
        }
        return this.rightImplicitUpdateElements;
    }

    private void addFeatureUpdate(EObject eObject, EStructuralFeature feature, DiffElement diffElement, Side side) {
        FeatureUpdates featureUpdates = null;
        if (!this.getUpdatedFeatureMap(side).containsKey(eObject)) {
            featureUpdates = new FeatureUpdates();
            this.getUpdatedFeatureMap(side).put(eObject, featureUpdates);
        } else {
            featureUpdates = this.getUpdatedFeatureMap(side).get(eObject);
        }
        featureUpdates.add(feature, diffElement);
    }

    private EList<EObject> getUpdatedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftUpdatedEObjects;
        }
        return this.rightUpdatedEObjects;
    }

    private EList<EObject> getImplicitlyUpdatedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftImplicitlyUpdatedEObjects;
        }
        return this.rightImplicitlyUpdatedEObjects;
    }

    private Map<EObject, FeatureUpdates> getUpdatedFeatureMap(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftUpdatedFeatureMap;
        }
        return this.rightUpdatedFeatureMap;
    }

    private EList<EObject> getImplicitlyDeletedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftImplicitlyDeletedEObjects;
        }
        return this.rightImplicitlyDeletedEObjects;
    }

    private EList<EObject> getDeletedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftDeletedEObjects;
        }
        return this.rightDeletedEObjects;
    }

    private Map<EObject, ModelElementChange> getDeleteElements(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftDeleteElements;
        }
        return this.rightDeleteElements;
    }

    private EList<EObject> getAllChildren(EObject eObject) {
        BasicEList<EObject> allChildren = new BasicEList<EObject>();
        TreeIterator<EObject> allContents = eObject.eAllContents();
        while (allContents.hasNext()) {
            allChildren.add((EObject)allContents.next());
        }
        return allChildren;
    }

    @Override
    public EList<EObject> getOriginModel() {
        return this.leftComparison.getMatch().getLeftRoots();
    }

    @Override
    public EList<EObject> getLeftModel() {
        return this.leftComparison.getMatch().getRightRoots();
    }

    @Override
    public EList<EObject> getRightModel() {
        return this.rightComparison.getMatch().getRightRoots();
    }

    @Override
    public ComparisonResourceSnapshot getComparisonSnapshot(Side side) {
        switch (side) {
            case LEFT: {
                return this.leftComparison;
            }
            case RIGHT: {
                return this.rightComparison;
            }
        }
        return null;
    }

    @Override
    public EList<DiffElement> getEffectiveDiffElements(Side side) {
        switch (side) {
            case LEFT: {
                return this.leftEffectiveDiffs;
            }
            case RIGHT: {
                return this.rightEffectiveDiffs;
            }
        }
        return null;
    }

    private EList<EObject> join(EList<EObject> list1, EList<EObject> list2) {
        BasicEList<EObject> joinedList = new BasicEList<EObject>(list1);
        joinedList.addAll(list2);
        return joinedList;
    }

    @Override
    public EList<EObject> getUpdatedEObjects(Side side, boolean includeImplicit) {
        if (Side.LEFT.equals(side)) {
            if (!includeImplicit) {
                return ECollections.unmodifiableEList(this.leftUpdatedEObjects);
            }
            return ECollections.unmodifiableEList(this.join(this.leftUpdatedEObjects, this.leftImplicitlyUpdatedEObjects));
        }
        if (!includeImplicit) {
            return ECollections.unmodifiableEList(this.rightUpdatedEObjects);
        }
        return ECollections.unmodifiableEList(this.join(this.rightUpdatedEObjects, this.rightImplicitlyUpdatedEObjects));
    }

    @Override
    public boolean isUpdated(EObject eObject, Side side, boolean includeImplicit) {
        return this.getUpdatedEObjects(side, includeImplicit).contains(eObject);
    }

    @Override
    public boolean isUpdated(EObject eObject, EStructuralFeature feature, Side side) {
        if (Side.LEFT.equals(side)) {
            if (this.leftUpdatedFeatureMap.containsKey(eObject)) {
                FeatureUpdates featureUpdates = this.leftUpdatedFeatureMap.get(eObject);
                return featureUpdates.contains(feature);
            }
        } else if (this.rightUpdatedFeatureMap.containsKey(eObject)) {
            FeatureUpdates featureUpdates = this.rightUpdatedFeatureMap.get(eObject);
            return featureUpdates.contains(feature);
        }
        return false;
    }

    @Override
    public Set<DiffElement> getUpdateElements(EObject eObject, EStructuralFeature feature, Side side) {
        if (Side.LEFT.equals(side)) {
            if (this.leftUpdatedFeatureMap.containsKey(eObject)) {
                FeatureUpdates featureUpdates = this.leftUpdatedFeatureMap.get(eObject);
                return featureUpdates.getDiffElements(feature);
            }
        } else if (this.rightUpdatedFeatureMap.containsKey(eObject)) {
            FeatureUpdates featureUpdates = this.rightUpdatedFeatureMap.get(eObject);
            return featureUpdates.getDiffElements(feature);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<DiffElement> getUpdateElements(EObject eObject, Side side) {
        if (Side.LEFT.equals(side)) {
            if (this.leftUpdatedFeatureMap.containsKey(eObject)) {
                FeatureUpdates featureUpdates = this.leftUpdatedFeatureMap.get(eObject);
                return featureUpdates.getDiffElements();
            }
        } else if (this.rightUpdatedFeatureMap.containsKey(eObject)) {
            FeatureUpdates featureUpdates = this.rightUpdatedFeatureMap.get(eObject);
            return featureUpdates.getDiffElements();
        }
        return Collections.emptySet();
    }

    @Override
    public EList<DiffElement> getImplicitUpdateElements(EObject eObject, Side side) {
        if (Side.LEFT.equals(side)) {
            if (this.leftImplicitUpdateElements.containsKey(eObject)) {
                return this.leftImplicitUpdateElements.get(eObject);
            }
        } else if (this.rightImplicitUpdateElements.containsKey(eObject)) {
            return this.rightImplicitUpdateElements.get(eObject);
        }
        return ECollections.emptyEList();
    }

    @Override
    public EList<EObject> getAddReferencedEObjects(Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftAddReferencedEObjects;
        }
        return this.rightAddReferencedEObjects;
    }

    @Override
    public Set<DiffElement> getAddReferenceElements(EObject eObject, Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftAddReferenceElements.get(eObject);
        }
        return this.rightAddReferenceElements.get(eObject);
    }

    @Override
    public EList<EObject> getDeletedEObjects(Side side, boolean includeImplicit) {
        if (Side.LEFT.equals(side)) {
            if (!includeImplicit) {
                return ECollections.unmodifiableEList(this.leftDeletedEObjects);
            }
            return ECollections.unmodifiableEList(this.join(this.leftDeletedEObjects, this.leftImplicitlyDeletedEObjects));
        }
        if (!includeImplicit) {
            return ECollections.unmodifiableEList(this.rightDeletedEObjects);
        }
        return ECollections.unmodifiableEList(this.join(this.rightDeletedEObjects, this.rightImplicitlyDeletedEObjects));
    }

    @Override
    public boolean isDeleted(EObject eObject, Side side, boolean includeImplicit) {
        return this.getDeletedEObjects(side, includeImplicit).contains(eObject);
    }

    @Override
    public ModelElementChange getDeleteElement(EObject eObject, Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftDeleteElements.get(eObject);
        }
        return this.rightDeleteElements.get(eObject);
    }

    @Override
    public EList<EObject> getAddedEObjects(Side side, boolean includeImplicit) {
        if (Side.LEFT.equals(side)) {
            if (!includeImplicit) {
                return ECollections.unmodifiableEList(this.leftAddedEObjects);
            }
            return ECollections.unmodifiableEList(this.join(this.leftAddedEObjects, this.leftImplicitlyAddedEObjects));
        }
        if (!includeImplicit) {
            return ECollections.unmodifiableEList(this.rightAddedEObjects);
        }
        return ECollections.unmodifiableEList(this.join(this.rightAddedEObjects, this.rightImplicitlyAddedEObjects));
    }

    @Override
    public ModelElementChange getAddElement(EObject eObject, Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftAddElements.get(eObject);
        }
        return this.rightAddElements.get(eObject);
    }

    @Override
    public EList<EObject> getMovedEObjects(Side side, boolean includeImplicit) {
        if (Side.LEFT.equals(side)) {
            if (!includeImplicit) {
                return ECollections.unmodifiableEList(this.leftMovedEObjects);
            }
            return ECollections.unmodifiableEList(this.join(this.leftMovedEObjects, this.leftImplicitlyMovedEObjects));
        }
        if (!includeImplicit) {
            return ECollections.unmodifiableEList(this.rightMovedEObjects);
        }
        return ECollections.unmodifiableEList(this.join(this.rightMovedEObjects, this.rightImplicitlyMovedEObjects));
    }

    @Override
    public boolean isMoved(EObject eObject, Side side, boolean includeImplicit) {
        return this.getMovedEObjects(side, includeImplicit).contains(eObject);
    }

    @Override
    public MoveModelElement getMoveElement(EObject eObject, Side side) {
        if (Side.LEFT.equals(side)) {
            return this.leftMoveElements.get(eObject);
        }
        return this.rightMoveElements.get(eObject);
    }

    @Override
    public EObject getMatchingEObject(EObject eObject, Side side, boolean retrieveOrigin) {
        if (eObject == null) {
            return null;
        }
        boolean isInOrigin = false;
        if (eObject.eResource() != null && ((EObject)this.getOriginModel().get(0)).eResource() != null && eObject.eResource().equals(((EObject)this.getOriginModel().get(0)).eResource())) {
            if (retrieveOrigin) {
                return eObject;
            }
            isInOrigin = true;
        }
        EObject directMatch = null;
        switch (side) {
            case LEFT: {
                directMatch = this.leftMatchMap.get(eObject);
                break;
            }
            case RIGHT: {
                directMatch = this.rightMatchMap.get(eObject);
            }
        }
        if (retrieveOrigin || isInOrigin) {
            return directMatch;
        }
        if (directMatch != null) {
            switch (side) {
                case LEFT: {
                    return this.rightMatchMap.get(directMatch);
                }
                case RIGHT: {
                    return this.leftMatchMap.get(directMatch);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isEqual(DiffElement leftDiffElement, DiffElement rightDiffElement) {
        if (leftDiffElement.eClass().equals(rightDiffElement.eClass())) {
            if (leftDiffElement instanceof ModelElementChangeRightTarget) {
                ModelElementChangeRightTarget leftRemove = (ModelElementChangeRightTarget)leftDiffElement;
                ModelElementChangeRightTarget rightRemove = (ModelElementChangeRightTarget)rightDiffElement;
                if (leftRemove.getRightElement().equals(rightRemove.getRightElement())) {
                    return true;
                }
            } else if (leftDiffElement instanceof MoveModelElement) {
                MoveModelElement leftMove = (MoveModelElement)leftDiffElement;
                MoveModelElement rightMove = (MoveModelElement)rightDiffElement;
                if (leftMove.getRightElement().equals(rightMove.getRightElement()) && this.getMatchingEObject(leftMove.getLeftTarget(), Side.LEFT, true).equals(this.getMatchingEObject(rightMove.getRightTarget(), Side.RIGHT, true))) {
                    return true;
                }
            } else if (leftDiffElement instanceof AttributeChange) {
                if (leftDiffElement instanceof AttributeChangeRightTarget) {
                    AttributeChangeRightTarget leftAttRemove = (AttributeChangeRightTarget)leftDiffElement;
                    AttributeChangeRightTarget rightAttRemove = (AttributeChangeRightTarget)rightDiffElement;
                    if (leftAttRemove.getRightElement().equals(rightAttRemove.getRightElement()) && leftAttRemove.getRightTarget().equals(rightAttRemove.getRightTarget())) {
                        return true;
                    }
                } else if (leftDiffElement instanceof UpdateAttribute) {
                    UpdateAttribute leftUpdate = (UpdateAttribute)leftDiffElement;
                    UpdateAttribute rightUpdate = (UpdateAttribute)rightDiffElement;
                    if (leftUpdate.getAttribute().equals(rightUpdate.getAttribute()) && leftUpdate.getRightElement().equals(rightUpdate.getRightElement()) && leftUpdate.getLeftElement().eGet(leftUpdate.getAttribute()).equals(rightUpdate.getLeftElement().eGet(rightUpdate.getAttribute()))) {
                        return true;
                    }
                }
            } else if (leftDiffElement instanceof ReferenceChange) {
                if (leftDiffElement instanceof ReferenceChangeRightTarget) {
                    ReferenceChangeRightTarget leftAttRemove = (ReferenceChangeRightTarget)leftDiffElement;
                    ReferenceChangeRightTarget rightAttRemove = (ReferenceChangeRightTarget)rightDiffElement;
                    if (leftAttRemove.getRightElement().equals(rightAttRemove.getRightElement()) && leftAttRemove.getRightTarget().equals(rightAttRemove.getRightTarget())) {
                        return true;
                    }
                } else if (leftDiffElement instanceof ReferenceOrderChange) {
                    ReferenceOrderChange leftOrderChange = (ReferenceOrderChange)leftDiffElement;
                    ReferenceOrderChange rightOrderChange = (ReferenceOrderChange)rightDiffElement;
                    if (leftOrderChange.getRightElement().equals(rightOrderChange.getRightElement()) && leftOrderChange.getRightTarget().equals(rightOrderChange.getRightTarget())) {
                        List leftList = (List)leftOrderChange.getLeftElement().eGet(leftOrderChange.getReference());
                        List rightList = (List)rightOrderChange.getLeftElement().eGet(rightOrderChange.getReference());
                        Iterator iterator = leftList.iterator();
                        while (iterator.hasNext()) {
                            Object leftObject;
                            Object rightObject = leftObject = iterator.next();
                            if (leftObject instanceof EObject) {
                                rightObject = this.getMatchingEObject((EObject)leftObject, Side.LEFT, false);
                            }
                            if (leftList.indexOf(leftObject) == rightList.indexOf(rightObject)) continue;
                            return false;
                        }
                        return true;
                    }
                } else if (leftDiffElement instanceof UpdateReference) {
                    UpdateReference leftUpdate = (UpdateReference)leftDiffElement;
                    UpdateReference rightUpdate = (UpdateReference)rightDiffElement;
                    if (leftUpdate.getReference().equals(rightUpdate.getReference()) && leftUpdate.getRightElement().equals(rightUpdate.getRightElement())) {
                        Object leftValue = leftUpdate.getLeftElement().eGet(leftUpdate.getReference());
                        Object rightValue = rightUpdate.getLeftElement().eGet(rightUpdate.getReference());
                        if (leftValue == null && rightValue == null || leftValue != null && rightValue != null && leftValue.equals(rightValue)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

