/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.AddAdd;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.conflicts.detection.engine.IOverlappingChangeDetector;

public class UMLAddAddConflictDetector
implements IOverlappingChangeDetector {
    private static final String NAME = "Add Add Conflict Detector";

    @Override
    public String getId() {
        return "org.modelversioning.conflicts.detection.uml.addAdd";
    }

    @Override
    public String getTargetModelNsURI() {
        return "http://www.eclipse.org/uml2/3.0.0/UML";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void detectOverlappingChanges(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor) {
        EList<EObject> leftAddedEObjects = threeWayDiff.getAddedEObjects(Side.LEFT, false);
        EList<EObject> rightAddedEObjects = threeWayDiff.getAddedEObjects(Side.RIGHT, false);
        monitor.beginTask("Searching for Add Add conflicts", leftAddedEObjects.size());
        try {
            for (EObject leftAddObject : leftAddedEObjects) {
                for (EObject rightAddObject : rightAddedEObjects) {
                    EStructuralFeature nameFeature;
                    if (!leftAddObject.eClass().equals(rightAddObject.eClass()) || !threeWayDiff.getMatchingEObject(leftAddObject.eContainer(), Side.LEFT, true).equals(threeWayDiff.getMatchingEObject(rightAddObject.eContainer(), Side.RIGHT, true)) || (nameFeature = leftAddObject.eClass().getEStructuralFeature("name")) == null) continue;
                    Object leftName = leftAddObject.eGet(nameFeature);
                    Object rightName = rightAddObject.eGet(nameFeature);
                    if (leftName == null || rightName == null || !leftName.toString().equals(rightName.toString())) continue;
                    boolean equal = true;
                    EList<EAttribute> attributes = leftAddObject.eClass().getEAllAttributes();
                    for (EAttribute attribute : attributes) {
                        if (leftAddObject.eGet(attribute).equals(rightAddObject.eGet(attribute))) continue;
                        equal = false;
                        break;
                    }
                    if (equal) {
                        EquivalentChange equivalentChange = CONFLICT_REPORT_FACTORY.createEquivalentChange();
                        equivalentChange.setPreferSide(Side.RIGHT);
                        equivalentChange.setLeftChange(threeWayDiff.getAddElement(leftAddObject, Side.LEFT));
                        equivalentChange.setRightChange(threeWayDiff.getAddElement(rightAddObject, Side.RIGHT));
                        equivalentChanges.add(equivalentChange);
                        continue;
                    }
                    AddAdd addAdd = CONFLICT_FACTORY.createAddAdd();
                    addAdd.setLeftChange(threeWayDiff.getAddElement(leftAddObject, Side.LEFT));
                    addAdd.setRightChange(threeWayDiff.getAddElement(rightAddObject, Side.RIGHT));
                    conflicts.add(addAdd);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void initialize() {
    }
}

