/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflictreport.conflict.DeleteMove;
import org.modelversioning.conflictreport.conflict.DeleteUse;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.conflicts.detection.engine.IOverlappingChangeDetector;

public class UMLDeleteUseConflictDetector
implements IOverlappingChangeDetector {
    private static final String DIFF_HASH_SEP = "|";
    private static final String NAME = "Delete Use Conflict Detector";
    private Set<String> reportedConflictHashes = new HashSet<String>();

    @Override
    public String getId() {
        return "org.modelversioning.conflicts.detection.uml.deleteUse";
    }

    @Override
    public String getTargetModelNsURI() {
        return "http://www.eclipse.org/uml2/3.0.0/UML";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void detectOverlappingChanges(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor) {
        monitor.beginTask("Searching for Delete Use conflicts", 2);
        this.reportedConflictHashes.clear();
        try {
            this.findConflicts(threeWayDiff, conflicts, equivalentChanges, new SubProgressMonitor(monitor, 1), Side.LEFT);
            this.findConflicts(threeWayDiff, conflicts, equivalentChanges, new SubProgressMonitor(monitor, 1), Side.RIGHT);
        }
        finally {
            monitor.done();
        }
    }

    private void findConflicts(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor, Side side) {
        Side opposite = Side.LEFT.equals(side) ? Side.RIGHT : Side.LEFT;
        EList<EObject> newAddedEObjects = threeWayDiff.getAddedEObjects(side, true);
        class ReferenceAddObject {
            EObject referenceTarget;
            EObject addObject;

            ReferenceAddObject(EObject referenceTarget, EObject addObject) {
                this.referenceTarget = referenceTarget;
                this.addObject = addObject;
            }
        }
        HashSet<ReferenceAddObject> newReferencedEObjects = new HashSet<ReferenceAddObject>();
        for (EObject newAddedObject : newAddedEObjects) {
            EList<EReference> references = newAddedObject.eClass().getEAllReferences();
            for (EReference reference : references) {
                Object referenceTarget = newAddedObject.eGet(reference);
                if (!(referenceTarget instanceof EObject)) continue;
                EObject matchedReferenceTarget = threeWayDiff.getMatchingEObject((EObject)referenceTarget, side, true);
                if (threeWayDiff.getAddReferencedEObjects(side).contains(matchedReferenceTarget)) continue;
                newReferencedEObjects.add(new ReferenceAddObject(matchedReferenceTarget, newAddedObject));
            }
        }
        EList<EObject> movedEObjects = threeWayDiff.getMovedEObjects(side, true);
        monitor.beginTask("Examining " + side + " added reference values and moves", newReferencedEObjects.size() + movedEObjects.size());
        try {
            for (ReferenceAddObject newReferenceAddObject : newReferencedEObjects) {
                EObject newReferencedObject = newReferenceAddObject.referenceTarget;
                if (threeWayDiff.isDeleted(threeWayDiff.getMatchingEObject(newReferencedObject, side, true), opposite, true)) {
                    ModelElementChange addReferenceElement = threeWayDiff.getAddElement(newReferenceAddObject.addObject, side);
                    ModelElementChange deleteElement = threeWayDiff.getDeleteElement(newReferencedObject, opposite);
                    if (!(this.haveAlreadyReported(deleteElement, addReferenceElement) || this.shouldIgnore(addReferenceElement) || this.shouldIgnore(deleteElement) || this.shouldIgnore(addReferenceElement, deleteElement))) {
                        DeleteUse deleteUse = CONFLICT_FACTORY.createDeleteUse();
                        if (Side.LEFT.equals(side)) {
                            deleteUse.setLeftChange(addReferenceElement);
                            deleteUse.setRightChange(deleteElement);
                        } else {
                            deleteUse.setRightChange(addReferenceElement);
                            deleteUse.setLeftChange(deleteElement);
                        }
                        this.addToReportedConflicts(addReferenceElement, deleteElement);
                        conflicts.add(deleteUse);
                    }
                }
                monitor.worked(1);
            }
            for (EObject movedObject : movedEObjects) {
                ModelElementChange deleteElement;
                MoveModelElement moveElement = threeWayDiff.getMoveElement(movedObject, side);
                if (!(!threeWayDiff.isDeleted(movedObject, opposite, true) || this.haveAlreadyReported(deleteElement = threeWayDiff.getDeleteElement(movedObject, opposite), moveElement) || this.shouldIgnore(moveElement) || this.shouldIgnore(deleteElement) || this.shouldIgnore(moveElement, deleteElement))) {
                    DeleteMove deleteMove = CONFLICT_FACTORY.createDeleteMove();
                    if (Side.LEFT.equals(side)) {
                        deleteMove.setLeftChange(moveElement);
                        deleteMove.setRightChange(deleteElement);
                    } else {
                        deleteMove.setRightChange(moveElement);
                        deleteMove.setLeftChange(deleteElement);
                    }
                    this.addToReportedConflicts(moveElement, deleteElement);
                    conflicts.add(deleteMove);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private String toHash(DiffElement diffElement1, DiffElement diffElement2) {
        return String.valueOf(diffElement1.hashCode()) + DIFF_HASH_SEP + diffElement2.hashCode();
    }

    private void addToReportedConflicts(DiffElement element1, DiffElement element2) {
        this.reportedConflictHashes.add(this.toHash(element1, element2));
        this.reportedConflictHashes.add(this.toHash(element2, element1));
    }

    private boolean haveAlreadyReported(DiffElement diffElement1, DiffElement diffElement2) {
        String hash = this.toHash(diffElement1, diffElement2);
        return this.reportedConflictHashes.contains(hash);
    }

    protected boolean shouldIgnore(DiffElement diffElement) {
        return false;
    }

    protected boolean shouldIgnore(DiffElement leftDiffElement, DiffElement rightDiffElement) {
        return false;
    }

    @Override
    public void initialize() {
    }
}

