/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.conflicts.detection.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflictreport.conflict.UpdateUpdate;
import org.modelversioning.conflicts.detection.IThreeWayDiffProvider;
import org.modelversioning.conflicts.detection.engine.IOverlappingChangeDetector;
import org.modelversioning.core.diff.util.DiffUtil;

public class UpdateUpdateConflictDetector
implements IOverlappingChangeDetector {
    private static final String NAME = "Update Update Conflict Detector";
    private Set<DiffElement> ignoredDiffElements = new HashSet<DiffElement>();

    @Override
    public String getId() {
        return "org.modelversioning.conflicts.detection.updateUpdate";
    }

    @Override
    public String getTargetModelNsURI() {
        return "*";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void detectOverlappingChanges(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, IProgressMonitor monitor) {
        EList<EObject> updatedEObjects = threeWayDiff.getUpdatedEObjects(Side.LEFT, false);
        monitor.beginTask("Searching for Update Update conflicts", updatedEObjects.size());
        try {
            for (EObject updatedObject : updatedEObjects) {
                if (threeWayDiff.isUpdated(updatedObject, Side.RIGHT, false)) {
                    Set<DiffElement> leftUpdates = threeWayDiff.getUpdateElements(updatedObject, Side.LEFT);
                    for (DiffElement leftUpdate : leftUpdates) {
                        EStructuralFeature feature = DiffUtil.getUpdatedFeature(leftUpdate);
                        if (feature == null || !this.shouldRaiseConflictForFeature(feature) || !threeWayDiff.isUpdated(updatedObject, feature, Side.RIGHT)) continue;
                        this.checkForConflict(threeWayDiff, conflicts, equivalentChanges, updatedObject, leftUpdate, feature);
                    }
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void checkForConflict(IThreeWayDiffProvider threeWayDiff, EList<Conflict> conflicts, EList<EquivalentChange> equivalentChanges, EObject updatedObject, DiffElement leftUpdate, EStructuralFeature feature) {
        HashSet<DiffElement> rightUpdates = new HashSet<DiffElement>(threeWayDiff.getUpdateElements(updatedObject, feature, Side.RIGHT));
        if (rightUpdates != null) {
            for (DiffElement rightUpdate : rightUpdates) {
                if (!this.shouldIgnore(rightUpdate) && !this.shouldIgnore(leftUpdate, rightUpdate)) {
                    if (!threeWayDiff.isEqual(leftUpdate, rightUpdate)) {
                        UpdateUpdate updateUpdate = CONFLICT_FACTORY.createUpdateUpdate();
                        updateUpdate.setLeftChange(leftUpdate);
                        updateUpdate.setRightChange(rightUpdate);
                        conflicts.add(updateUpdate);
                        continue;
                    }
                    EquivalentChange equivalentChange = CONFLICT_REPORT_FACTORY.createEquivalentChange();
                    equivalentChange.setPreferSide(Side.LEFT);
                    equivalentChange.setLeftChange(leftUpdate);
                    equivalentChange.setRightChange(rightUpdate);
                    equivalentChanges.add(equivalentChange);
                    this.ignoredDiffElements.add(rightUpdate);
                    continue;
                }
                this.ignoredDiffElements.add(rightUpdate);
            }
        }
    }

    protected boolean shouldIgnore(DiffElement diffElement) {
        return this.ignoredDiffElements.contains(diffElement);
    }

    protected boolean shouldIgnore(DiffElement leftDiffElement, DiffElement rightDiffElement) {
        return false;
    }

    protected boolean shouldRaiseConflictForFeature(EStructuralFeature feature) {
        return !feature.isMany();
    }

    @Override
    public void initialize() {
    }
}

