/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConditionType implements Enumerator
{
    ONTOLOGICAL(0, "ONTOLOGICAL", "ONTOLOGICAL"),
    LINGUISTIC(1, "LINGUISTIC", "LINGUISTIC");

    public static final int ONTOLOGICAL_VALUE = 0;
    public static final int LINGUISTIC_VALUE = 1;
    private static final ConditionType[] VALUES_ARRAY;
    public static final List<ConditionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConditionType[]{ONTOLOGICAL, LINGUISTIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConditionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConditionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConditionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConditionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConditionType get(int value) {
        switch (value) {
            case 0: {
                return ONTOLOGICAL;
            }
            case 1: {
                return LINGUISTIC;
            }
        }
        return null;
    }

    private ConditionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

