/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EvaluationStatus implements Enumerator
{
    SATISFIED(0, "SATISFIED", "SATISFIED"),
    UNSATISFIED(1, "UNSATISFIED", "UNSATISFIED"),
    ERROR(2, "ERROR", "ERROR");

    public static final int SATISFIED_VALUE = 0;
    public static final int UNSATISFIED_VALUE = 1;
    public static final int ERROR_VALUE = 2;
    private static final EvaluationStatus[] VALUES_ARRAY;
    public static final List<EvaluationStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EvaluationStatus[]{SATISFIED, UNSATISFIED, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EvaluationStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EvaluationStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EvaluationStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EvaluationStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EvaluationStatus get(int value) {
        switch (value) {
            case 0: {
                return SATISFIED;
            }
            case 1: {
                return UNSATISFIED;
            }
            case 2: {
                return ERROR;
            }
        }
        return null;
    }

    private EvaluationStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

