/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum State implements Enumerator
{
    GENERATED(0, "GENERATED", "GENERATED"),
    EDITED(1, "EDITED", "EDITED"),
    USER_DEFINED(2, "USER_DEFINED", "USER_DEFINED");

    public static final int GENERATED_VALUE = 0;
    public static final int EDITED_VALUE = 1;
    public static final int USER_DEFINED_VALUE = 2;
    private static final State[] VALUES_ARRAY;
    public static final List<State> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new State[]{GENERATED, EDITED, USER_DEFINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static State get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            State result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static State getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            State result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static State get(int value) {
        switch (value) {
            case 0: {
                return GENERATED;
            }
            case 1: {
                return EDITED;
            }
            case 2: {
                return USER_DEFINED;
            }
        }
        return null;
    }

    private State(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

