/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.attcorrespondences.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.attcorrespondences.IAttributeCorrespondenceFinder;
import org.modelversioning.core.conditions.attcorrespondences.ICorrespondenceSuggestion;
import org.modelversioning.core.conditions.attcorrespondences.impl.CorrespondenceSuggestionImpl;
import org.modelversioning.core.conditions.attcorrespondences.impl.StringTemplateFeature;
import org.modelversioning.core.conditions.util.ConditionsUtil;

public class AttributeCorrespondenceFinderImpl
implements IAttributeCorrespondenceFinder {
    private List<ICorrespondenceSuggestion> suggestions = new ArrayList<ICorrespondenceSuggestion>();
    private static Pattern stringFinderPattern = Pattern.compile("'[\\w]*'");
    private FindMode mode = FindMode.SINGLE_MODEL;
    private String prefix = null;
    private ConditionsModel conditionsModel = null;
    private ConditionsModel referencedConditionsModel = null;
    private Map<String, List<StringTemplateFeature>> stringToFeatureMap = new HashMap<String, List<StringTemplateFeature>>();

    protected boolean isInSingleMode() {
        return this.mode.equals((Object)FindMode.SINGLE_MODEL);
    }

    protected boolean isInDualMode() {
        return this.mode.equals((Object)FindMode.DUAL_MODEL);
    }

    @Override
    public List<ICorrespondenceSuggestion> getCorrespondenceSuggestions() {
        return Collections.unmodifiableList(this.suggestions);
    }

    @Override
    public List<ICorrespondenceSuggestion> getCorrespondenceSuggestions(Template template) {
        return Collections.unmodifiableList(this.filterByTemplate(this.suggestions, template));
    }

    private List<? extends ICorrespondenceSuggestion> filterByTemplate(List<ICorrespondenceSuggestion> suggestions, Template template) {
        ArrayList<ICorrespondenceSuggestion> list = new ArrayList<ICorrespondenceSuggestion>();
        for (ICorrespondenceSuggestion suggestion : suggestions) {
            if (!template.equals(suggestion.getTemplate())) continue;
            list.add(suggestion);
        }
        return list;
    }

    @Override
    public List<ICorrespondenceSuggestion> getCorrespondenceSuggestions(Condition condition) {
        return Collections.unmodifiableList(this.filterByCondition(this.suggestions, condition));
    }

    private List<? extends ICorrespondenceSuggestion> filterByCondition(List<ICorrespondenceSuggestion> suggestions, Condition condition) {
        ArrayList<ICorrespondenceSuggestion> list = new ArrayList<ICorrespondenceSuggestion>();
        for (ICorrespondenceSuggestion suggestion : suggestions) {
            if (!condition.equals(suggestion.getCondition())) continue;
            list.add(suggestion);
        }
        return list;
    }

    @Override
    public void initialize(ConditionsModel conditionsModel) {
        this.conditionsModel = conditionsModel;
        this.referencedConditionsModel = null;
        this.prefix = null;
        this.mode = FindMode.SINGLE_MODEL;
        this.generateStringToFeatureMap(this.conditionsModel);
        this.generateSuggestions(this.conditionsModel);
        this.sortSuggestions();
    }

    @Override
    public void initialize(ConditionsModel conditionsModel, ConditionsModel referencedConditionsModel, String prefix) {
        this.conditionsModel = conditionsModel;
        this.referencedConditionsModel = referencedConditionsModel;
        this.prefix = prefix;
        this.mode = FindMode.DUAL_MODEL;
        this.generateStringToFeatureMap(this.referencedConditionsModel);
        this.generateSuggestions(this.conditionsModel);
        this.sortSuggestions();
    }

    private void generateSuggestions(ConditionsModel conditionsModel) {
        this.generateSuggestions(conditionsModel.getRootTemplate());
    }

    private void generateSuggestions(Template template) {
        for (Condition condition : template.getSpecifications()) {
            String expression = ConditionsUtil.getExpression(condition);
            Matcher matcher = stringFinderPattern.matcher(expression);
            while (matcher.find()) {
                String match = matcher.group();
                String string = match.substring(1, match.length() - 1);
                List<StringTemplateFeature> stringToFeatures = this.getStringToFeatures(string);
                for (StringTemplateFeature stringTemplateFeature : stringToFeatures) {
                    String replacement = "#{";
                    if (this.mode.equals((Object)FindMode.DUAL_MODEL)) {
                        replacement = String.valueOf(replacement) + this.prefix;
                        replacement = String.valueOf(replacement) + ":";
                    }
                    replacement = String.valueOf(replacement) + stringTemplateFeature.getTemplate().getName();
                    replacement = String.valueOf(replacement) + "}." + stringTemplateFeature.getFeature().getName();
                    String replacedExpression = expression.replace(match, replacement);
                    CorrespondenceSuggestionImpl suggestion = new CorrespondenceSuggestionImpl();
                    suggestion.setTemplate(template);
                    suggestion.setCondition(condition);
                    suggestion.getReferencedTemplates().add(stringTemplateFeature.getTemplate());
                    suggestion.getReferencedFeatures().add(stringTemplateFeature.getFeature());
                    suggestion.setImportance(1.0);
                    suggestion.setDescription("Replace " + match + " with a reference to the feature '" + stringTemplateFeature.getFeature().getName() + "' of the template '" + stringTemplateFeature.getTemplate().getTitle() + "'.");
                    suggestion.setReplacedExpression(replacedExpression);
                    this.suggestions.add(suggestion);
                }
            }
        }
        if (!template.getSubTemplates().isEmpty()) {
            for (Template subTemplate : template.getSubTemplates()) {
                this.generateSuggestions(subTemplate);
            }
        }
    }

    private void generateStringToFeatureMap(ConditionsModel conditionsModel) {
        this.stringToFeatureMap.clear();
        Template rootTemplate = conditionsModel.getRootTemplate();
        this.generateStringToFeatureMap(rootTemplate);
    }

    private void generateStringToFeatureMap(Template template) {
        EClass eClass = template.getRepresentative().eClass();
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            String value;
            EClassifier eRawType = feature.getEGenericType().getERawType();
            if (!(eRawType instanceof EDataType) || !eRawType.getName().equals("EString") || (value = (String)template.getRepresentative().eGet(feature)) == null) continue;
            this.addStringToFeature(new StringTemplateFeature(value, feature, template));
        }
        if (!template.getSubTemplates().isEmpty()) {
            for (Template subTemplate : template.getSubTemplates()) {
                this.generateStringToFeatureMap(subTemplate);
            }
        }
    }

    private void addStringToFeature(StringTemplateFeature stringTemplateFeature) {
        if (this.stringToFeatureMap.get(stringTemplateFeature.getString()) == null) {
            this.stringToFeatureMap.put(stringTemplateFeature.getString(), new ArrayList());
        }
        this.stringToFeatureMap.get(stringTemplateFeature.getString()).add(stringTemplateFeature);
    }

    private List<StringTemplateFeature> getStringToFeatures(String string) {
        if (this.stringToFeatureMap.get(string) == null) {
            return Collections.emptyList();
        }
        return this.stringToFeatureMap.get(string);
    }

    private void sortSuggestions() {
        Collections.sort(this.suggestions);
    }

    private static enum FindMode {
        SINGLE_MODEL,
        DUAL_MODEL;

    }
}

