/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.attcorrespondences.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.core.conditions.AttributeCorrespondenceCondition;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsFactory;
import org.modelversioning.core.conditions.CustomCondition;
import org.modelversioning.core.conditions.FeatureCondition;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.attcorrespondences.ICorrespondenceSuggestion;

public class CorrespondenceSuggestionImpl
implements ICorrespondenceSuggestion {
    private double importance = 0.0;
    private Condition condition = null;
    private List<Template> referencedTemplates = new ArrayList<Template>();
    private List<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
    private Template template = null;
    private String replacedExpression = null;
    private String description = null;
    private boolean applied = false;

    protected CorrespondenceSuggestionImpl() {
    }

    @Override
    public void apply() {
        Assert.isTrue(this.condition != null, "Cannot apply suggestion to null condition");
        Assert.isTrue(this.condition instanceof FeatureCondition || this.condition instanceof CustomCondition, "Unknown condition type");
        if (!this.applied) {
            EcoreUtil.remove(this.condition);
            this.template.getSpecifications().add(this.generateAttributeCorrespondenceCondition());
            this.applied = true;
        }
    }

    private AttributeCorrespondenceCondition generateAttributeCorrespondenceCondition() {
        AttributeCorrespondenceCondition attributeCorrespondenceCondition = ConditionsFactory.eINSTANCE.createAttributeCorrespondenceCondition();
        attributeCorrespondenceCondition.setActive(true);
        attributeCorrespondenceCondition.setInvolvesTemplate(true);
        attributeCorrespondenceCondition.setState(this.condition.getState());
        attributeCorrespondenceCondition.setType(this.condition.getType());
        attributeCorrespondenceCondition.setExpression(this.replacedExpression);
        if (this.condition instanceof FeatureCondition) {
            attributeCorrespondenceCondition.setFeature(((FeatureCondition)this.condition).getFeature());
        } else if (this.features.size() > 0) {
            attributeCorrespondenceCondition.setFeature(this.features.get(0));
        }
        attributeCorrespondenceCondition.getCorrespondingFeatures().addAll(this.getReferencedFeatures());
        attributeCorrespondenceCondition.getCorrespondingTemplates().addAll(this.getReferencedTemplates());
        return attributeCorrespondenceCondition;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public double getImportance() {
        return this.importance;
    }

    @Override
    public List<Template> getReferencedTemplates() {
        return this.referencedTemplates;
    }

    @Override
    public List<EStructuralFeature> getReferencedFeatures() {
        return this.features;
    }

    @Override
    public String getReplacedExpression() {
        return this.replacedExpression;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setImportance(double importance) {
        this.importance = importance;
    }

    protected void setCondition(Condition condition) {
        this.condition = condition;
    }

    protected void setReferencedTemplates(List<Template> referencedTemplates) {
        this.referencedTemplates = referencedTemplates;
    }

    protected void setTemplate(Template template) {
        this.template = template;
    }

    protected void setReplacedExpression(String replacedExpression) {
        this.replacedExpression = replacedExpression;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int compareTo(ICorrespondenceSuggestion o) {
        if (this.getImportance() == o.getImportance()) {
            return 0;
        }
        if (this.getImportance() > o.getImportance()) {
            return 1;
        }
        return -1;
    }
}

