/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.engines.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.options.ParsingOptions;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsFactory;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.ConditionsPlugin;
import org.modelversioning.core.conditions.CustomCondition;
import org.modelversioning.core.conditions.EvaluationResult;
import org.modelversioning.core.conditions.EvaluationStatus;
import org.modelversioning.core.conditions.FeatureCondition;
import org.modelversioning.core.conditions.NonExistenceGroup;
import org.modelversioning.core.conditions.OptionGroup;
import org.modelversioning.core.conditions.State;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.BindingException;
import org.modelversioning.core.conditions.engines.IConditionEvaluationEngine;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.UnsupportedConditionLanguage;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingCreator;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingsImpl;
import org.modelversioning.core.conditions.util.ConditionsUtil;

public class ConditionsEvaluationEngineImpl
implements IConditionEvaluationEngine {
    private static final String ERR_UNKOWN_COND_TYPE = "Unkown condition type: ";
    private static final String NO_COMMON_PARENT = "No common parent";
    protected static final String EVALUATOR = "OCL AMOR Condition Evaluator";
    private ConditionsModel conditionsModel = null;
    private Map<String, ITemplateBindings> relatedBindings = new HashMap<String, ITemplateBindings>();
    private OCL<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> ocl = null;
    private Map<Template, OCLHelper<EClassifier, EOperation, EStructuralFeature, Constraint>> oclHelperMap = new HashMap<Template, OCLHelper<EClassifier, EOperation, EStructuralFeature, Constraint>>();
    private TemplateBindingCreator templateBindingCreator;
    private EList<Template> templates;
    private EList<Template> normalTemplates;
    private EList<Template> nonExistenceTemplates;
    private EList<Template> optionalTemplates;
    private OptionGroup currentOptionGroup = null;
    private NonExistenceGroup currentNonExistenceGroup = null;
    private EList<OptionGroup> activatedOptionGroups = new BasicEList<OptionGroup>();
    private boolean isTypeAware = true;
    private boolean isContainmentAware = true;
    private boolean isThrowExceptionOnParserError = false;
    private EvaluationRunMode evaluationRunState = EvaluationRunMode.FIRST_RUN;

    @Override
    public boolean isTypeAware() {
        return this.isTypeAware;
    }

    @Override
    public void setTypeAware(boolean isTypeAware) {
        this.isTypeAware = isTypeAware;
    }

    @Override
    public boolean isContainmentAware() {
        return this.isContainmentAware;
    }

    @Override
    public void setContainmentAware(boolean isContainmentAware) {
        this.isContainmentAware = isContainmentAware;
    }

    public boolean isThrowExceptionOnParserError() {
        return this.isThrowExceptionOnParserError;
    }

    public void setThrowExceptionOnParserError(boolean isThrowExceptionOnParserError) {
        this.isThrowExceptionOnParserError = isThrowExceptionOnParserError;
    }

    protected OCL<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getOclInstance(Template template) {
        if (this.ocl == null) {
            this.ocl = OCL.newInstance(EcoreEnvironmentFactory.INSTANCE);
            ParsingOptions.setOption(this.ocl.getEnvironment(), ParsingOptions.implicitRootClass(this.ocl.getEnvironment()), EcorePackage.Literals.EOBJECT);
        }
        return this.ocl;
    }

    protected OCLHelper<EClassifier, EOperation, EStructuralFeature, Constraint> getOclHelperInstance(Template template) {
        if (!this.oclHelperMap.containsKey(template)) {
            OCLHelper<EClassifier, EOperation, EStructuralFeature, Constraint> helper = this.getOclInstance(template).createOCLHelper();
            helper.setContext(template.getRepresentative().eClass());
            this.oclHelperMap.put(template, helper);
        }
        return this.oclHelperMap.get(template);
    }

    private OCLExpression<EClassifier> createQueryForCondition(Condition condition) throws ParserException {
        String oclExpression = this.createOclExpression(condition, "self.", "");
        return this.getOclHelperInstance(condition.getTemplate()).createQuery(oclExpression);
    }

    private Constraint createQueryForExpression(Template template, String expression) throws ParserException {
        Constraint constraint = this.getOclHelperInstance(template).createConstraint(ConstraintKind.INVARIANT, expression);
        return constraint;
    }

    private EvaluationResult createEvaluationResult(Throwable throwable) {
        EvaluationResult evaluationResult = ConditionsFactory.eINSTANCE.createEvaluationResult();
        evaluationResult.setStatus(EvaluationStatus.ERROR);
        evaluationResult.setException(throwable);
        evaluationResult.setMessage(throwable.getMessage());
        evaluationResult.setEvaluator(EVALUATOR);
        return evaluationResult;
    }

    protected EvaluationResult createEvaluationResult(boolean satisfied) {
        EvaluationResult evaluationResult = ConditionsFactory.eINSTANCE.createEvaluationResult();
        if (satisfied) {
            evaluationResult.setStatus(EvaluationStatus.SATISFIED);
        } else {
            evaluationResult.setStatus(EvaluationStatus.UNSATISFIED);
        }
        evaluationResult.setEvaluator(EVALUATOR);
        return evaluationResult;
    }

    private EvaluationResult createEvaluationResult(EList<EvaluationResult> resultList) {
        EvaluationResult evaluationResult = ConditionsFactory.eINSTANCE.createEvaluationResult();
        boolean isSatisfied = true;
        boolean isError = false;
        for (EvaluationResult subEvaluationResult : resultList) {
            if (subEvaluationResult.isOK()) continue;
            isSatisfied = false;
            if (!subEvaluationResult.getStatus().equals(EvaluationStatus.ERROR)) continue;
            isError = true;
        }
        if (isSatisfied) {
            evaluationResult.setStatus(EvaluationStatus.SATISFIED);
        } else if (isError) {
            evaluationResult.setStatus(EvaluationStatus.ERROR);
        } else {
            evaluationResult.setStatus(EvaluationStatus.UNSATISFIED);
        }
        evaluationResult.getSubResults().addAll(resultList);
        evaluationResult.setEvaluator(EVALUATOR);
        return evaluationResult;
    }

    private String createOclExpression(Condition condition, String prefix, String postfix) {
        String oclExpression = "";
        if (condition instanceof FeatureCondition) {
            FeatureCondition featureCondition = (FeatureCondition)condition;
            oclExpression = String.valueOf(oclExpression) + prefix;
            oclExpression = String.valueOf(oclExpression) + featureCondition.getFeature().getName();
            oclExpression = String.valueOf(oclExpression) + featureCondition.getExpression();
            oclExpression = String.valueOf(oclExpression) + postfix;
        } else if (condition instanceof CustomCondition) {
            CustomCondition customOCLCondition = (CustomCondition)condition;
            oclExpression = String.valueOf(oclExpression) + prefix;
            oclExpression = String.valueOf(oclExpression) + customOCLCondition.getExpression();
            oclExpression = String.valueOf(oclExpression) + postfix;
        } else {
            ConditionsPlugin.getDefault().getLog().log(new Status(4, "org.modelversioning.core.conditions", ERR_UNKOWN_COND_TYPE + condition));
        }
        return oclExpression;
    }

    protected String createRelativeOCLExpression(EObject baseObject, EObject targetObject) {
        if (baseObject.equals(targetObject)) {
            return "self";
        }
        List<EObject> targetsParents = org.modelversioning.core.util.EcoreUtil.createParentList(targetObject);
        EObject commonParent = org.modelversioning.core.util.EcoreUtil.findLeastCommonParentObject(baseObject, targetObject);
        if (commonParent == null) {
            throw new IllegalArgumentException(NO_COMMON_PARENT);
        }
        String oclExpression = "self";
        EObject currentParent = baseObject;
        boolean commonParentReached = commonParent.equals(currentParent);
        while (!commonParentReached && (currentParent = currentParent.eContainer()) != null) {
            oclExpression = String.valueOf(oclExpression) + ".eContainer()";
            if (!currentParent.equals(commonParent)) continue;
            commonParentReached = true;
        }
        targetsParents.add(0, targetObject);
        boolean addedEContents = false;
        int i = targetsParents.indexOf(commonParent) - 1;
        while (i >= 0) {
            oclExpression = String.valueOf(oclExpression) + ".eContents()";
            int position = targetsParents.get(i + 1).eContents().indexOf(targetsParents.get(i)) + 1;
            oclExpression = String.valueOf(oclExpression) + "->at(" + position + ")";
            oclExpression = String.valueOf(oclExpression) + ".oclAsType(" + targetsParents.get(i).eClass().getEPackage().getName() + "::" + targetsParents.get(i).eClass().getName() + ")";
            addedEContents = true;
            --i;
        }
        if (!addedEContents) {
            oclExpression = String.valueOf(oclExpression) + ".oclAsType(" + targetObject.eClass().getEPackage().getName() + "::" + targetObject.eClass().getName() + ")";
        }
        return oclExpression;
    }

    private boolean isSatisfied(Condition condition, EObject eObject) throws ParserException {
        boolean isSatisfied = false;
        if (!this.isLocal(condition)) {
            ITemplateBinding preBinding = this.templateBindingCreator.createEmptyTemplateBinding();
            preBinding.add(condition.getTemplate(), eObject);
            Collection<ITemplateBinding> allBindingCombinations = this.templateBindingCreator.calcTemplateObjectPermutation(this.extractInvolvedTemplates(condition), preBinding, null, this.templateBindingCreator.createEmptyTemplateBinding());
            for (ITemplateBinding bindingCombination : allBindingCombinations) {
                if (!this.isSatisfied(eObject, bindingCombination.getSingleBindingMap(), condition)) continue;
                isSatisfied = true;
                break;
            }
        } else {
            isSatisfied = this.getOclInstance(condition.getTemplate()).check((Object)eObject, this.createQueryForCondition(condition));
        }
        return isSatisfied;
    }

    private boolean isSatisfied(Constraint constraint, Template template, EObject eObject) {
        return this.getOclInstance(template).check((Object)eObject, constraint);
    }

    private boolean isSatisfied(Condition condition, EObject eObject, ITemplateBinding preBinding) throws ParserException {
        boolean isSatisfied = false;
        if (!this.isLocal(condition)) {
            Set<Template> referencedTemplates = this.extractInvolvedTemplates(condition);
            Collection<ITemplateBinding> permutation = this.templateBindingCreator.calcTemplateObjectPermutation(referencedTemplates, preBinding, null, this.templateBindingCreator.createEmptyTemplateBinding());
            for (ITemplateBinding iTemplateBinding : permutation) {
                if (!this.isSatisfied(eObject, iTemplateBinding.getSingleBindingMap(), condition)) continue;
                return true;
            }
        } else {
            isSatisfied = this.isSatisfied(condition, eObject);
        }
        return isSatisfied;
    }

    protected boolean isLocal(Condition condition) {
        String expression = ConditionsUtil.getExpression(condition);
        boolean foundTemplate = ConditionsUtil.singleTemplateNamePattern.matcher(expression).find();
        boolean foundPrefixedTemplate = ConditionsUtil.singlePrefixedTemplateNamePattern.matcher(expression).find();
        return !foundTemplate && !foundPrefixedTemplate;
    }

    protected Set<Template> extractInvolvedTemplates(Set<Condition> conditions) {
        HashSet<Template> templates = new HashSet<Template>();
        for (Condition condition : conditions) {
            templates.addAll(this.extractInvolvedTemplates(condition));
        }
        return templates;
    }

    protected Set<Template> extractInvolvedTemplates(Condition condition) {
        return this.extractInvolvedTemplates(ConditionsUtil.getExpression(condition));
    }

    protected Set<Template> extractInvolvedTemplates(String oclExpression) {
        HashSet<Template> extractedTemplates = new HashSet<Template>();
        Map<String, Set<String>> referencedTemplateNames = ConditionsUtil.getReferencedTemplateNames(oclExpression);
        if (referencedTemplateNames.get("") != null) {
            for (String templateName : referencedTemplateNames.get("")) {
                Template template = this.getTemplateByName(templateName);
                if (template == null) continue;
                extractedTemplates.add(template);
            }
        }
        return extractedTemplates;
    }

    protected Map<String, Set<Template>> extractInvolvedPrefixedTemplates(Condition condition) {
        String oclExpression = this.createOclExpression(condition, "", "");
        return this.extractInvolvedPrefixedTemplatesFromString(oclExpression);
    }

    private Map<String, Set<Template>> extractInvolvedPrefixedTemplatesFromString(String expression) {
        HashMap<String, Set<Template>> extractedTemplates = new HashMap<String, Set<Template>>();
        Map<String, Set<String>> referencedTemplateNames = ConditionsUtil.getReferencedTemplateNames(expression);
        for (String prefix : referencedTemplateNames.keySet()) {
            if ("".equals(prefix)) continue;
            for (String templateName : referencedTemplateNames.get(prefix)) {
                Template template = this.getTemplateByName(prefix, templateName);
                if (template == null) continue;
                if (extractedTemplates.get(prefix) == null) {
                    extractedTemplates.put(prefix, new HashSet());
                }
                ((Set)extractedTemplates.get(prefix)).add(template);
            }
        }
        return extractedTemplates;
    }

    private Template getTemplateByName(String templateName) {
        return ConditionsUtil.getTemplateByName(templateName, this.getConditionsModel());
    }

    private Template getTemplateByName(String prefix, String templateName) {
        ITemplateBindings binding = this.relatedBindings.get(prefix);
        if (binding != null) {
            for (Template template : binding.getTemplates()) {
                if (!templateName.equals(template.getName())) continue;
                return template;
            }
        }
        return null;
    }

    protected boolean isSatisfied(EObject eObject, Map<Template, EObject> referencedEObjectMap, Condition condition) throws ParserException {
        String oclExpression = this.createReplacedOCLExpression(eObject, referencedEObjectMap, condition);
        try {
            Constraint constraint = this.createQueryForExpression(condition.getTemplate(), oclExpression);
            boolean isSatisfied = this.isSatisfied(constraint, condition.getTemplate(), eObject);
            return isSatisfied;
        }
        catch (ParserException e) {
            if (this.isThrowExceptionOnParserError) {
                throw e;
            }
            return false;
        }
    }

    private String createReplacedOCLExpression(EObject eObject, Map<Template, EObject> referencedEObjectMap, Condition condition) {
        String oclExpression = this.createOclExpression(condition, "self.", "");
        oclExpression = this.createReplacedOCLExpression(eObject, referencedEObjectMap, oclExpression);
        return oclExpression;
    }

    private String createReplacedOCLExpression(EObject eObject, Map<Template, EObject> referencedEObjectMap, String oclExpression) {
        Map<String, Set<Template>> prefixedTemplates = this.extractInvolvedPrefixedTemplatesFromString(oclExpression);
        for (String prefix : prefixedTemplates.keySet()) {
            for (Template template : prefixedTemplates.get(prefix)) {
                for (String featureName : ConditionsUtil.getReferencedFeatureNames(prefix, template, oclExpression)) {
                    try {
                        EStructuralFeature feature = template.getRepresentative().eClass().getEStructuralFeature(featureName);
                        if (this.relatedBindings.get(prefix).getBoundObjects(template).size() <= 0) continue;
                        EObject object = this.relatedBindings.get(prefix).getBoundObjects(template).iterator().next();
                        Object value = object.eGet(feature);
                        String replacement = "";
                        if (!(feature.getEGenericType().getERawType() instanceof EDataType)) continue;
                        EDataType dataType = (EDataType)feature.getEGenericType().getERawType();
                        replacement = String.class.equals(dataType.getInstanceClass()) ? "'" + value + "'" : value.toString();
                        oclExpression = oclExpression.replace("#{" + prefix + ":" + template.getName() + "}" + "." + featureName, replacement);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
        }
        Set<Template> templates = this.extractInvolvedTemplates(oclExpression);
        for (Template template : templates) {
            String replacement = this.createRelativeOCLExpression(eObject, referencedEObjectMap.get(template));
            oclExpression = oclExpression.replace("#{" + template.getName() + "}", replacement);
        }
        return oclExpression;
    }

    protected Set<String> getReferencedFeatures(String prefix, Template template, Condition condition) {
        String oclExpression = this.createOclExpression(condition, "", "");
        return ConditionsUtil.getReferencedFeatureNames(prefix, template, oclExpression);
    }

    @Override
    public boolean isComplete(ITemplateBinding binding) {
        for (Template template : this.templates) {
            if (!this.shouldEvaluate(template) || binding.getBoundObjects(template) != null && binding.getBoundObjects(template).size() >= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public ConditionsModel getConditionsModel() {
        return this.conditionsModel;
    }

    @Override
    public void setConditionsModel(ConditionsModel conditionsModel) throws UnsupportedConditionLanguage {
        if (!"OCL".equals(conditionsModel.getLanguage())) {
            throw new UnsupportedConditionLanguage();
        }
        this.conditionsModel = conditionsModel;
        this.initialize();
    }

    public void initialize() {
        this.evaluationRunState = EvaluationRunMode.FIRST_RUN;
        this.currentOptionGroup = null;
        this.currentNonExistenceGroup = null;
        this.activatedOptionGroups.clear();
        this.templateBindingCreator = new TemplateBindingCreator(this);
        this.extractTemplates(this.conditionsModel);
        this.deriveInvolvesTemplateProperty(this.conditionsModel);
    }

    private void extractTemplates(ConditionsModel conditionsModel) {
        this.templates = ConditionsUtil.getAllTemplates(conditionsModel);
        this.normalTemplates = new BasicEList<Template>();
        this.nonExistenceTemplates = new BasicEList<Template>();
        this.optionalTemplates = new BasicEList<Template>();
        for (Template template : this.templates) {
            if (ConditionsUtil.isOptional(template, true)) {
                this.optionalTemplates.add(template);
                continue;
            }
            if (ConditionsUtil.isNonExistence(template, true)) {
                this.nonExistenceTemplates.add(template);
                continue;
            }
            this.normalTemplates.add(template);
        }
    }

    protected List<Template> getTemplatesToEvaluate() {
        BasicEList<Template> templates = new BasicEList<Template>();
        templates.addAll(this.normalTemplates);
        for (OptionGroup activatedOptGroup : this.activatedOptionGroups) {
            templates.addAll(activatedOptGroup.getTemplates());
        }
        if (EvaluationRunMode.ALL.equals((Object)this.evaluationRunState)) {
            templates.addAll(this.nonExistenceTemplates);
            templates.addAll(this.optionalTemplates);
        } else if (EvaluationRunMode.CHECK_NONEXISTENCE.equals((Object)this.evaluationRunState)) {
            templates.addAll(this.currentNonExistenceGroup.getTemplates());
        } else if (EvaluationRunMode.CHECK_OPTIONAL.equals((Object)this.evaluationRunState)) {
            templates.addAll(this.currentOptionGroup.getTemplates());
        }
        return templates;
    }

    protected boolean shouldEvaluate(Template template) {
        return this.getTemplatesToEvaluate().contains(template);
    }

    protected boolean shouldEvaluate(Condition condition) {
        if (!condition.isActive()) {
            return false;
        }
        Set<Template> involvedTemplates = this.extractInvolvedTemplates(condition);
        for (Template involdedTemplate : involvedTemplates) {
            if (this.shouldEvaluate(involdedTemplate)) continue;
            return false;
        }
        return true;
    }

    public Set<Condition> getTemplateInvolvingConditionsToEvaluate(Template template) {
        HashSet<Condition> conditions = new HashSet<Condition>();
        for (Condition condition : ConditionsUtil.getActiveTemplateInvolvingConditions(template)) {
            if (!this.shouldEvaluate(condition)) continue;
            conditions.add(condition);
        }
        return conditions;
    }

    private void deriveInvolvesTemplateProperty(ConditionsModel conditionsModel) {
        for (Template template : this.templates) {
            for (Condition condition : template.getSpecifications()) {
                if (this.isLocal(condition)) {
                    condition.setInvolvesTemplate(false);
                    continue;
                }
                condition.setInvolvesTemplate(true);
            }
        }
    }

    protected Condition createContainmentCondition(Template template) {
        Assert.isNotNull(template.getParentTemplate());
        CustomCondition condition = ConditionsFactory.eINSTANCE.createCustomCondition();
        condition.setActive(true);
        condition.setInvolvesTemplate(true);
        condition.setState(State.GENERATED);
        condition.setExpression("eContainer() = #{" + template.getParentTemplate().getName() + "}");
        template.getSpecifications().add(condition);
        return condition;
    }

    private Map<Template, EObject> createTemplateToObjectMap(ConditionsModel conditionsModel) {
        HashMap<Template, EObject> map = new HashMap<Template, EObject>();
        map.put(conditionsModel.getRootTemplate(), conditionsModel.getRootTemplate().getRepresentative());
        TreeIterator<EObject> treeIter = this.getConditionsModel().getRootTemplate().eAllContents();
        while (treeIter.hasNext()) {
            EObject content = (EObject)treeIter.next();
            if (!(content instanceof Template)) continue;
            Template subTemplate = (Template)content;
            map.put(subTemplate, subTemplate.getRepresentative());
        }
        return map;
    }

    private ITemplateBindings doFindTemplateBinding(ITemplateBinding preBinding, ITemplateBinding candidateBinding) {
        try {
            this.initialize();
            TemplateBindingsImpl validBindings = new TemplateBindingsImpl(this.conditionsModel.getRootTemplate());
            for (Template boundTemplate : preBinding.getTemplates()) {
                if (boundTemplate.isMandatory()) continue;
                for (OptionGroup optionGroup : boundTemplate.getOptionGroups()) {
                    if (this.activatedOptionGroups.contains(optionGroup)) continue;
                    this.activatedOptionGroups.add(optionGroup);
                }
            }
            BasicEList<EvaluationResult> evaluationResults = new BasicEList<EvaluationResult>();
            ITemplateBindings firstRunBindings = this.templateBindingCreator.findTemplateBindings(preBinding, candidateBinding);
            if (!firstRunBindings.validate().isOK()) {
                evaluationResults.addAll(firstRunBindings.validate().getSubResults());
            }
            if (this.conditionsModel.getNonExistenceGroups().size() > 0) {
                this.evaluationRunState = EvaluationRunMode.CHECK_NONEXISTENCE;
                for (ITemplateBinding templateBinding : firstRunBindings.getAllPossibleBindings()) {
                    Iterator iterator = this.conditionsModel.getNonExistenceGroups().iterator();
                    while (iterator.hasNext()) {
                        NonExistenceGroup nexGroup;
                        this.currentNonExistenceGroup = nexGroup = (NonExistenceGroup)iterator.next();
                        ITemplateBindings nexBinding = this.templateBindingCreator.findTemplateBindings(templateBinding);
                        if (!nexBinding.validate().isOK()) {
                            validBindings.getAllPossibleBindings().add(templateBinding);
                            continue;
                        }
                        EvaluationResult result = ConditionsFactory.eINSTANCE.createEvaluationResult();
                        result.setEvaluator(EVALUATOR);
                        result.setMessage("Non-existence group " + nexGroup.getName() + " matched.");
                        result.setStatus(EvaluationStatus.UNSATISFIED);
                        evaluationResults.add(result);
                    }
                }
                this.currentNonExistenceGroup = null;
            } else {
                validBindings.getAllPossibleBindings().addAll(firstRunBindings.getAllPossibleBindings());
            }
            this.evaluationRunState = EvaluationRunMode.CHECK_OPTIONAL;
            for (OptionGroup optGroup : this.conditionsModel.getOptionGroups()) {
                if (this.activatedOptionGroups.contains(optGroup)) continue;
                this.currentOptionGroup = optGroup;
                HashSet<ITemplateBinding> bindingsToReplace = new HashSet<ITemplateBinding>();
                for (ITemplateBinding templateBinding : validBindings.getAllPossibleBindings()) {
                    ITemplateBindings optBinding = this.templateBindingCreator.findTemplateBindings(templateBinding);
                    if (!optBinding.validate().isOK()) continue;
                    if (optGroup.isReplace()) {
                        bindingsToReplace.add(templateBinding);
                    }
                    validBindings.getAllPossibleBindings().addAll(optBinding.getAllPossibleBindings());
                }
                validBindings.getAllPossibleBindings().removeAll(bindingsToReplace);
                this.currentOptionGroup = null;
            }
            this.evaluationRunState = EvaluationRunMode.FIRST_RUN;
            boolean isSatisfied = validBindings.getAllPossibleBindings().size() > 0;
            EvaluationResult evaluationResult = this.createEvaluationResult(isSatisfied);
            if (!isSatisfied) {
                evaluationResult.getSubResults().addAll(evaluationResults);
            }
            validBindings.setEvaluationResult(evaluationResult);
            return validBindings;
        }
        catch (BindingException e) {
            TemplateBindingsImpl templateBinding = new TemplateBindingsImpl(null);
            templateBinding.setEvaluationResult(this.createEvaluationResult(e));
            return templateBinding;
        }
        catch (ParserException e) {
            TemplateBindingsImpl templateBinding = new TemplateBindingsImpl(null);
            templateBinding.setEvaluationResult(this.createEvaluationResult(e));
            return templateBinding;
        }
    }

    @Override
    public String getConditionLanguage() {
        return "OCL";
    }

    @Override
    public EvaluationResult evaluate(Condition condition, EObject eObject) {
        try {
            EvaluationResult evaluationResult = this.createEvaluationResult(this.isSatisfied(condition, eObject));
            if (!evaluationResult.isOK()) {
                evaluationResult.setFailedCondition(condition);
            }
            return evaluationResult;
        }
        catch (ParserException e) {
            return this.createEvaluationResult(e);
        }
    }

    @Override
    public EvaluationResult evaluate(Template template, EObject eObject, boolean localOnly) {
        if (this.isTypeAware && !EcoreUtil.equals(eObject.eClass(), template.getRepresentative().eClass())) {
            return this.createEvaluationResult(false);
        }
        if (!localOnly) {
            return this.findTemplateBinding(template, eObject).validate();
        }
        Set<Condition> activeConditions = ConditionsUtil.getActiveConditions(template);
        HashSet<Condition> conditionToEvaluate = new HashSet<Condition>();
        for (Condition condition : activeConditions) {
            if (!this.isLocal(condition)) continue;
            conditionToEvaluate.add(condition);
        }
        boolean isSatisfied = true;
        boolean isError = false;
        HashSet<Condition> failingConditions = new HashSet<Condition>();
        for (Condition condition : conditionToEvaluate) {
            EvaluationResult conditionResult = this.evaluate(condition, eObject);
            if (conditionResult.isOK()) continue;
            failingConditions.add(condition);
            if (conditionResult.getStatus().equals(EvaluationStatus.ERROR)) {
                isError = true;
            }
            if (!conditionResult.getStatus().equals(EvaluationStatus.UNSATISFIED)) continue;
            isSatisfied = false;
        }
        EvaluationResult evalResult = this.createEvaluationResult(isSatisfied);
        if (isError) {
            evalResult.setStatus(EvaluationStatus.ERROR);
        }
        if (failingConditions.size() > 0) {
            evalResult.setFailedCondition((Condition)failingConditions.iterator().next());
        }
        return evalResult;
    }

    @Override
    public ITemplateBindings findTemplateBinding(Template template, EObject eObject) {
        ITemplateBinding preBinding = this.templateBindingCreator.createEmptyTemplateBinding();
        preBinding.add(template, eObject);
        return this.findTemplateBinding(preBinding);
    }

    @Override
    public ITemplateBindings findTemplateBinding(ITemplateBinding preBinding) {
        return this.findTemplateBinding(preBinding, false);
    }

    @Override
    public ITemplateBindings findTemplateBinding(ITemplateBinding preBinding, boolean reEvaluatePreBound) {
        if (reEvaluatePreBound) {
            return this.doFindTemplateBinding(new TemplateBindingImpl(), preBinding);
        }
        return this.doFindTemplateBinding(preBinding, null);
    }

    @Override
    public ITemplateBindings findTemplateBinding(ITemplateBinding preBinding, ITemplateBinding candidateBinding) {
        return this.doFindTemplateBinding(preBinding, candidateBinding);
    }

    @Override
    public EvaluationResult validate(Condition condition) {
        try {
            String oclExpression = this.createReplacedOCLExpression(condition.getTemplate().getRepresentative(), this.createTemplateToObjectMap(this.conditionsModel), condition);
            this.getOclInstance(condition.getTemplate()).validate(this.createQueryForExpression(condition.getTemplate(), oclExpression));
            return this.createEvaluationResult(true);
        }
        catch (Exception e) {
            return this.createEvaluationResult(e);
        }
    }

    @Override
    public EvaluationResult validate(Template template) {
        BasicEList<EvaluationResult> subResults = new BasicEList<EvaluationResult>();
        for (Condition condition : template.getSpecifications()) {
            subResults.add(this.validate(condition));
        }
        return this.createEvaluationResult(subResults);
    }

    @Override
    public EvaluationResult evaluate(Condition condition, EObject eObject, ITemplateBinding preBinding) {
        try {
            return this.createEvaluationResult(this.isSatisfied(condition, eObject, preBinding));
        }
        catch (ParserException e) {
            return this.createEvaluationResult(e);
        }
    }

    @Override
    public Object getValidValue(FeatureCondition condition, EObject eObject, ITemplateBinding binding) {
        try {
            String oclExpression = this.createReplacedOCLExpression(eObject, binding.getSingleBindingMap(), condition);
            oclExpression = oclExpression.replace("self." + condition.getFeature().getName() + " = ", "");
            OCLExpression<EClassifier> query = this.getOclHelperInstance(condition.getTemplate()).createQuery(oclExpression);
            return this.getOclInstance(condition.getTemplate()).createQuery((Constraint)((Object)query)).evaluate(eObject);
        }
        catch (ParserException parserException) {
            return null;
        }
    }

    @Override
    public String replaceTemplateValues(String string, ITemplateBindings templateBinding) {
        Map<String, Set<Template>> prefixedTemplates = this.extractInvolvedPrefixedTemplatesFromString(string);
        for (String prefix : prefixedTemplates.keySet()) {
            for (Template template : prefixedTemplates.get(prefix)) {
                for (String featureName : ConditionsUtil.getReferencedFeatureNames(prefix, template, string)) {
                    EStructuralFeature feature = template.getRepresentative().eClass().getEStructuralFeature(featureName);
                    if (this.relatedBindings.get(prefix).getBoundObjects(template).size() <= 0) continue;
                    EObject object = this.relatedBindings.get(prefix).getBoundObjects(template).iterator().next();
                    Object value = object.eGet(feature);
                    String replacement = "";
                    replacement = value == null ? "null" : value.toString();
                    string = string.replace("#{" + prefix + ":" + template.getName() + "}" + "." + featureName, replacement);
                }
            }
        }
        Set<Template> templates = this.extractInvolvedTemplates(string);
        for (Template template : templates) {
            for (String featureName : ConditionsUtil.getReferencedFeatureNames(template, string)) {
                EStructuralFeature feature = template.getRepresentative().eClass().getEStructuralFeature(featureName);
                if (templateBinding.getBoundObjects(template).size() <= 0) continue;
                EObject object = templateBinding.getBoundObjects(template).iterator().next();
                Object value = object.eGet(feature);
                String replacement = "";
                replacement = value == null ? "null" : value.toString();
                string = string.replace("#{" + template.getName() + "}" + "." + featureName, replacement);
            }
        }
        return string;
    }

    @Override
    public void registerRelatedTemplateBinding(String prefix, ITemplateBindings templateBinding) {
        this.relatedBindings.put(prefix, templateBinding);
    }

    @Override
    public void unregisterRelatedTemplateBinding(String prefix) {
        this.relatedBindings.remove(prefix);
    }

    @Override
    public String getConditionPrefix(Condition condition) {
        String prefix = "";
        if (condition instanceof FeatureCondition) {
            prefix = String.valueOf(prefix) + "self." + ((FeatureCondition)condition).getFeature().getName();
        } else if (condition instanceof CustomCondition) {
            prefix = String.valueOf(prefix) + "self.";
        }
        return prefix;
    }

    @Override
    public Choice[] getContentProposals(String contents, int position, Condition condition) {
        String txtCondition = contents.substring(0, position).trim();
        ConditionsModel conditionsModel = ConditionsUtil.getContainingConditionsModel(condition.getTemplate());
        Map<Template, EObject> eObjectMap = ConditionsUtil.getTemplateToRepresentativeMap(conditionsModel);
        ArrayList<Choice> choices = new ArrayList<Choice>();
        String templateMatch = ConditionsUtil.getUnclosedTemplateNames(txtCondition);
        if (templateMatch != null) {
            choices.addAll(this.createTemplateChoices(templateMatch));
        } else {
            choices.addAll(this.getOclHelperInstance(condition.getTemplate()).getSyntaxHelp(ConstraintKind.INVARIANT, this.createReplacedOCLExpression(condition.getTemplate().getRepresentative(), eObjectMap, txtCondition)));
        }
        return choices.toArray(new Choice[choices.size()]);
    }

    private List<Choice> createTemplateChoices(String templateMatch) {
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (Template template : ConditionsUtil.getAllTemplates(this.conditionsModel)) {
            String templateName;
            if (!template.isActive() || !(templateName = "#{" + template.getName() + "}").startsWith(templateMatch)) continue;
            choices.add(this.newChoice(template, templateName));
        }
        for (String key : this.relatedBindings.keySet()) {
            for (Template template : this.relatedBindings.get(key).getTemplates()) {
                String templateName;
                if (!template.isActive() || !(templateName = "#{" + key + ":" + template.getName() + "}").startsWith(templateMatch)) continue;
                choices.add(this.newChoice(template, templateName));
            }
        }
        return choices;
    }

    private Choice newChoice(final Template template, final String templateName) {
        return new Choice(){

            @Override
            public String getName() {
                return templateName.substring(1);
            }

            @Override
            public ChoiceKind getKind() {
                return ChoiceKind.VARIABLE;
            }

            @Override
            public Object getElement() {
                return template;
            }

            @Override
            public String getDescription() {
                return String.valueOf(template.getTitle()) + " (" + template.getRepresentative().eClass() + ")";
            }
        };
    }

    private static enum EvaluationRunMode {
        ALL,
        FIRST_RUN,
        CHECK_NONEXISTENCE,
        CHECK_OPTIONAL;

    }
}

