/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.engines.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.core.conditions.ConditionsFactory;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.FeatureCondition;
import org.modelversioning.core.conditions.RefinementTemplate;
import org.modelversioning.core.conditions.State;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.IConditionGenerationEngine;
import org.modelversioning.core.conditions.engines.IFeatureConditionGenerator;
import org.modelversioning.core.conditions.engines.impl.GenericFeatureConditionGenerator;
import org.modelversioning.core.conditions.engines.impl.TemplateNameService;
import org.modelversioning.core.conditions.engines.impl.UML2FeatureConditionGenerator;
import org.modelversioning.core.conditions.util.ConditionsUtil;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.core.match.util.MatchUtil;

public class ConditionsGenerationEngineImpl
implements IConditionGenerationEngine {
    private static final String NO_GENERAL_FEATURE_CONDITION_GENERATOR_CONFIGURED = "No general feature condition generator configured.";
    private static final String REFINEMENT_PREFIX = "NAC_";
    private EList<IFeatureConditionGenerator> featureConditionGenerators = new BasicEList<IFeatureConditionGenerator>();
    private TemplateNameService templateNameService = null;
    private TemplateGenerationMode templateGenerationMode = TemplateGenerationMode.STANDALONE;
    private ConditionsModel baseConditionsModel = null;
    private ComparisonResourceSnapshot refinementDifferences = null;

    public ConditionsGenerationEngineImpl() {
        this.featureConditionGenerators.add(new GenericFeatureConditionGenerator());
        this.featureConditionGenerators.add(new UML2FeatureConditionGenerator());
    }

    @Override
    public String getConditionLanguage() {
        return "OCL";
    }

    @Override
    public void addFeatureConditionGenerator(IFeatureConditionGenerator featureConditionGenerator) {
        if ("OCL".equals(featureConditionGenerator.getConditionLanguage())) {
            return;
        }
        this.featureConditionGenerators.add(featureConditionGenerator);
    }

    @Override
    public List<IFeatureConditionGenerator> getFeatureConditionGenerators() {
        return Collections.unmodifiableList(this.featureConditionGenerators);
    }

    @Override
    public void removeFeatureConditionGenerator(IFeatureConditionGenerator featureConditionGenerator) {
        this.featureConditionGenerators.remove(featureConditionGenerator);
    }

    @Override
    public ConditionsModel generateConditionsModel(EObject object) {
        this.templateGenerationMode = TemplateGenerationMode.STANDALONE;
        ConditionsModel conditionsModel = this.createEmptyConditionsModel(object);
        Template rootTemplate = this.createTemplate(object);
        conditionsModel.setRootTemplate(rootTemplate);
        this.deriveSubTemplates(rootTemplate, true);
        this.deriveConditions(rootTemplate, this.getBestFeatureConditionGenerator(object), true);
        this.clearEmptyConditions(rootTemplate);
        return conditionsModel;
    }

    @Override
    public ConditionsModel generateRefinedConditionsModel(EObject object, ConditionsModel baseConditionsModel, ComparisonResourceSnapshot differences) {
        this.baseConditionsModel = baseConditionsModel;
        this.refinementDifferences = differences;
        this.templateGenerationMode = TemplateGenerationMode.REFINEMENT;
        ConditionsModel conditionsModel = this.createEmptyConditionsModel(object);
        RefinementTemplate rootTemplate = this.createRefinementTemplate(object, baseConditionsModel.getRootTemplate());
        conditionsModel.setRootTemplate(rootTemplate);
        this.deriveSubTemplates(rootTemplate, true);
        this.deriveRefinementConditions(rootTemplate, this.getBestFeatureConditionGenerator(object), true);
        this.clearEmptyConditions(rootTemplate);
        return conditionsModel;
    }

    private ConditionsModel createEmptyConditionsModel(EObject object) {
        ConditionsModel conditionsModel = ConditionsFactory.eINSTANCE.createConditionsModel();
        conditionsModel.setCreatedAt(new Date());
        conditionsModel.setLanguage("OCL");
        if (object.eResource() != null) {
            conditionsModel.setModelName(object.eResource().getURI().toString());
        }
        return conditionsModel;
    }

    private IFeatureConditionGenerator getBestFeatureConditionGenerator(EObject object) {
        IFeatureConditionGenerator fcgToUse = null;
        IFeatureConditionGenerator generalFcgToUse = null;
        for (IFeatureConditionGenerator featureConditionGenerator : this.featureConditionGenerators) {
            for (String uri : featureConditionGenerator.getMetaModelNamespace()) {
                if (uri.equals(object.eClass().getEPackage().getNsURI()) && featureConditionGenerator.getConditionLanguage().equals(this.getConditionLanguage())) {
                    fcgToUse = featureConditionGenerator;
                    continue;
                }
                if (!uri.equals("*") || !featureConditionGenerator.getConditionLanguage().equals(this.getConditionLanguage())) continue;
                generalFcgToUse = featureConditionGenerator;
            }
        }
        if (fcgToUse != null) {
            return fcgToUse;
        }
        if (generalFcgToUse != null) {
            return generalFcgToUse;
        }
        throw new RuntimeException(NO_GENERAL_FEATURE_CONDITION_GENERATOR_CONFIGURED);
    }

    private void deriveConditions(Template template, IFeatureConditionGenerator featureConditionGenerator, boolean recursive) {
        if (template.getRepresentative() == null) {
            return;
        }
        BasicEList<EStructuralFeature> features = new BasicEList<EStructuralFeature>();
        features.addAll(template.getRepresentative().eClass().getEAllAttributes());
        features.addAll(template.getRepresentative().eClass().getEAllReferences());
        features.removeAll(template.getRepresentative().eClass().getEAllContainments());
        for (EStructuralFeature feature : features) {
            List<FeatureCondition> condition = featureConditionGenerator.generateFeatureCondition(feature, template);
            if (condition == null) continue;
            template.getSpecifications().addAll(condition);
        }
        if (recursive) {
            for (Template subTemplate : template.getSubTemplates()) {
                this.deriveConditions(subTemplate, featureConditionGenerator, recursive);
            }
        }
    }

    private void deriveRefinementConditions(Template template, IFeatureConditionGenerator featureConditionGenerator, boolean recursive) {
        if (template.getRepresentative() == null) {
            return;
        }
        if (TemplateGenerationMode.STANDALONE.equals((Object)this.templateGenerationMode)) {
            this.deriveConditions(template, featureConditionGenerator, recursive);
            return;
        }
        if (template instanceof RefinementTemplate) {
            EList<DiffElement> diffElements = DiffUtil.getEffectiveDiffElements(template.getRepresentative(), this.refinementDifferences.getDiff());
            for (DiffElement diffElement : diffElements) {
                ReferenceChange referenceChange;
                EReference reference;
                List<FeatureCondition> conditions;
                if (diffElement instanceof AttributeChange) {
                    AttributeChange attributeChange = (AttributeChange)diffElement;
                    EAttribute attribute = attributeChange.getAttribute();
                    conditions = featureConditionGenerator.generateFeatureCondition(attribute, template);
                    if (conditions == null) continue;
                    ConditionsUtil.setActive(conditions);
                    template.getSpecifications().addAll(conditions);
                    continue;
                }
                if (!(diffElement instanceof ReferenceChange) || (conditions = featureConditionGenerator.generateFeatureCondition(reference = (referenceChange = (ReferenceChange)diffElement).getReference(), template)) == null) continue;
                ConditionsUtil.setActive(conditions);
                template.getSpecifications().addAll(conditions);
            }
        } else {
            this.deriveConditions(template, featureConditionGenerator, false);
        }
        if (recursive) {
            for (Template subTemplate : template.getSubTemplates()) {
                this.deriveRefinementConditions(subTemplate, featureConditionGenerator, recursive);
            }
        }
    }

    private void deriveSubTemplates(Template template, boolean recursive) {
        if (template.getRepresentative() == null) {
            return;
        }
        for (EReference feature : template.getRepresentative().eClass().getEAllContainments()) {
            Object value = template.getRepresentative().eGet(feature);
            if (value == null) continue;
            if (feature.isMany()) {
                EList valueList;
                if (!(value instanceof EList) || (valueList = (EList)value).size() <= 0) continue;
                for (EObject object : valueList) {
                    if (object instanceof EGenericType) continue;
                    Template subTemplate = this.createSubTemplate(object, template, feature);
                    if (!recursive) continue;
                    this.deriveSubTemplates(subTemplate, recursive);
                }
                continue;
            }
            if (value instanceof EGenericType) continue;
            EObject object = (EObject)value;
            Template subTemplate = this.createSubTemplate(object, template, feature);
            if (!recursive) continue;
            this.deriveSubTemplates(subTemplate, recursive);
        }
    }

    private Template createSubTemplate(EObject object, Template parentTemplate, EReference feature) {
        Template subTemplate = null;
        Template baseTemplate = null;
        baseTemplate = this.getTemplateToRefine(object);
        subTemplate = baseTemplate != null ? this.createRefinementTemplate(object, baseTemplate) : this.createTemplate(object);
        parentTemplate.getSubTemplates().add(subTemplate);
        subTemplate.setParentsFeature(feature);
        return subTemplate;
    }

    private Template getTemplateToRefine(EObject object) {
        Template baseTemplate;
        EObject matchingObject;
        if (TemplateGenerationMode.REFINEMENT.equals((Object)this.templateGenerationMode) && this.baseConditionsModel != null && this.refinementDifferences != null && (matchingObject = MatchUtil.getMatchingObject(object, this.refinementDifferences.getMatch())) != null && (baseTemplate = ConditionsUtil.getTemplateByRepresentative(matchingObject, this.baseConditionsModel)) != null) {
            return baseTemplate;
        }
        return null;
    }

    private void clearEmptyConditions(Template rootTemplate) {
        BasicEList<FeatureCondition> conditionsToRemove = new BasicEList<FeatureCondition>();
        TreeIterator<EObject> objectIter = rootTemplate.eAllContents();
        while (objectIter.hasNext()) {
            FeatureCondition featureCondition;
            EObject object = (EObject)objectIter.next();
            if (!(object instanceof FeatureCondition) || (featureCondition = (FeatureCondition)object).getExpression().length() != 0) continue;
            conditionsToRemove.add(featureCondition);
        }
        for (FeatureCondition featureCondition : conditionsToRemove) {
            featureCondition.getTemplate().getSpecifications().remove(featureCondition);
        }
    }

    private Template createTemplate(EObject object) {
        Template template = ConditionsFactory.eINSTANCE.createTemplate();
        template.setActive(true);
        template.setRepresentative(object);
        template.setState(State.GENERATED);
        template.setName(this.createTemplateName(object));
        template.setTitle(this.createTemplateTitle(object));
        return template;
    }

    private RefinementTemplate createRefinementTemplate(EObject object, Template baseTemplate) {
        RefinementTemplate template = ConditionsFactory.eINSTANCE.createRefinementTemplate();
        template.setActive(true);
        template.setRefinedTemplate(baseTemplate);
        template.setRepresentative(object);
        template.setState(State.GENERATED);
        template.setName(baseTemplate.getName());
        template.setTitle(this.createTemplateTitle(object));
        return template;
    }

    private String createTemplateName(EObject object) {
        if (this.templateNameService == null) {
            this.templateNameService = new TemplateNameService();
        }
        String name = this.templateNameService.createName(object);
        if (TemplateGenerationMode.REFINEMENT.equals((Object)this.templateGenerationMode)) {
            name = REFINEMENT_PREFIX + name;
        }
        return name;
    }

    private String createTemplateTitle(EObject object) {
        if (this.templateNameService == null) {
            this.templateNameService = new TemplateNameService();
        }
        return this.templateNameService.createTitle(object);
    }

    private static enum TemplateGenerationMode {
        STANDALONE,
        REFINEMENT;

    }
}

