/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.engines.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.core.conditions.ConditionsFactory;
import org.modelversioning.core.conditions.ConditionsPlugin;
import org.modelversioning.core.conditions.FeatureCondition;
import org.modelversioning.core.conditions.State;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.IFeatureConditionGenerator;

public class GenericFeatureConditionGenerator
implements IFeatureConditionGenerator {
    private static final List<String> OMIT_FEATURE_NAMES = Arrays.asList("iD");
    private static final String UNKNOWN_ERAW_TYPE = "FeatureConditionImpl:ERawType which is not an instance of EEnum, EDataType, or EClass: ";

    @Override
    public List<FeatureCondition> generateFeatureCondition(EStructuralFeature feature, Template template) {
        if (OMIT_FEATURE_NAMES.contains(feature.getName())) {
            return Collections.emptyList();
        }
        return this.deriveFeatureConditions(feature, template);
    }

    private FeatureCondition createEmptyFeatureCondition(EStructuralFeature feature) {
        FeatureCondition condition = ConditionsFactory.eINSTANCE.createFeatureCondition();
        condition.setFeature(feature);
        condition.setState(State.GENERATED);
        condition.setInvolvesTemplate(false);
        return condition;
    }

    @Override
    public String getConditionLanguage() {
        return "OCL";
    }

    @Override
    public List<String> getMetaModelNamespace() {
        return Arrays.asList("*");
    }

    private List<FeatureCondition> deriveFeatureConditions(EStructuralFeature feature, Template template) {
        Object value = template.getRepresentative().eGet(feature);
        ArrayList<FeatureCondition> conditions = new ArrayList<FeatureCondition>();
        if (value == null) {
            FeatureCondition condition = this.createEmptyFeatureCondition(feature);
            condition.setExpression(" = " + value);
            condition.setActive(false);
            conditions.add(condition);
        } else {
            EClassifier rawFeatureType = feature.getEGenericType().getERawType();
            if (feature.getUpperBound() != 1) {
                EList valueList = (EList)value;
                if (valueList.size() == 0) {
                    FeatureCondition condition = this.createEmptyFeatureCondition(feature);
                    condition.setExpression("->isEmpty()");
                    condition.setActive(false);
                    conditions.add(condition);
                } else {
                    for (Object object : valueList) {
                        FeatureCondition condition;
                        if (rawFeatureType instanceof EEnum) {
                            FeatureCondition condition2 = this.createEmptyFeatureCondition(feature);
                            condition2.setExpression("->includes(" + rawFeatureType.getName() + "::" + object + ")");
                            conditions.add(condition2);
                            continue;
                        }
                        if (rawFeatureType instanceof EClass) {
                            String templateName = this.getTemplateName(template, object);
                            if (templateName != null) {
                                condition = this.createEmptyFeatureCondition(feature);
                                condition.setInvolvesTemplate(true);
                                condition.setExpression("->includes(#{" + templateName + "}" + ")");
                                conditions.add(condition);
                                continue;
                            }
                            if (!(value instanceof EDataType)) continue;
                            condition = this.createEmptyFeatureCondition(feature);
                            condition.setExpression("->includes(" + ((EDataType)value).getName() + ")");
                            conditions.add(condition);
                            continue;
                        }
                        if (rawFeatureType instanceof EDataType) {
                            EDataType dataType = (EDataType)rawFeatureType;
                            if (String.class.equals(dataType.getInstanceClass())) {
                                condition = this.createEmptyFeatureCondition(feature);
                                condition.setExpression("->includes('" + object + "'" + ")");
                                conditions.add(condition);
                                continue;
                            }
                            condition = this.createEmptyFeatureCondition(feature);
                            condition.setExpression("->includes(" + object + ")");
                            conditions.add(condition);
                            continue;
                        }
                        ConditionsPlugin.getDefault().getLog().log(new Status(2, "org.modelversioning.core.conditions", UNKNOWN_ERAW_TYPE + feature));
                    }
                }
            } else if (rawFeatureType instanceof EEnum) {
                FeatureCondition condition = this.createEmptyFeatureCondition(feature);
                condition.setExpression(" = " + rawFeatureType.getName() + "::" + value);
                conditions.add(condition);
            } else if (rawFeatureType instanceof EClass) {
                String templateName = this.getTemplateName(template, value);
                if (templateName != null) {
                    FeatureCondition condition = this.createEmptyFeatureCondition(feature);
                    condition.setInvolvesTemplate(true);
                    condition.setExpression(" = #{" + templateName + "}");
                    conditions.add(condition);
                } else if (value instanceof EDataType) {
                    FeatureCondition condition = this.createEmptyFeatureCondition(feature);
                    condition.setExpression(" = " + ((EDataType)value).getName());
                    conditions.add(condition);
                }
            } else if (rawFeatureType instanceof EDataType) {
                EDataType dataType = (EDataType)rawFeatureType;
                if (String.class.equals(dataType.getInstanceClass())) {
                    FeatureCondition condition = this.createEmptyFeatureCondition(feature);
                    condition.setExpression(" = '" + value + "'");
                    condition.setActive(false);
                    conditions.add(condition);
                } else {
                    FeatureCondition condition = this.createEmptyFeatureCondition(feature);
                    condition.setExpression(" = " + value);
                    conditions.add(condition);
                    condition.setActive(false);
                }
            } else {
                ConditionsPlugin.getDefault().getLog().log(new Status(2, "org.modelversioning.core.conditions", UNKNOWN_ERAW_TYPE + feature));
            }
        }
        return conditions;
    }

    private String getTemplateName(Template template, Object object) {
        String templateName = null;
        if (template.getRepresentative().equals(object)) {
            templateName = template.getName();
        }
        if (template.getParentTemplate() != null && template.getParentTemplate().getRepresentative().equals(object)) {
            templateName = template.getParentTemplate().getName();
        }
        for (Template subTemplate : template.getSubTemplates()) {
            if (!subTemplate.getRepresentative().equals(object)) continue;
            templateName = subTemplate.getName();
        }
        Template currentTemplate = template;
        while (currentTemplate.getParentTemplate() != null) {
            currentTemplate = currentTemplate.getParentTemplate();
        }
        TreeIterator<EObject> treeIter = currentTemplate.eAllContents();
        while (treeIter.hasNext()) {
            Template subTemplate;
            EObject content = (EObject)treeIter.next();
            if (!(content instanceof Template) || !(subTemplate = (Template)content).getRepresentative().equals(object)) continue;
            templateName = subTemplate.getName();
        }
        return templateName;
    }
}

