/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.engines.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ParserException;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsFactory;
import org.modelversioning.core.conditions.EvaluationResult;
import org.modelversioning.core.conditions.EvaluationStatus;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.BindingException;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.impl.ConditionsEvaluationEngineImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingsImpl;
import org.modelversioning.core.conditions.util.ConditionsUtil;

public class TemplateBindingCreator {
    private static final String NO_REFERENCE_BINDING = "No reference binding could be found";
    private final ConditionsEvaluationEngineImpl evaluator;
    private EList<EvaluationResult> evaluationResults = null;

    public TemplateBindingCreator(ConditionsEvaluationEngineImpl evaluator) {
        this.evaluator = evaluator;
    }

    public ITemplateBinding createEmptyTemplateBinding() {
        return new TemplateBindingImpl();
    }

    public ITemplateBindings findTemplateBindings(Template template, EObject eObject) throws ParserException, BindingException {
        ITemplateBinding preBinding = this.createEmptyTemplateBinding();
        preBinding.add(template, eObject);
        return this.findTemplateBindings(preBinding);
    }

    public ITemplateBindings findTemplateBindings(ITemplateBinding preBinding) throws ParserException, BindingException {
        return this.findTemplateBindings(preBinding, null);
    }

    public ITemplateBindings findTemplateBindings(ITemplateBinding preBinding, ITemplateBinding candidateBinding) throws ParserException, BindingException {
        ArrayList<ITemplateBinding> foundBindings = new ArrayList<ITemplateBinding>();
        this.evaluationResults = new BasicEList<EvaluationResult>();
        this.findTemplateBindings(preBinding, this.createEmptyTemplateBinding(), null, candidateBinding, foundBindings);
        TemplateBindingsImpl bindings = new TemplateBindingsImpl(this.evaluator.getConditionsModel().getRootTemplate());
        boolean isSatisfied = foundBindings.size() > 0;
        EvaluationResult evaluationResult = this.evaluator.createEvaluationResult(isSatisfied);
        if (!isSatisfied) {
            evaluationResult.getSubResults().addAll(this.evaluationResults);
        }
        bindings.setEvaluationResult(evaluationResult);
        bindings.setPossibleBindings(foundBindings);
        return bindings;
    }

    private List<Template> getTemplates() {
        return this.evaluator.getTemplatesToEvaluate();
    }

    private void findTemplateBindings(ITemplateBinding preBinding, ITemplateBinding currentBinding, Template nextTemplate, ITemplateBinding candidateBinding, Collection<ITemplateBinding> foundBindings) throws ParserException {
        if (nextTemplate == null) {
            nextTemplate = this.evaluator.getConditionsModel().getRootTemplate();
        }
        int index = this.getTemplates().indexOf(nextTemplate);
        Template currentTemplate = this.getTemplates().get(index);
        Collection<EObject> currentCandidates = this.getCurrentCandidates(currentTemplate, preBinding, candidateBinding, currentBinding);
        for (EObject currentCandidate : currentCandidates) {
            currentBinding.remove(currentTemplate);
            currentBinding.add(currentTemplate, currentCandidate);
            try {
                List<ITemplateBinding> referenceBindings = this.findValidReferenceBindings(currentCandidate, currentTemplate, preBinding, candidateBinding, currentBinding);
                if (referenceBindings.size() > 0) {
                    for (ITemplateBinding referenceBinding : referenceBindings) {
                        ITemplateBinding newBinding = currentBinding.clone();
                        newBinding.add(currentTemplate, currentCandidate);
                        newBinding.addAll(referenceBinding);
                        if (index < this.getTemplates().size() - 1) {
                            Template nextTemplateToEvaluate = this.getTemplates().get(index + 1);
                            this.findTemplateBindings(preBinding, newBinding, nextTemplateToEvaluate, candidateBinding, foundBindings);
                            continue;
                        }
                        if (!this.evaluator.isComplete(currentBinding)) continue;
                        foundBindings.add(newBinding);
                    }
                    continue;
                }
                if (index < this.getTemplates().size() - 1) {
                    Template nextTemplateToEvaluate = this.getTemplates().get(index + 1);
                    this.findTemplateBindings(preBinding, currentBinding.clone(), nextTemplateToEvaluate, candidateBinding, foundBindings);
                    continue;
                }
                if (!this.evaluator.isComplete(currentBinding)) continue;
                foundBindings.add(currentBinding.clone());
            }
            catch (BindingException bindingException) {}
        }
    }

    private Collection<EObject> getCurrentCandidates(Template template, ITemplateBinding preBinding, ITemplateBinding candidateBinding, ITemplateBinding currentBinding) {
        ArrayList<EObject> candidateSet = new ArrayList<EObject>();
        if (preBinding.getBoundObjects(template) != null && preBinding.getBoundObjects(template).size() > 0) {
            candidateSet.addAll(preBinding.getBoundObjects(template));
        } else if (currentBinding.getBoundObjects(template) != null && currentBinding.getBoundObjects(template).size() > 0) {
            candidateSet.addAll(currentBinding.getBoundObjects(template));
        } else if (candidateBinding != null && candidateBinding.getBoundObjects(template) != null && candidateBinding.getBoundObjects(template).size() > 0) {
            HashSet<EObject> boundObjects = new HashSet<EObject>(candidateBinding.getBoundObjects(template));
            boundObjects.removeAll(preBinding.getBoundObjects());
            boundObjects.removeAll(currentBinding.getBoundObjects());
            Collection<EObject> locallyValidEObjects = this.getLocallyValidEObjects(boundObjects, template);
            if (locallyValidEObjects.size() > 0) {
                candidateSet.addAll(locallyValidEObjects);
            }
        }
        if (candidateSet.size() < 1) {
            BasicEList<EObject> candidateList;
            ArrayList<List<EObject>> candidateLists = new ArrayList<List<EObject>>();
            HashSet<EObject> handledObjects = new HashSet<EObject>();
            for (Template boundTemplate : preBinding.getTemplates()) {
                candidateList = new BasicEList<EObject>();
                for (EObject eObject : preBinding.getBoundObjects(boundTemplate)) {
                    if (handledObjects.contains(eObject)) continue;
                    candidateList.addAll(this.getCurrentCandidates(template, eObject, boundTemplate, preBinding, candidateBinding, currentBinding));
                    handledObjects.add(eObject);
                }
                if (candidateList.size() <= 0) continue;
                candidateLists.add(candidateList);
            }
            for (Template boundTemplate : currentBinding.getTemplates()) {
                candidateList = new BasicEList();
                for (EObject eObject : currentBinding.getBoundObjects(boundTemplate)) {
                    if (handledObjects.contains(eObject)) continue;
                    candidateList.addAll(this.getCurrentCandidates(template, eObject, boundTemplate, preBinding, candidateBinding, currentBinding));
                    handledObjects.add(eObject);
                }
                if (candidateList.size() <= 0) continue;
                candidateLists.add(candidateList);
            }
            if (candidateBinding != null) {
                for (Template boundTemplate : candidateBinding.getTemplates()) {
                    candidateList = new BasicEList();
                    for (EObject eObject : candidateBinding.getBoundObjects(boundTemplate)) {
                        if (handledObjects.contains(eObject)) continue;
                        candidateList.addAll(this.getCurrentCandidates(template, eObject, boundTemplate, preBinding, candidateBinding, currentBinding));
                        handledObjects.add(eObject);
                    }
                    if (candidateList.size() <= 0) continue;
                    candidateLists.add(candidateList);
                }
            }
            Collection<EObject> foundCandidates = this.getIntersection(candidateLists);
            foundCandidates.removeAll(currentBinding.getBoundObjects());
            candidateSet.addAll(foundCandidates);
        }
        return candidateSet;
    }

    private Collection<EObject> getIntersection(List<List<EObject>> lists) {
        HashSet<EObject> intersection = new HashSet<EObject>();
        List<EObject> smallestList = null;
        for (List<EObject> eObjectList : lists) {
            if (smallestList != null && eObjectList.size() >= smallestList.size()) continue;
            smallestList = eObjectList;
        }
        if (smallestList != null) {
            for (EObject eObject : smallestList) {
                boolean containedByAll = true;
                for (List<EObject> list : lists) {
                    if (list.contains(eObject)) continue;
                    containedByAll = false;
                }
                if (!containedByAll) continue;
                intersection.add(eObject);
            }
        }
        return intersection;
    }

    private List<EObject> getCurrentCandidates(Template forTemplate, EObject baseObject, Template baseTemplate, ITemplateBinding preBinding, ITemplateBinding candidateBinding, ITemplateBinding currentBinding) {
        BasicEList<EObject> candidates = new BasicEList<EObject>();
        Template commonParentTemplate = ConditionsUtil.findLeastCommonParentTemplate(forTemplate, baseTemplate);
        if (commonParentTemplate != null) {
            List<Template> parents = ConditionsUtil.createParentList(forTemplate);
            EObject currentParentObject = baseObject;
            Template currentParentTemplate = baseTemplate;
            boolean commonParentReached = commonParentTemplate.equals(currentParentTemplate);
            while (!commonParentReached && (currentParentTemplate = currentParentTemplate.getParentTemplate()) != null) {
                currentParentObject = currentParentObject.eContainer();
                if (!currentParentTemplate.equals(commonParentTemplate)) continue;
                commonParentReached = true;
            }
            parents.add(0, forTemplate);
            Collection<Object> parentsCandidates = new BasicEList<EObject>();
            parentsCandidates.add(currentParentObject);
            int i = parents.indexOf(commonParentTemplate) - 1;
            while (i >= 0) {
                Template template = parents.get(i);
                if (preBinding.getBoundObjects(template).size() > 0 || currentBinding.getBoundObjects(template).size() > 0 || candidateBinding != null && candidateBinding.getBoundObjects(template).size() > 0) {
                    parentsCandidates = preBinding.getBoundObjects(template).size() > 0 ? preBinding.getBoundObjects(template) : (currentBinding.getBoundObjects(template).size() > 0 ? currentBinding.getBoundObjects(template) : candidateBinding.getBoundObjects(template));
                } else {
                    BasicEList<EObject> tempCandidates = new BasicEList<EObject>();
                    for (EObject eObject : parentsCandidates) {
                        Collection<EObject> values = this.getEObjectValues(eObject, template.getParentsFeature(), true);
                        tempCandidates.addAll(this.getLocallyValidEObjects(values, template));
                    }
                    parentsCandidates = tempCandidates;
                }
                --i;
            }
            candidates.addAll(parentsCandidates);
        }
        Collection<EObject> finalCandidates = this.getLocallyValidEObjects(candidates, forTemplate);
        finalCandidates.removeAll(preBinding.getBoundObjects());
        finalCandidates.removeAll(currentBinding.getBoundObjects());
        if (candidateBinding != null) {
            finalCandidates.removeAll(candidateBinding.getBoundObjects());
        }
        return new BasicEList<EObject>(finalCandidates);
    }

    private Collection<EObject> getLocallyValidEObjects(Collection<EObject> candidates, Template template) {
        BasicEList<EObject> tempCandidates = new BasicEList<EObject>();
        for (EObject eObject : candidates) {
            if (eObject == null || !this.evaluator.evaluate(template, eObject, true).isOK()) continue;
            tempCandidates.add(eObject);
        }
        return tempCandidates;
    }

    private Collection<EObject> getEObjectValues(EObject eObject, EStructuralFeature feature, boolean tryToResolve) {
        BasicEList<EObject> values;
        block8: {
            values = new BasicEList<EObject>();
            try {
                if (feature.getUpperBound() != 1) {
                    EList objectList = (EList)eObject.eGet(feature, true);
                    for (Object object : objectList) {
                        if (!(object instanceof EObject)) continue;
                        values.add((EObject)object);
                    }
                } else {
                    Object object = eObject.eGet(feature, true);
                    if (object instanceof EObject) {
                        values.add((EObject)object);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (tryToResolve) {
                    return this.tryToResolveByFeatureName(eObject, feature);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!tryToResolve) break block8;
                return this.tryToResolveByFeatureName(eObject, feature);
            }
        }
        return values;
    }

    private Collection<EObject> tryToResolveByFeatureName(EObject eObject, EStructuralFeature feature) {
        for (EStructuralFeature feature2 : eObject.eClass().getEStructuralFeatures()) {
            if (!EcoreUtil.equals(feature, feature2)) continue;
            return this.getEObjectValues(eObject, feature2, false);
        }
        return Collections.emptySet();
    }

    private List<ITemplateBinding> findValidReferenceBindings(EObject currentCandidate, Template currentTemplate, ITemplateBinding preBinding, ITemplateBinding candidateBinding, ITemplateBinding currentBinding) throws ParserException, BindingException {
        Set<Condition> conditions;
        ArrayList<ITemplateBinding> validReferenceBindings = new ArrayList<ITemplateBinding>();
        Condition containmentCondition = null;
        if (this.evaluator.isContainmentAware() && currentTemplate.getParentTemplate() != null) {
            containmentCondition = this.evaluator.createContainmentCondition(currentTemplate);
        }
        if ((conditions = this.evaluator.getTemplateInvolvingConditionsToEvaluate(currentTemplate)).size() == 0) {
            return Collections.emptyList();
        }
        Set<Template> referencedTemplates = this.evaluator.extractInvolvedTemplates(conditions);
        Collection<ITemplateBinding> allBindingCombinations = this.calcTemplateObjectPermutation(referencedTemplates, preBinding, candidateBinding, currentBinding);
        for (ITemplateBinding bindingCombination : allBindingCombinations) {
            boolean currentCombinationSatisfied = true;
            for (Condition condition : conditions) {
                if (this.evaluator.isSatisfied(currentCandidate, bindingCombination.getSingleBindingMap(), condition)) continue;
                currentCombinationSatisfied = false;
                EvaluationResult evaluationResult = ConditionsFactory.eINSTANCE.createEvaluationResult();
                evaluationResult.setStatus(EvaluationStatus.UNSATISFIED);
                evaluationResult.setEvaluator("OCL AMOR Condition Evaluator");
                evaluationResult.setMessage("Condition failed.");
                evaluationResult.setFailedCandidate(currentCandidate);
                evaluationResult.setFailedCondition(condition);
                this.evaluationResults.add(evaluationResult);
                break;
            }
            if (!currentCombinationSatisfied) continue;
            validReferenceBindings.add(bindingCombination);
        }
        if (containmentCondition != null) {
            currentTemplate.getSpecifications().remove(containmentCondition);
        }
        if (referencedTemplates.size() > 0 && validReferenceBindings.size() == 0) {
            throw new BindingException(NO_REFERENCE_BINDING, (Template)referencedTemplates.iterator().next());
        }
        return validReferenceBindings;
    }

    protected Collection<ITemplateBinding> calcTemplateObjectPermutation(Collection<Template> templates, ITemplateBinding preBinding, ITemplateBinding candidateBinding, ITemplateBinding currentBinding) {
        ITemplateBinding overallBinding = this.createEmptyTemplateBinding();
        for (Template template : templates) {
            Collection<EObject> referencedCandidates = this.getCurrentCandidates(template, preBinding, candidateBinding, currentBinding);
            overallBinding.add(template, referencedCandidates);
        }
        if (overallBinding.getTemplates().size() < templates.size()) {
            return Collections.emptySet();
        }
        HashSet<ITemplateBinding> permutations = new HashSet<ITemplateBinding>();
        permutations.addAll(this.calcTemplateObjectPermutation(overallBinding, null));
        return permutations;
    }

    private Collection<ITemplateBinding> calcTemplateObjectPermutation(ITemplateBinding overallBinding, ITemplateBinding currentCombination) {
        HashSet<ITemplateBinding> combinations = new HashSet<ITemplateBinding>();
        if (currentCombination == null) {
            currentCombination = this.createEmptyTemplateBinding();
        }
        HashSet<Template> templates = new HashSet<Template>();
        templates.addAll(overallBinding.getTemplates());
        templates.removeAll(currentCombination.getTemplates());
        if (templates.size() > 0) {
            Template template = (Template)templates.iterator().next();
            for (EObject eObject : overallBinding.getBoundObjects(template)) {
                currentCombination.remove(template);
                currentCombination.add(template, eObject);
                combinations.addAll(this.calcTemplateObjectPermutation(overallBinding, currentCombination.clone()));
            }
        } else {
            combinations.add(currentCombination);
        }
        return combinations;
    }
}

