/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.engines.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.ITemplateBinding;

public class TemplateBindingImpl
implements ITemplateBinding {
    private Map<Template, Collection<EObject>> binding = new HashMap<Template, Collection<EObject>>();

    private Collection<EObject> createSet() {
        return new ArrayList<EObject>();
    }

    private void cleanSet(Template template) {
        if (this.binding.get(template) != null && this.binding.get(template).size() == 0) {
            this.binding.remove(template);
        }
    }

    private Collection<EObject> getSet(Template template) {
        if (this.binding.get(template) == null) {
            this.binding.put(template, this.createSet());
        }
        return this.binding.get(template);
    }

    @Override
    public Collection<EObject> getBoundObjects() {
        ArrayList<EObject> returnCollection = new ArrayList<EObject>();
        for (Collection<EObject> col : this.binding.values()) {
            returnCollection.addAll(col);
        }
        return returnCollection;
    }

    @Override
    public Collection<EObject> getBoundObjects(Template template) {
        if (this.binding.containsKey(template)) {
            return Collections.unmodifiableCollection(this.binding.get(template));
        }
        return Collections.emptySet();
    }

    @Override
    public Template getBoundTemplate(EObject eObject) {
        for (Template template : this.binding.keySet()) {
            if (!this.binding.get(template).contains(eObject)) continue;
            return template;
        }
        return null;
    }

    @Override
    public void add(Template template, Collection<EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.add(template, eObject);
        }
    }

    @Override
    public void add(Template template, EObject eObject) {
        if (eObject != null && !this.getSet(template).contains(eObject)) {
            this.getSet(template).add(eObject);
        }
    }

    @Override
    public void remove(Template template) {
        this.binding.remove(template);
    }

    @Override
    public void remove(Template template, EObject eObject) {
        this.getSet(template).remove(eObject);
        this.cleanSet(template);
    }

    @Override
    public void remove(Template template, Collection<EObject> eObjects) {
        this.getSet(template).removeAll(eObjects);
        this.cleanSet(template);
    }

    @Override
    public void clear() {
        this.binding.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.binding.size() < 1;
    }

    @Override
    public int size() {
        return this.binding.size();
    }

    @Override
    public Set<Template> getTemplates() {
        return this.binding.keySet();
    }

    @Override
    public ITemplateBinding clone() {
        TemplateBindingImpl clone = new TemplateBindingImpl();
        for (Template template : this.binding.keySet()) {
            HashSet<EObject> clonedSet = new HashSet<EObject>();
            for (EObject eObject : this.binding.get(template)) {
                clonedSet.add(eObject);
            }
            clone.add(template, clonedSet);
        }
        return clone;
    }

    @Override
    public Map<Template, EObject> getSingleBindingMap() {
        HashMap<Template, EObject> singleBinding = new HashMap<Template, EObject>();
        for (Template template : this.binding.keySet()) {
            if (this.binding.get(template) == null || this.binding.get(template).size() <= 0) continue;
            singleBinding.put(template, this.binding.get(template).iterator().next());
        }
        return Collections.unmodifiableMap(singleBinding);
    }

    @Override
    public void addAll(ITemplateBinding bindingCombination) {
        for (Template template : bindingCombination.getTemplates()) {
            this.add(template, bindingCombination.getBoundObjects(template));
        }
    }
}

