/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.engines.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.EvaluationResult;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;

public class TemplateBindingsImpl
implements ITemplateBindings {
    private Template rootTemplate = null;
    private Set<ITemplateBinding> bindings = new HashSet<ITemplateBinding>();
    private EvaluationResult evaluationResult = null;
    private Map<EObject, Set<ITemplateBinding>> removedBindings = new HashMap<EObject, Set<ITemplateBinding>>();

    public TemplateBindingsImpl(Template rootTemplate) {
        this.rootTemplate = rootTemplate;
    }

    protected void setRootTemplate(Template rootTemplate) {
        this.rootTemplate = rootTemplate;
    }

    protected void setEvaluationResult(EvaluationResult evaluationResult) {
        this.evaluationResult = evaluationResult;
    }

    @Override
    public Set<ITemplateBinding> getAllPossibleBindings() {
        return this.bindings;
    }

    @Override
    public ITemplateBindings extractSubBindings(Template template, EObject boundObject, boolean removeExtracted) {
        HashSet<ITemplateBinding> extractedBindings = new HashSet<ITemplateBinding>();
        for (ITemplateBinding binding : this.bindings) {
            if (!binding.getBoundObjects(template).contains(boundObject)) continue;
            extractedBindings.add(binding);
        }
        TemplateBindingsImpl extractedTemplateBindings = new TemplateBindingsImpl(this.rootTemplate);
        extractedTemplateBindings.setPossibleBindings(extractedBindings);
        extractedTemplateBindings.setEvaluationResult(this.evaluationResult);
        if (removeExtracted) {
            this.bindings.removeAll(extractedBindings);
        }
        return extractedTemplateBindings;
    }

    @Override
    public Set<EObject> getBoundObjects(Template template) {
        HashSet<EObject> boundObjects = new HashSet<EObject>();
        for (ITemplateBinding binding : this.bindings) {
            if (binding.getBoundObjects(template) == null) continue;
            boundObjects.addAll(binding.getBoundObjects(template));
        }
        return boundObjects;
    }

    @Override
    public Set<Template> getBoundTemplates(EObject eObject) {
        HashSet<Template> set = new HashSet<Template>();
        for (ITemplateBinding binding : this.bindings) {
            Template boundTemplate = binding.getBoundTemplate(eObject);
            if (boundTemplate == null) continue;
            set.add(boundTemplate);
        }
        return set;
    }

    @Override
    public Template getRootTemplate() {
        return this.rootTemplate;
    }

    @Override
    public boolean isRemovable(EObject object, Template template) {
        if (this.bindings.size() <= 1) {
            return false;
        }
        boolean isRemovable = false;
        for (ITemplateBinding binding : this.bindings) {
            if (binding.getBoundObjects(template) != null && binding.getBoundObjects(template).contains(object)) continue;
            isRemovable = true;
            break;
        }
        return isRemovable;
    }

    @Override
    public boolean remove(EObject object, Template template) {
        if (!this.isRemovable(object, template)) {
            return false;
        }
        boolean didRemove = false;
        HashSet<ITemplateBinding> bindingsToRemove = new HashSet<ITemplateBinding>();
        for (ITemplateBinding binding : this.bindings) {
            if (binding.getBoundObjects(template) == null || !binding.getBoundObjects(template).contains(object)) continue;
            bindingsToRemove.add(binding);
        }
        for (ITemplateBinding binding : bindingsToRemove) {
            if (this.removedBindings.get(object) == null) {
                this.removedBindings.put(object, new HashSet());
            }
            this.removedBindings.get(object).add(binding);
            this.bindings.remove(binding);
            didRemove = true;
        }
        return didRemove;
    }

    @Override
    public boolean undoRemove(EObject object) {
        boolean didUndo = this.removedBindings.containsKey(object);
        if (didUndo) {
            this.bindings.addAll((Collection<ITemplateBinding>)this.removedBindings.get(object));
            this.removedBindings.remove(object);
        }
        return didUndo;
    }

    @Override
    public EvaluationResult validate() {
        return this.evaluationResult;
    }

    protected void setPossibleBindings(Collection<ITemplateBinding> foundBindings) {
        for (ITemplateBinding iTemplateBinding : foundBindings) {
            this.bindings.add(iTemplateBinding);
        }
    }

    @Override
    public Set<Template> getTemplates() {
        HashSet<Template> set = new HashSet<Template>();
        for (ITemplateBinding binding : this.bindings) {
            set.addAll(binding.getTemplates());
        }
        return set;
    }
}

