/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsPackage;
import org.modelversioning.core.conditions.EvaluationResult;
import org.modelversioning.core.conditions.EvaluationStatus;

public class EvaluationResultImpl
extends EObjectImpl
implements EvaluationResult {
    protected static final String MESSAGE_EDEFAULT = null;
    protected String message = MESSAGE_EDEFAULT;
    protected static final EvaluationStatus STATUS_EDEFAULT = EvaluationStatus.SATISFIED;
    protected EvaluationStatus status = STATUS_EDEFAULT;
    protected static final Throwable EXCEPTION_EDEFAULT = null;
    protected Throwable exception = EXCEPTION_EDEFAULT;
    protected static final String EVALUATOR_EDEFAULT = null;
    protected String evaluator = EVALUATOR_EDEFAULT;
    protected EList<EvaluationResult> subResults;
    protected Condition failedCondition;
    protected EObject failedCandidate;

    protected EvaluationResultImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ConditionsPackage.Literals.EVALUATION_RESULT;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String newMessage) {
        String oldMessage = this.message;
        this.message = newMessage;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldMessage, (Object)this.message));
        }
    }

    @Override
    public EvaluationStatus getStatus() {
        if (!this.isMultiResult()) {
            return this.status;
        }
        boolean isSatisfied = true;
        boolean isError = false;
        for (EvaluationResult subResult : this.getSubResults()) {
            switch (subResult.getStatus()) {
                case UNSATISFIED: {
                    isSatisfied = false;
                    break;
                }
                case ERROR: {
                    isSatisfied = false;
                    isError = true;
                    break;
                }
            }
        }
        if (isError) {
            return EvaluationStatus.ERROR;
        }
        if (!isSatisfied) {
            return EvaluationStatus.UNSATISFIED;
        }
        return EvaluationStatus.SATISFIED;
    }

    @Override
    public void setStatus(EvaluationStatus newStatus) {
        EvaluationStatus oldStatus = this.status;
        EvaluationStatus evaluationStatus = this.status = newStatus == null ? STATUS_EDEFAULT : newStatus;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldStatus, (Object)this.status));
        }
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void setException(Throwable newException) {
        Throwable oldException = this.exception;
        this.exception = newException;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldException, (Object)this.exception));
        }
    }

    @Override
    public String getEvaluator() {
        return this.evaluator;
    }

    @Override
    public void setEvaluator(String newEvaluator) {
        String oldEvaluator = this.evaluator;
        this.evaluator = newEvaluator;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldEvaluator, (Object)this.evaluator));
        }
    }

    @Override
    public EList<EvaluationResult> getSubResults() {
        if (this.subResults == null) {
            this.subResults = new EObjectContainmentWithInverseEList<EvaluationResult>(EvaluationResult.class, this, 4, 5);
        }
        return this.subResults;
    }

    @Override
    public EvaluationResult getParentResult() {
        if (this.eContainerFeatureID() != 5) {
            return null;
        }
        return (EvaluationResult)this.eContainer();
    }

    public NotificationChain basicSetParentResult(EvaluationResult newParentResult, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)((Object)newParentResult), 5, msgs);
        return msgs;
    }

    @Override
    public void setParentResult(EvaluationResult newParentResult) {
        if (newParentResult != this.eInternalContainer() || this.eContainerFeatureID() != 5 && newParentResult != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newParentResult)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newParentResult != null) {
                msgs = ((InternalEObject)((Object)newParentResult)).eInverseAdd(this, 4, EvaluationResult.class, msgs);
            }
            if ((msgs = this.basicSetParentResult(newParentResult, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newParentResult, (Object)newParentResult));
        }
    }

    @Override
    public Condition getFailedCondition() {
        if (this.failedCondition != null && this.failedCondition.eIsProxy()) {
            InternalEObject oldFailedCondition = (InternalEObject)((Object)this.failedCondition);
            this.failedCondition = (Condition)this.eResolveProxy(oldFailedCondition);
            if (this.failedCondition != oldFailedCondition && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldFailedCondition, (Object)this.failedCondition));
            }
        }
        return this.failedCondition;
    }

    public Condition basicGetFailedCondition() {
        return this.failedCondition;
    }

    @Override
    public void setFailedCondition(Condition newFailedCondition) {
        Condition oldFailedCondition = this.failedCondition;
        this.failedCondition = newFailedCondition;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldFailedCondition, (Object)this.failedCondition));
        }
    }

    @Override
    public EObject getFailedCandidate() {
        if (this.failedCandidate != null && this.failedCandidate.eIsProxy()) {
            InternalEObject oldFailedCandidate = (InternalEObject)this.failedCandidate;
            this.failedCandidate = this.eResolveProxy(oldFailedCandidate);
            if (this.failedCandidate != oldFailedCandidate && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldFailedCandidate, (Object)this.failedCandidate));
            }
        }
        return this.failedCandidate;
    }

    public EObject basicGetFailedCandidate() {
        return this.failedCandidate;
    }

    @Override
    public void setFailedCandidate(EObject newFailedCandidate) {
        EObject oldFailedCandidate = this.failedCandidate;
        this.failedCandidate = newFailedCandidate;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldFailedCandidate, (Object)this.failedCandidate));
        }
    }

    @Override
    public boolean isMultiResult() {
        return this.getSubResults().size() > 0;
    }

    @Override
    public boolean isOK() {
        return EvaluationStatus.SATISFIED.equals(this.getStatus());
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getSubResults()).basicAdd(otherEnd, msgs);
            }
            case 5: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParentResult((EvaluationResult)((Object)otherEnd), msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getSubResults()).basicRemove(otherEnd, msgs);
            }
            case 5: {
                return this.basicSetParentResult(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 5: {
                return this.eInternalContainer().eInverseRemove(this, 4, EvaluationResult.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getMessage();
            }
            case 1: {
                return this.getStatus();
            }
            case 2: {
                return this.getException();
            }
            case 3: {
                return this.getEvaluator();
            }
            case 4: {
                return this.getSubResults();
            }
            case 5: {
                return this.getParentResult();
            }
            case 6: {
                if (resolve) {
                    return this.getFailedCondition();
                }
                return this.basicGetFailedCondition();
            }
            case 7: {
                if (resolve) {
                    return this.getFailedCandidate();
                }
                return this.basicGetFailedCandidate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setMessage((String)newValue);
                return;
            }
            case 1: {
                this.setStatus((EvaluationStatus)newValue);
                return;
            }
            case 2: {
                this.setException((Throwable)newValue);
                return;
            }
            case 3: {
                this.setEvaluator((String)newValue);
                return;
            }
            case 4: {
                this.getSubResults().clear();
                this.getSubResults().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setParentResult((EvaluationResult)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setMessage(MESSAGE_EDEFAULT);
                return;
            }
            case 1: {
                this.setStatus(STATUS_EDEFAULT);
                return;
            }
            case 2: {
                this.setException(EXCEPTION_EDEFAULT);
                return;
            }
            case 3: {
                this.setEvaluator(EVALUATOR_EDEFAULT);
                return;
            }
            case 4: {
                this.getSubResults().clear();
                return;
            }
            case 5: {
                this.setParentResult(null);
                return;
            }
            case 6: {
                this.setFailedCondition(null);
                return;
            }
            case 7: {
                this.setFailedCandidate(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return MESSAGE_EDEFAULT == null ? this.message != null : !MESSAGE_EDEFAULT.equals(this.message);
            }
            case 1: {
                return this.status != STATUS_EDEFAULT;
            }
            case 2: {
                return EXCEPTION_EDEFAULT == null ? this.exception != null : !EXCEPTION_EDEFAULT.equals(this.exception);
            }
            case 3: {
                return EVALUATOR_EDEFAULT == null ? this.evaluator != null : !EVALUATOR_EDEFAULT.equals(this.evaluator);
            }
            case 4: {
                return this.subResults != null && !this.subResults.isEmpty();
            }
            case 5: {
                return this.getParentResult() != null;
            }
            case 6: {
                return this.failedCondition != null;
            }
            case 7: {
                return this.failedCandidate != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (message: ");
        result.append(this.message);
        result.append(", status: ");
        result.append(this.status);
        result.append(", exception: ");
        result.append(this.exception);
        result.append(", evaluator: ");
        result.append(this.evaluator);
        result.append(')');
        return result.toString();
    }
}

