/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.templatebindings.util;

import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingsImpl;
import org.modelversioning.core.conditions.templatebindings.TemplateBinding;
import org.modelversioning.core.conditions.templatebindings.TemplateBindingCollection;
import org.modelversioning.core.conditions.templatebindings.TemplatebindingsFactory;
import org.modelversioning.core.conditions.util.ConditionsUtil;

public class TemplateBindingsUtil {
    private static TemplatebindingsFactory tbFactory = TemplatebindingsFactory.eINSTANCE;

    public static ITemplateBindings convert(TemplateBindingCollection tbCollection) {
        TemplateBindingsImpl templateBindings = new TemplateBindingsImpl(TemplateBindingsUtil.getRootTemplate(tbCollection));
        TemplateBindingImpl templateBindingImpl = new TemplateBindingImpl();
        for (TemplateBinding binding : tbCollection.getBindings()) {
            templateBindingImpl.add(binding.getTemplate(), binding.getEObjects());
        }
        templateBindings.getAllPossibleBindings().add(templateBindingImpl);
        return templateBindings;
    }

    public static Template getRootTemplate(TemplateBindingCollection tbCollection) {
        if (tbCollection.getBindings().size() > 0) {
            Template firstTemplate = ((TemplateBinding)tbCollection.getBindings().get(0)).getTemplate();
            return ConditionsUtil.getRootTemplate(firstTemplate);
        }
        return null;
    }

    public static TemplateBindingCollection convert(ITemplateBindings templateBindings) {
        TemplateBindingCollection collection = tbFactory.createTemplateBindingCollection();
        for (Template template : templateBindings.getTemplates()) {
            TemplateBinding templateBinding = tbFactory.createTemplateBinding();
            templateBinding.setTemplateName(template.getName());
            templateBinding.setTemplate(template);
            templateBinding.getEObjects().addAll(templateBindings.getBoundObjects(template));
            collection.getBindings().add(templateBinding);
        }
        return collection;
    }
}

