/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.conditions.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.CustomCondition;
import org.modelversioning.core.conditions.FeatureCondition;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingsImpl;

public class ConditionsUtil {
    public static final Pattern singleTemplateNamePattern = Pattern.compile("(#\\{([a-zA-Z_0-9]*)\\})");
    public static final Pattern singlePrefixedTemplateNamePattern = Pattern.compile("(#\\{([a-zA-Z_0-9]*:[a-zA-Z_0-9]*)\\})");
    public static final Pattern singleUnclosedTemplateNamePattern = Pattern.compile("#\\{?([a-zA-Z_0-9]*:?[a-zA-Z_0-9]*)$");

    public static Set<Condition> getActiveConditions(Template template) {
        HashSet<Condition> conditions = new HashSet<Condition>();
        for (Condition condition : template.getSpecifications()) {
            if (!condition.isActive()) continue;
            conditions.add(condition);
        }
        return conditions;
    }

    public static void setActive(List<FeatureCondition> conditions) {
        for (Condition condition : conditions) {
            condition.setActive(true);
        }
    }

    public static void setInActive(List<FeatureCondition> conditions) {
        for (Condition condition : conditions) {
            condition.setActive(false);
        }
    }

    public static Set<Condition> getActiveTemplateInvolvingConditions(Template template) {
        Set<Condition> activeConditions = ConditionsUtil.getActiveConditions(template);
        HashSet<Condition> activeInvolvingConditions = new HashSet<Condition>();
        for (Condition condition : activeConditions) {
            if (!condition.isInvolvesTemplate()) continue;
            activeInvolvingConditions.add(condition);
        }
        return activeInvolvingConditions;
    }

    public static List<Template> createParentList(Template template) {
        ArrayList<Template> parentsList = new ArrayList<Template>();
        Template parentTemplate = template;
        while ((parentTemplate = parentTemplate.getParentTemplate()) != null) {
            parentsList.add(parentTemplate);
        }
        return parentsList;
    }

    public static Template getRootTemplate(Template template) {
        Template rootTemplate = template;
        while (rootTemplate.getParentTemplate() != null) {
            rootTemplate = rootTemplate.getParentTemplate();
        }
        return rootTemplate;
    }

    public static ConditionsModel getContainingConditionsModel(Template template) {
        Template rootTemplate = ConditionsUtil.getRootTemplate(template);
        if (rootTemplate.eContainer() instanceof ConditionsModel) {
            return (ConditionsModel)rootTemplate.eContainer();
        }
        return null;
    }

    public static Template findLeastCommonParentTemplate(Template template1, Template template2) {
        List<Template> parents1 = ConditionsUtil.createParentList(template1);
        List<Template> parents2 = ConditionsUtil.createParentList(template2);
        if (template1.getParentTemplate() == null && template2.getParentTemplate() == null && template1.equals(template2)) {
            return template1;
        }
        if (template1.getParentTemplate() == null || parents2.contains(template1)) {
            return template1;
        }
        if (template2.getParentTemplate() == null || parents1.contains(template2)) {
            return template2;
        }
        for (Template currentParent : parents1) {
            if (!parents2.contains(currentParent)) continue;
            return currentParent;
        }
        return null;
    }

    public static EList<Template> getAllTemplates(ConditionsModel conditionsModel) {
        BasicEList<Template> list = new BasicEList<Template>();
        list.add(conditionsModel.getRootTemplate());
        list.addAll(ConditionsUtil.getAllTemplates(conditionsModel.getRootTemplate()));
        return list;
    }

    public static Collection<? extends Template> getAllTemplates(Template template) {
        BasicEList<? extends Template> list = new BasicEList<Template>();
        if (!template.getSubTemplates().isEmpty()) {
            for (Template next : template.getSubTemplates()) {
                list.add(next);
                list.addAll(ConditionsUtil.getAllTemplates(next));
            }
        }
        return list;
    }

    public static boolean isOptional(Template template, boolean includeImplicit) {
        if (!template.isMandatory()) {
            return true;
        }
        if (includeImplicit) {
            Template parentTemplate = template;
            while ((parentTemplate = parentTemplate.getParentTemplate()) != null) {
                if (parentTemplate.isMandatory()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNonExistence(Template template, boolean includeImplicit) {
        if (!template.isExistence()) {
            return true;
        }
        if (includeImplicit) {
            Template parentTemplate = template;
            while ((parentTemplate = parentTemplate.getParentTemplate()) != null) {
                if (parentTemplate.isExistence()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInActive(Template template, boolean includeImplicit) {
        if (!template.isActive()) {
            return true;
        }
        if (includeImplicit) {
            Template parentTemplate = template;
            while ((parentTemplate = parentTemplate.getParentTemplate()) != null) {
                if (parentTemplate.isActive()) continue;
                return true;
            }
        }
        return false;
    }

    public static String getExpression(Condition condition) {
        if (condition instanceof FeatureCondition) {
            return ((FeatureCondition)condition).getExpression();
        }
        if (condition instanceof CustomCondition) {
            return ((CustomCondition)condition).getExpression();
        }
        return null;
    }

    public static void setExpression(Condition condition, String expression) {
        if (condition instanceof FeatureCondition) {
            ((FeatureCondition)condition).setExpression(expression);
        } else if (condition instanceof CustomCondition) {
            ((CustomCondition)condition).setExpression(expression);
        }
    }

    public static boolean isEqual(Condition condition1, Condition condition2) {
        if (!condition1.eClass().equals(condition2.eClass())) {
            return false;
        }
        if (!ConditionsUtil.getExpression(condition1).equals(ConditionsUtil.getExpression(condition2))) {
            return false;
        }
        if (condition1 instanceof FeatureCondition && condition2 instanceof FeatureCondition) {
            FeatureCondition featureCondition1 = (FeatureCondition)condition1;
            FeatureCondition featureCondition2 = (FeatureCondition)condition2;
            if (!featureCondition1.getFeature().equals(featureCondition2.getFeature())) {
                return false;
            }
        }
        return true;
    }

    public static boolean containsEqualCondition(Template template, Condition condition) {
        for (Condition toCompareTo : template.getSpecifications()) {
            if (!ConditionsUtil.isEqual(toCompareTo, condition)) continue;
            return true;
        }
        return false;
    }

    public static Template getTemplateByRepresentative(EObject element, ConditionsModel conditionsModel) {
        if (element == null) {
            return null;
        }
        for (Template template : ConditionsUtil.getAllTemplates(conditionsModel)) {
            if (!template.getRepresentative().equals(element)) continue;
            return template;
        }
        return null;
    }

    public static Map<EObject, Template> getRepresentativeToTemplateMap(ConditionsModel conditionsModel) {
        HashMap<EObject, Template> map = new HashMap<EObject, Template>();
        for (Template template : ConditionsUtil.getAllTemplates(conditionsModel)) {
            map.put(template.getRepresentative(), template);
        }
        return map;
    }

    public static Map<Template, EObject> getTemplateToRepresentativeMap(ConditionsModel conditionsModel) {
        HashMap<Template, EObject> map = new HashMap<Template, EObject>();
        for (Template template : ConditionsUtil.getAllTemplates(conditionsModel)) {
            map.put(template, template.getRepresentative());
        }
        return map;
    }

    public static Set<Template> getUnboundTemplates(ITemplateBinding templateBinding, ConditionsModel conditionsModel) {
        HashSet<Template> missingTemplates = new HashSet<Template>();
        Set<Template> boundTemplates = templateBinding.getTemplates();
        for (Template template : ConditionsUtil.getAllTemplates(conditionsModel)) {
            if (boundTemplates.contains(template)) continue;
            missingTemplates.add(template);
        }
        return missingTemplates;
    }

    private static void addActiveConditionsToList(List<Object> list, EObject element) {
        if (element instanceof Template) {
            Template template = (Template)element;
            if (template.isActive()) {
                list.add(template);
            }
            for (Condition c : template.getSpecifications()) {
                if (!c.isActive()) continue;
                list.add(c);
            }
            for (Template subTemplate : template.getSubTemplates()) {
                ConditionsUtil.addActiveConditionsToList(list, subTemplate);
            }
        }
    }

    public static Object[] getActiveConditionArray(ConditionsModel cm) {
        ArrayList<Object> list = new ArrayList<Object>();
        ConditionsUtil.addActiveConditionsToList(list, cm.getRootTemplate());
        return list.toArray();
    }

    public static Template getTemplateByName(String templateName, ConditionsModel conditionsModel) {
        for (Template template : ConditionsUtil.getAllTemplates(conditionsModel)) {
            if (!templateName.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    public static Set<String> getReferencedFeatureNames(String prefix, Template template, String expression) {
        String regex = "(#\\{(" + prefix + ":" + template.getName() + ")\\}.[a-zA-Z0-9]*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(expression);
        HashSet<String> set = new HashSet<String>();
        while (matcher.find()) {
            String match = matcher.group();
            String featureName = match.substring(match.indexOf(".") + 1);
            if (featureName == null || featureName.length() <= 0) continue;
            set.add(featureName);
        }
        return set;
    }

    public static Set<String> getReferencedFeatureNames(String templateName, String expression) {
        String regex = "(#\\{(" + templateName + ")\\}.[a-zA-Z0-9]*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(expression);
        HashSet<String> set = new HashSet<String>();
        while (matcher.find()) {
            String match = matcher.group();
            String featureName = match.substring(match.indexOf(".") + 1);
            if (featureName == null || featureName.length() <= 0) continue;
            set.add(featureName);
        }
        return set;
    }

    public static Set<String> getReferencedFeatureNames(Template template, String expression) {
        return ConditionsUtil.getReferencedFeatureNames(template.getName(), expression);
    }

    public static Map<String, Set<String>> getReferencedTemplateNames(String expression) {
        Map<String, Set<String>> map = ConditionsUtil.getReferencedPrefixedTemplateNames(expression);
        Set<String> unprefixedTemplateNames = ConditionsUtil.getReferencedUnprefixedTemplateNames(expression);
        if (unprefixedTemplateNames.size() > 0) {
            map.put("", unprefixedTemplateNames);
        }
        return map;
    }

    public static Map<String, Set<String>> getReferencedPrefixedTemplateNames(String expression) {
        HashMap<String, Set<String>> extractedTemplateNames = new HashMap<String, Set<String>>();
        Matcher templateMatcher = singlePrefixedTemplateNamePattern.matcher(expression);
        while (templateMatcher.find()) {
            String match = templateMatcher.group();
            String prefix = match.substring(2, match.indexOf(":"));
            String templateName = match.substring(match.indexOf(":") + 1, match.length() - 1);
            if (templateName == null || templateName.length() <= 0) continue;
            if (extractedTemplateNames.get(prefix) == null) {
                extractedTemplateNames.put(prefix, new HashSet());
            }
            ((Set)extractedTemplateNames.get(prefix)).add(templateName);
        }
        return extractedTemplateNames;
    }

    public static Set<String> getReferencedUnprefixedTemplateNames(String expression) {
        HashSet<String> extractedTemplateNames = new HashSet<String>();
        Matcher templateMatcher = singleTemplateNamePattern.matcher(expression);
        while (templateMatcher.find()) {
            String match = templateMatcher.group();
            String templateName = match.substring(2, match.length() - 1);
            if (templateName == null || templateName.length() <= 0) continue;
            extractedTemplateNames.add(templateName);
        }
        return extractedTemplateNames;
    }

    public static String getUnclosedTemplateNames(String expression) {
        Matcher templateMatcher = singleUnclosedTemplateNamePattern.matcher(expression);
        if (templateMatcher.find()) {
            String match = templateMatcher.group();
            return match;
        }
        return null;
    }

    public static String getUnmaskedConditionExpression(Condition condition) {
        String expression = ConditionsUtil.getExpression(condition);
        String maskStart = "#{".replace("#", "\\#");
        maskStart = maskStart.replace("{", "\\{");
        String maskEnd = "}";
        expression = expression.replaceAll(maskStart, "");
        expression = expression.replace(maskEnd, "");
        return expression;
    }

    public static ITemplateBinding createTemplateBinding(Map<Template, EObject> map) {
        TemplateBindingImpl binding = new TemplateBindingImpl();
        for (Map.Entry<Template, EObject> entry : map.entrySet()) {
            binding.add(entry.getKey(), entry.getValue());
        }
        return binding;
    }

    public static ITemplateBindings createTemplateBindings(Map<Template, EObject> map) {
        ITemplateBinding binding = ConditionsUtil.createTemplateBinding(map);
        TemplateBindingsImpl bindings = new TemplateBindingsImpl(ConditionsUtil.getRootTemplate(binding.getTemplates().iterator().next()));
        bindings.getAllPossibleBindings().add(binding);
        return bindings;
    }

    public static ITemplateBinding mergeTemplateBindings(ITemplateBindings bindings) {
        TemplateBindingImpl binding = new TemplateBindingImpl();
        for (Template template : bindings.getTemplates()) {
            binding.add(template, bindings.getBoundObjects(template));
        }
        return binding;
    }

    public static void debugPring(ConditionsModel conditionsModel, PrintStream out) {
        out.println("====");
        EList<Template> templates = ConditionsUtil.getAllTemplates(conditionsModel);
        for (Template template : templates) {
            out.println(String.valueOf(template.getTitle()) + ": ");
            for (Condition condition : template.getSpecifications()) {
                if (condition instanceof FeatureCondition) {
                    System.out.println("      " + ((FeatureCondition)condition).getFeature().getName() + " " + ConditionsUtil.getExpression(condition));
                    continue;
                }
                System.out.println(ConditionsUtil.getExpression(condition));
            }
        }
        out.println("====");
    }

    public static void debugPring(ITemplateBinding binding, PrintStream out) {
        out.println("====");
        for (Template template : binding.getTemplates()) {
            out.println(String.valueOf(template.getTitle()) + ": ");
            if (binding.getBoundObjects(template) != null) {
                for (EObject boundObject : binding.getBoundObjects(template)) {
                    out.println("   " + boundObject);
                }
                continue;
            }
            out.println("   null");
        }
        out.println("====");
    }

    public static void debugPring(ITemplateBindings binding, PrintStream out) {
        out.println("====");
        for (Template template : binding.getTemplates()) {
            out.println(String.valueOf(template.getTitle()) + ": ");
            if (binding.getBoundObjects(template) != null) {
                for (EObject boundObject : binding.getBoundObjects(template)) {
                    out.println("   " + boundObject);
                }
                continue;
            }
            out.println("   null");
        }
        out.println("====");
    }
}

