/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.diff;

import java.util.Comparator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DiffElementTypeComparator
implements Comparator<DiffElement> {
    private static DiffElementTypeComparator INSTANCE = new DiffElementTypeComparator();
    private static final String SEPARATOR = ",";
    private final DiffPackage diffPackage = DiffFactory.eINSTANCE.getDiffPackage();
    private EList<EStructuralFeature> structuralFeatures = new BasicEList<EStructuralFeature>();

    private DiffElementTypeComparator() {
        this.initStructuralFeatureList();
    }

    public static DiffElementTypeComparator getInstance() {
        return INSTANCE;
    }

    private void initStructuralFeatureList() {
        this.structuralFeatures.add(this.diffPackage.getAttributeChange_Attribute());
        this.structuralFeatures.add(this.diffPackage.getReferenceChange_Reference());
        this.structuralFeatures.add(this.diffPackage.getAttributeChange_LeftElement());
        this.structuralFeatures.add(this.diffPackage.getModelElementChangeLeftTarget_LeftElement());
        this.structuralFeatures.add(this.diffPackage.getReferenceChange_LeftElement());
        this.structuralFeatures.add(this.diffPackage.getUpdateModelElement_LeftElement());
        this.structuralFeatures.add(this.diffPackage.getAttributeChangeLeftTarget_LeftTarget());
        this.structuralFeatures.add(this.diffPackage.getMoveModelElement_LeftTarget());
        this.structuralFeatures.add(this.diffPackage.getReferenceChangeLeftTarget_LeftTarget());
        this.structuralFeatures.add(this.diffPackage.getReferenceChangeRightTarget_LeftTarget());
        this.structuralFeatures.add(this.diffPackage.getReferenceOrderChange_LeftTarget());
        this.structuralFeatures.add(this.diffPackage.getUpdateReference_LeftTarget());
        this.structuralFeatures.add(this.diffPackage.getAttributeChange_RightElement());
        this.structuralFeatures.add(this.diffPackage.getModelElementChangeRightTarget_RightElement());
        this.structuralFeatures.add(this.diffPackage.getReferenceChange_RightElement());
        this.structuralFeatures.add(this.diffPackage.getUpdateModelElement_RightElement());
        this.structuralFeatures.add(this.diffPackage.getAttributeChangeRightTarget_RightTarget());
        this.structuralFeatures.add(this.diffPackage.getMoveModelElement_RightTarget());
        this.structuralFeatures.add(this.diffPackage.getReferenceChangeLeftTarget_RightTarget());
        this.structuralFeatures.add(this.diffPackage.getReferenceChangeRightTarget_RightTarget());
        this.structuralFeatures.add(this.diffPackage.getReferenceOrderChange_RightTarget());
        this.structuralFeatures.add(this.diffPackage.getUpdateReference_RightTarget());
    }

    @Override
    public int compare(DiffElement o1, DiffElement o2) {
        return this.getComparisonString(o1).compareTo(this.getComparisonString(o2));
    }

    public String getComparisonString(DiffElement diffElement) {
        return String.valueOf(diffElement.eClass().getName()) + this.getParameterComparisonString(diffElement);
    }

    private String getParameterComparisonString(DiffElement diffElement) {
        String parameterString = "";
        for (EStructuralFeature feature : this.structuralFeatures) {
            try {
                EObject references = (EObject)diffElement.eGet(feature, true);
                if (references == null) continue;
                if ((this.diffPackage.getAttributeChange_Attribute().equals(feature) || this.diffPackage.getReferenceChange_Reference().equals(feature)) && references instanceof EStructuralFeature && (diffElement instanceof AttributeChange || diffElement instanceof ReferenceChange)) {
                    parameterString = String.valueOf(parameterString) + SEPARATOR + ((EStructuralFeature)references).getName();
                    continue;
                }
                parameterString = String.valueOf(parameterString) + SEPARATOR + references.eClass().getName();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
        return parameterString;
    }
}

