/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.diff;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.modelversioning.core.diff.DiffElementTypeComparator;

public class DiffSignature {
    private DiffElementTypeComparator diffElementTypeComparator = DiffElementTypeComparator.getInstance();
    private List<DiffElement> signatureElements = new ArrayList<DiffElement>();

    public DiffSignature(DiffModel diffModel) {
        this.add(diffModel);
    }

    public List<DiffElement> getSignatureElements() {
        return this.signatureElements;
    }

    public void add(DiffModel diffModel) {
        for (DiffElement diffElement : diffModel.getOwnedElements()) {
            this.add(diffElement);
        }
        Collections.sort(this.signatureElements, this.diffElementTypeComparator);
    }

    public void add(DiffElement diffElement) {
        if (diffElement.getSubDiffElements().size() > 0) {
            for (DiffElement subDiffElement : diffElement.getSubDiffElements()) {
                this.add(subDiffElement);
            }
        } else if (!(diffElement instanceof DiffGroup) && !(diffElement instanceof ReferenceOrderChange)) {
            this.signatureElements.add(diffElement);
        }
    }

    public void remove(DiffElement diffElement) {
        this.signatureElements.remove(diffElement);
    }

    public void debugPring(PrintStream out) {
        for (DiffElement diffElement : this.signatureElements) {
            out.println(diffElement.toString());
        }
    }
}

