/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.diff.propagation.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.merge.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.merge.IMergeListener;
import org.eclipse.emf.compare.diff.merge.MergeEvent;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.modelversioning.core.diff.DiffPlugin;
import org.modelversioning.core.diff.copydiff.CopyElementLeftTarget;
import org.modelversioning.core.diff.copydiff.CopyElementRightTarget;
import org.modelversioning.core.diff.propagation.IDiffPropagationEngine;
import org.modelversioning.core.diff.propagation.IPropagationMappingProvider;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.core.match.util.MatchUtil;
import org.modelversioning.core.util.UUIDUtil;

public class DiffPropagationEngine
implements IDiffPropagationEngine,
IMergeListener {
    private static final String CANNOT_EXECUTE_CONFLICTING_DIFF = "Cannot execute conflicting diff";
    private MatchModel matchModel;
    private DiffModel executionDiff;
    private IPropagationMappingProvider mappingProvider;
    private EMFCompareEObjectCopier copier;
    private Set<DiffElement> diffElementsToAdd = new HashSet<DiffElement>();
    private Set<DiffElement> deactivatedDiffElements = new HashSet<DiffElement>();
    private Map<EObject, EList<EObject>> addedEObjects = new HashMap<EObject, EList<EObject>>();
    private boolean addContainerOnly = false;
    private Set<EObject> containmentsToOmit = new HashSet<EObject>();

    public boolean isAddContainerOnly() {
        return this.addContainerOnly;
    }

    @Override
    public void setAddContainerOnly(boolean addContainerOnly) {
        this.addContainerOnly = addContainerOnly;
    }

    @Override
    public void propagate(DiffModel diffModel, MatchModel matchModel, IPropagationMappingProvider mappingProvider, IProgressMonitor monitor) {
        this.propagate(DiffUtil.getEffectiveDiffElements(diffModel), matchModel, mappingProvider, monitor);
    }

    @Override
    public void propagate(Collection<DiffElement> diffElements, MatchModel matchModel, IPropagationMappingProvider mappingProvider, IProgressMonitor monitor) {
        this.addedEObjects.clear();
        this.containmentsToOmit.clear();
        this.matchModel = matchModel;
        this.mappingProvider = mappingProvider;
        MergeService.addMergeListener(this);
        Collection<DiffElement> addElements = this.getAddElements(DiffUtil.shallowCopy(diffElements));
        Collection<DiffElement> changeDeleteElements = this.getChangeDeleteElements(DiffUtil.shallowCopy(diffElements));
        this.executionDiff = DiffFactory.eINSTANCE.createDiffModel();
        DiffGroup diffGroupAdds = DiffFactory.eINSTANCE.createDiffGroup();
        this.executionDiff.getOwnedElements().add(diffGroupAdds);
        diffGroupAdds.getSubDiffElements().addAll(addElements);
        this.deactivatedDiffElements.clear();
        if (this.executionDiff.getOwnedElements().size() > 0) {
            this.rewireDiffElements(this.executionDiff.getOwnedElements());
            this.addDiffElementsToDiffGroup(diffGroupAdds);
            ((DiffElement)this.executionDiff.getOwnedElements().get(0)).getSubDiffElements().removeAll(this.deactivatedDiffElements);
            this.execute(this.executionDiff.getOwnedElements());
            for (EObject addedObject : this.addedEObjects.keySet()) {
                this.rewireAddedObject(addedObject);
            }
        }
        this.executionDiff.getOwnedElements().clear();
        this.diffElementsToAdd.clear();
        DiffGroup diffGroupChanges = DiffFactory.eINSTANCE.createDiffGroup();
        diffGroupChanges.getSubDiffElements().addAll(changeDeleteElements);
        this.executionDiff.getOwnedElements().add(diffGroupChanges);
        this.deactivatedDiffElements.clear();
        this.rewireDiffElements(this.executionDiff.getOwnedElements());
        this.addDiffElementsToDiffGroup(diffGroupChanges);
        ((DiffElement)this.executionDiff.getOwnedElements().get(0)).getSubDiffElements().removeAll(this.deactivatedDiffElements);
        this.execute(this.executionDiff.getOwnedElements());
        MergeService.removeMergeListener(this);
    }

    @Override
    public EMFCompareEObjectCopier getCopier() {
        return this.copier;
    }

    @Override
    public EList<EObject> getCopies(EObject original) {
        if (this.addedEObjects.get(original) != null && this.addedEObjects.get(original).size() > 0) {
            return ECollections.unmodifiableEList(this.addedEObjects.get(original));
        }
        return ECollections.emptyEList();
    }

    @Override
    public EObject getOriginalEObjectFromCopy(EObject copy) {
        for (EObject currentKey : this.addedEObjects.keySet()) {
            if (currentKey == null || this.addedEObjects.get(currentKey) == null || !this.addedEObjects.get(currentKey).contains(copy)) continue;
            return currentKey;
        }
        return null;
    }

    private void execute(EList<DiffElement> diffElements) {
        int size = diffElements.size();
        int i = 0;
        while (i < size) {
            MergeService.merge((DiffElement)diffElements.get(i), true);
            ++i;
        }
    }

    private Collection<DiffElement> getAddElements(EList<DiffElement> diffElements) {
        HashSet<DiffElement> addElements = new HashSet<DiffElement>();
        for (DiffElement diffElement : diffElements) {
            if (diffElement instanceof DiffGroup) {
                DiffGroup diffGroup = (DiffGroup)diffElement;
                addElements.addAll(this.getAddElements(diffGroup.getSubDiffElements()));
                continue;
            }
            if (!(diffElement instanceof ModelElementChangeLeftTarget)) continue;
            addElements.add(diffElement);
        }
        return addElements;
    }

    private Collection<DiffElement> getChangeDeleteElements(EList<DiffElement> diffElements) {
        BasicEList<DiffElement> changeDeleteElements = new BasicEList<DiffElement>();
        for (DiffElement diffElement : diffElements) {
            if (diffElement instanceof DiffGroup) {
                DiffGroup diffGroup = (DiffGroup)diffElement;
                changeDeleteElements.addAll(this.getChangeDeleteElements(diffGroup.getSubDiffElements()));
                continue;
            }
            if (diffElement instanceof ModelElementChangeLeftTarget) continue;
            changeDeleteElements.add(diffElement);
        }
        return changeDeleteElements;
    }

    private void addDiffElementsToDiffGroup(DiffGroup diffGroup) {
        for (DiffElement diffElement : this.diffElementsToAdd) {
            diffGroup.getSubDiffElements().add(diffElement);
        }
        ECollections.sort(diffGroup.getSubDiffElements(), new Comparator<DiffElement>(){

            @Override
            public int compare(DiffElement o1, DiffElement o2) {
                if (o1 instanceof ModelElementChangeRightTarget && !(o2 instanceof ModelElementChangeRightTarget)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void addDiffElementsToAdd(DiffElement diffElement) {
        this.diffElementsToAdd.add(diffElement);
    }

    private void checkForDeactivation(DiffElement diffElement, Collection<EObject> counterpartObjects) {
        if (counterpartObjects == null || counterpartObjects.size() < 1) {
            this.deactivatedDiffElements.add(diffElement);
        }
    }

    private void checkForDeactivationRightTarget(DiffElement diffElement) {
        if (DiffUtil.getRightTarget(diffElement) == null) {
            this.deactivatedDiffElements.add(diffElement);
        }
    }

    private void checkForDeactivationLeftTarget(DiffElement diffElement) {
        if (DiffUtil.getLeftTarget(diffElement) == null) {
            this.deactivatedDiffElements.add(diffElement);
        }
    }

    private void rewireDiffElements(EList<DiffElement> diffElements) {
        for (DiffElement diffElement : diffElements) {
            this.rewireDiffElement(diffElement);
        }
    }

    private void rewireDiffElement(DiffElement diffElement) {
        if (diffElement instanceof AttributeChangeLeftTarget) {
            this.rewireAttributeChangeLeftTarget((AttributeChangeLeftTarget)diffElement);
        } else if (diffElement instanceof AttributeChangeRightTarget) {
            this.rewireAttributeChangeRightTarget((AttributeChangeRightTarget)diffElement);
        } else if (diffElement instanceof UpdateAttribute) {
            this.rewireUpdateAttribute((UpdateAttribute)diffElement);
        } else if (diffElement instanceof ConflictingDiffElement) {
            this.rewireConflictingDiffElement((ConflictingDiffElement)diffElement);
        } else if (diffElement instanceof CopyElementLeftTarget) {
            this.rewireCopyElementLeftTarget((CopyElementLeftTarget)diffElement);
        } else if (diffElement instanceof CopyElementRightTarget) {
            this.rewireCopyElementRightTarget((CopyElementRightTarget)diffElement);
        } else if (diffElement instanceof ModelElementChangeLeftTarget) {
            this.rewireModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement);
        } else if (diffElement instanceof ModelElementChangeRightTarget) {
            this.rewireModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement);
        } else if (diffElement instanceof MoveModelElement) {
            this.rewireMoveModelElement((MoveModelElement)diffElement);
        } else if (diffElement instanceof ReferenceChangeLeftTarget) {
            this.rewireReferenceChangeLeftTarget((ReferenceChangeLeftTarget)diffElement);
        } else if (diffElement instanceof ReferenceChangeRightTarget) {
            this.rewireReferenceChangeRightTarget((ReferenceChangeRightTarget)diffElement);
        } else if (diffElement instanceof UpdateReference) {
            this.rewireUpdateReference((UpdateReference)diffElement);
        }
        for (DiffElement subDiffElements : diffElement.getSubDiffElements()) {
            this.rewireDiffElement(subDiffElements);
        }
    }

    private void rewireAttributeChangeLeftTarget(AttributeChangeLeftTarget diffElement) {
        if (!this.mappingProvider.isInOriginModel(diffElement.getRightElement())) {
            EObject leftElement = diffElement.getLeftElement();
            EObject rightElement = diffElement.getRightElement();
            diffElement.setRightElement(leftElement);
            diffElement.setLeftElement(rightElement);
        }
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightElement());
        this.checkForDeactivation(diffElement, counterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            if (isFirst) {
                isFirst = false;
                diffElement.setRightElement(eObject);
                continue;
            }
            AttributeChangeLeftTarget newDiffElement = EcoreUtil.copy(diffElement);
            this.addDiffElementsToAdd(newDiffElement);
            newDiffElement.setRightElement(eObject);
        }
    }

    private void rewireAttributeChangeRightTarget(AttributeChangeRightTarget diffElement) {
        if (!this.mappingProvider.isInOriginModel(diffElement.getRightElement())) {
            EObject leftElement = diffElement.getLeftElement();
            EObject rightElement = diffElement.getRightElement();
            diffElement.setRightElement(leftElement);
            diffElement.setLeftElement(rightElement);
        }
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightElement());
        this.checkForDeactivation(diffElement, counterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            if (isFirst) {
                isFirst = false;
                diffElement.setRightElement(eObject);
                continue;
            }
            AttributeChangeRightTarget newDiffElement = EcoreUtil.copy(diffElement);
            this.addDiffElementsToAdd(newDiffElement);
            newDiffElement.setRightElement(eObject);
        }
    }

    private void rewireUpdateAttribute(UpdateAttribute diffElement) {
        if (!this.mappingProvider.isInOriginModel(diffElement.getRightElement())) {
            EObject leftElement = diffElement.getLeftElement();
            EObject rightElement = diffElement.getRightElement();
            diffElement.setRightElement(leftElement);
            diffElement.setLeftElement(rightElement);
        }
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightElement());
        this.checkForDeactivation(diffElement, counterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            if (isFirst) {
                isFirst = false;
                diffElement.setRightElement(eObject);
                continue;
            }
            UpdateAttribute newDiffElement = EcoreUtil.copy(diffElement);
            this.addDiffElementsToAdd(newDiffElement);
            newDiffElement.setRightElement(eObject);
        }
    }

    private void rewireConflictingDiffElement(ConflictingDiffElement diffElement) {
        DiffPlugin.getDefault().getLog().log(new Status(2, "org.modelversioning.core.diff", CANNOT_EXECUTE_CONFLICTING_DIFF));
    }

    private void rewireCopyElementRightTarget(CopyElementRightTarget diffElement) {
        this.rewireModelElementChangeRightTarget(diffElement);
    }

    private void rewireCopyElementLeftTarget(CopyElementLeftTarget diffElement) {
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightParent());
        this.checkForDeactivation(diffElement, counterpartObjects);
        Collection<EObject> copyCounterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getCopiedRightElement());
        this.checkForDeactivation(diffElement, copyCounterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            for (EObject target : copyCounterpartObjects) {
                if (isFirst) {
                    isFirst = false;
                    diffElement.setRightParent(eObject);
                    diffElement.setLeftElement(target);
                    continue;
                }
                ModelElementChangeLeftTarget newDiffElement = EcoreUtil.copy(diffElement);
                this.addDiffElementsToAdd(newDiffElement);
                newDiffElement.setRightParent(eObject);
                newDiffElement.setLeftElement(target);
            }
        }
    }

    private void rewireModelElementChangeLeftTarget(ModelElementChangeLeftTarget diffElement) {
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightParent());
        this.checkForDeactivation(diffElement, counterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            if (isFirst) {
                isFirst = false;
                diffElement.setRightParent(eObject);
                continue;
            }
            ModelElementChangeLeftTarget newDiffElement = EcoreUtil.copy(diffElement);
            newDiffElement.setRightParent(eObject);
            this.addDiffElementsToAdd(newDiffElement);
        }
    }

    private void rewireModelElementChangeRightTarget(ModelElementChangeRightTarget diffElement) {
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightElement());
        this.checkForDeactivation(diffElement, counterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            if (isFirst) {
                isFirst = false;
                diffElement.setRightElement(eObject);
                continue;
            }
            ModelElementChangeRightTarget newDiffElement = EcoreUtil.copy(diffElement);
            newDiffElement.setRightElement(eObject);
            this.addDiffElementsToAdd(newDiffElement);
        }
    }

    private void rewireMoveModelElement(MoveModelElement diffElement) {
        if (!this.mappingProvider.isInOriginModel(diffElement.getRightElement())) {
            EObject leftElement = diffElement.getLeftElement();
            EObject rightElement = diffElement.getRightElement();
            diffElement.setRightElement(leftElement);
            diffElement.setLeftElement(rightElement);
            EObject leftTarget = diffElement.getLeftTarget();
            EObject rightTarget = diffElement.getRightTarget();
            diffElement.setRightTarget(leftTarget);
            diffElement.setLeftTarget(rightTarget);
        }
        Collection<EObject> counterpartObjectsElement = this.mappingProvider.getCounterpartObjects(diffElement.getRightElement());
        this.checkForDeactivation(diffElement, counterpartObjectsElement);
        boolean isFirst = true;
        EObject rightTarget = diffElement.getRightTarget();
        for (EObject eObject : counterpartObjectsElement) {
            if (this.copier.get(diffElement.getLeftElement().eContainer()) != null) {
                diffElement.setRightTarget((EObject)this.copier.get(diffElement.getLeftElement().eContainer()));
            } else {
                diffElement.setRightTarget(this.mappingProvider.getCounterpartObject(rightTarget, diffElement, eObject));
            }
            if (isFirst) {
                isFirst = false;
                diffElement.setRightElement(eObject);
                this.checkForDeactivationRightTarget(diffElement);
                continue;
            }
            MoveModelElement newDiffElement = EcoreUtil.copy(diffElement);
            this.addDiffElementsToAdd(newDiffElement);
            newDiffElement.setRightElement(eObject);
            this.checkForDeactivationRightTarget(newDiffElement);
        }
    }

    private void rewireReferenceChangeLeftTarget(ReferenceChangeLeftTarget diffElement) {
        if (!this.mappingProvider.isInOriginModel(diffElement.getRightElement())) {
            EObject leftElement = diffElement.getLeftElement();
            EObject rightElement = diffElement.getRightElement();
            diffElement.setRightElement(leftElement);
            diffElement.setLeftElement(rightElement);
            EObject leftTarget = diffElement.getLeftTarget();
            EObject rightTarget = diffElement.getRightTarget();
            diffElement.setRightTarget(leftTarget);
            diffElement.setLeftTarget(rightTarget);
        }
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightElement());
        this.checkForDeactivation(diffElement, counterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            if (this.copier.get(diffElement.getLeftTarget()) != null) {
                diffElement.setLeftTarget((EObject)this.copier.get(diffElement.getLeftTarget()));
            } else {
                diffElement.setLeftTarget(this.mappingProvider.getCounterpartObject(diffElement.getRightTarget(), diffElement, eObject));
            }
            if (diffElement.getRightTarget() == null) {
                diffElement.setRightTarget(diffElement.getLeftTarget());
            }
            if (isFirst) {
                isFirst = false;
                diffElement.setRightElement(eObject);
                this.checkForDeactivationLeftTarget(diffElement);
                continue;
            }
            ReferenceChangeLeftTarget newDiffElement = EcoreUtil.copy(diffElement);
            this.addDiffElementsToAdd(newDiffElement);
            newDiffElement.setRightElement(eObject);
            this.checkForDeactivationLeftTarget(newDiffElement);
        }
    }

    private void rewireReferenceChangeRightTarget(ReferenceChangeRightTarget diffElement) {
        if (!this.mappingProvider.isInOriginModel(diffElement.getRightElement())) {
            EObject leftElement = diffElement.getLeftElement();
            EObject rightElement = diffElement.getRightElement();
            diffElement.setRightElement(leftElement);
            diffElement.setLeftElement(rightElement);
            EObject leftTarget = diffElement.getLeftTarget();
            EObject rightTarget = diffElement.getRightTarget();
            diffElement.setRightTarget(leftTarget);
            diffElement.setLeftTarget(rightTarget);
        }
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightElement());
        this.checkForDeactivation(diffElement, counterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            if (this.copier.get(diffElement.getRightTarget()) != null) {
                diffElement.setLeftTarget((EObject)this.copier.get(diffElement.getRightTarget()));
            } else {
                diffElement.setLeftTarget(this.mappingProvider.getCounterpartObject(diffElement.getRightTarget(), diffElement, eObject));
            }
            if (diffElement.getRightTarget() == null) {
                diffElement.setRightTarget(diffElement.getLeftTarget());
            }
            if (isFirst) {
                isFirst = false;
                diffElement.setRightElement(eObject);
                this.checkForDeactivationLeftTarget(diffElement);
                continue;
            }
            ReferenceChangeRightTarget newDiffElement = EcoreUtil.copy(diffElement);
            this.addDiffElementsToAdd(newDiffElement);
            newDiffElement.setRightElement(eObject);
            this.checkForDeactivationLeftTarget(newDiffElement);
        }
    }

    private void rewireUpdateReference(UpdateReference diffElement) {
        if (!this.mappingProvider.isInOriginModel(diffElement.getRightElement())) {
            EObject leftElement = diffElement.getLeftElement();
            EObject rightElement = diffElement.getRightElement();
            diffElement.setRightElement(leftElement);
            diffElement.setLeftElement(rightElement);
        }
        if (!this.mappingProvider.isInOriginModel(diffElement.getRightTarget())) {
            EObject leftTarget = diffElement.getLeftTarget();
            EObject rightTarget = diffElement.getRightTarget();
            diffElement.setRightTarget(leftTarget);
            diffElement.setLeftTarget(rightTarget);
        }
        Collection<EObject> counterpartObjects = this.mappingProvider.getCounterpartObjects(diffElement.getRightElement());
        this.checkForDeactivation(diffElement, counterpartObjects);
        boolean isFirst = true;
        for (EObject eObject : counterpartObjects) {
            if (this.copier.get(diffElement.getRightTarget()) != null) {
                diffElement.setRightTarget((EObject)this.copier.get(diffElement.getRightTarget()));
            } else {
                diffElement.setRightTarget(this.mappingProvider.getCounterpartObject(diffElement.getRightTarget(), diffElement, eObject));
            }
            if (isFirst) {
                isFirst = false;
                diffElement.setRightElement(eObject);
                this.checkForDeactivationRightTarget(diffElement);
                continue;
            }
            UpdateReference newDiffElement = EcoreUtil.copy(diffElement);
            this.addDiffElementsToAdd(newDiffElement);
            newDiffElement.setRightElement(eObject);
            this.checkForDeactivationRightTarget(newDiffElement);
        }
    }

    @Override
    public void mergeDiffEnd(MergeEvent event) {
        for (DiffElement diffElement : event.getDifferences()) {
            if (!(diffElement instanceof ModelElementChangeLeftTarget)) continue;
            ModelElementChangeLeftTarget addition = (ModelElementChangeLeftTarget)diffElement;
            EObject original = addition.getLeftElement();
            EObject copy = (EObject)this.copier.get(original);
            if (this.addedEObjects.get(original) == null) {
                this.addedEObjects.put(original, new BasicEList());
            }
            if (copy != null && !this.addedEObjects.get(original).contains(copy)) {
                this.addedEObjects.get(original).add(copy);
            }
            if (!this.addContainerOnly) continue;
            for (EObject containment : new BasicEList<EObject>(copy.eContents())) {
                if (containment instanceof EGenericType) continue;
                EcoreUtil.delete(containment);
                this.containmentsToOmit.add(containment);
            }
        }
    }

    @Override
    public void mergeDiffStart(MergeEvent event) {
        this.copier = MergeService.getCopier(event.getDifferences().get(0));
    }

    @Override
    public void mergeOperationStart(MergeEvent event) {
    }

    @Override
    public void mergeOperationEnd(MergeEvent event) {
    }

    private void rewireAddedObject(EObject object) {
        EObject addedObject = (EObject)this.copier.get(object);
        if (addedObject == null || this.addContainerOnly && this.containmentsToOmit.contains(addedObject)) {
            return;
        }
        if (object.eResource() != null && object.eResource() instanceof XMIResource && addedObject.eResource() != null && addedObject.eResource() instanceof XMIResource) {
            UUIDUtil.copyUUID(object, addedObject);
        }
        for (EStructuralFeature feature : addedObject.eClass().getEAllStructuralFeatures()) {
            try {
                EObject counterpartObject;
                Object value = addedObject.eGet(feature);
                if (value == null && object.eGet(feature) != null) {
                    value = object.eGet(feature);
                } else if (value instanceof EList && ((EList)value).size() < ((EList)object.eGet(feature)).size()) {
                    value = object.eGet(feature);
                }
                if (value instanceof EObject) {
                    counterpartObject = null;
                    if (this.copier.get(addedObject.eGet(feature)) != null) {
                        EFactory.eSet(addedObject, feature.getName(), this.copier.get(value));
                        continue;
                    }
                    counterpartObject = this.mappingProvider.getCounterpartObject(this.getMatchingObject((EObject)value), null, addedObject);
                    if (counterpartObject != null) {
                        EFactory.eSet(addedObject, feature.getName(), counterpartObject);
                        continue;
                    }
                    if (!(value instanceof EObject)) continue;
                    UUIDUtil.setUUID((EObject)value, UUIDUtil.getUUID((EObject)object.eGet(feature)));
                    continue;
                }
                if (!(value instanceof EList)) continue;
                counterpartObject = null;
                EList list = (EList)value;
                BasicEList<EObject> newList = new BasicEList<EObject>();
                for (Object valueInList : list) {
                    Object originalValueInList;
                    if (!(this.copier.get(valueInList) == null || this.addContainerOnly && this.containmentsToOmit.contains(this.copier.get(valueInList)))) {
                        newList.add((EObject)this.copier.get(valueInList));
                        continue;
                    }
                    counterpartObject = this.mappingProvider.getCounterpartObject(this.getMatchingObject((EObject)valueInList), null, addedObject);
                    if (!(counterpartObject == null || this.addContainerOnly && feature instanceof EReference && ((EReference)feature).isContainment() && !((EReference)feature).isDerived() || valueInList instanceof EGenericType)) {
                        newList.add(counterpartObject);
                        continue;
                    }
                    if (this.addContainerOnly) continue;
                    int i = list.indexOf(valueInList);
                    EList originalList = (EList)object.eGet(feature);
                    if (originalList.size() <= i || !((originalValueInList = originalList.get(i)) instanceof EObject) || !(valueInList instanceof EObject)) continue;
                    UUIDUtil.setUUID((EObject)valueInList, UUIDUtil.getUUID((EObject)originalValueInList));
                }
                if (this.addContainerOnly) {
                    if (feature.isDerived() || !feature.isChangeable() || value instanceof EList && ((EList)value).size() > 0 && newList.size() == 0 && ((EList)value).get(0) instanceof EGenericType) continue;
                    EFactory.eSet(addedObject, feature.getName(), newList);
                    continue;
                }
                if (newList.size() <= 0) continue;
                EFactory.eSet(addedObject, feature.getName(), newList);
            }
            catch (FactoryException factoryException) {}
        }
        TreeIterator<EObject> allContents = object.eAllContents();
        HashSet<EObject> objectsToRemove = new HashSet<EObject>();
        while (allContents.hasNext()) {
            EObject contentObject = (EObject)allContents.next();
            if (this.hasMatchingObject(contentObject)) {
                objectsToRemove.add((EObject)this.copier.get(contentObject));
                continue;
            }
            this.rewireAddedObject(contentObject);
        }
        for (EObject eObject : objectsToRemove) {
            if (eObject == null) continue;
            EcoreUtil.remove(eObject);
        }
    }

    private boolean hasMatchingObject(EObject eObject) {
        return this.getMatchingObject(eObject) != null;
    }

    private EObject getMatchingObject(EObject eObject) {
        return MatchUtil.getMatchingObject(eObject, this.matchModel);
    }
}

