/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.diff.service;

import java.util.Date;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.modelversioning.core.diff.engine.IDiffEngineSelector;
import org.modelversioning.core.diff.engine.impl.DefaultDiffEngineSelector;

public class DiffService {
    private IDiffEngineSelector diffEngineSelector;

    public DiffService(IDiffEngineSelector diffEngineSelector) {
        this.diffEngineSelector = diffEngineSelector;
    }

    public DiffService() {
        this.diffEngineSelector = new DefaultDiffEngineSelector();
    }

    public DiffModel generateDiffModel(MatchModel matchModel) {
        return this.diffEngineSelector.selectEngine(matchModel).generateDiffModel(matchModel);
    }

    public ComparisonResourceSnapshot generateComparisonResourceSnapshot(MatchModel matchModel) {
        DiffModel diffModel = this.diffEngineSelector.selectEngine(matchModel).generateDiffModel(matchModel);
        ComparisonResourceSnapshot comparisonResourceSnapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
        comparisonResourceSnapshot.setDate(new Date());
        comparisonResourceSnapshot.setDiff(diffModel);
        comparisonResourceSnapshot.setMatch(matchModel);
        return comparisonResourceSnapshot;
    }

    public IDiffEngineSelector getDiffEngineSelector() {
        return this.diffEngineSelector;
    }

    public void setDiffEngineSelector(IDiffEngineSelector diffEngineSelector) {
        this.diffEngineSelector = diffEngineSelector;
    }
}

