/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.diff.util;

import java.io.PrintStream;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.util.ClassUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelversioning.core.diff.copydiff.CopyDiffFactory;
import org.modelversioning.core.diff.copydiff.CopyElementLeftTarget;

public class DiffUtil {
    public static EList<DiffElement> getEffectiveDiffElements(DiffModel diffModel) {
        BasicEList<DiffElement> effectiveDiffElements = new BasicEList<DiffElement>();
        for (DiffElement diffElement : diffModel.getOwnedElements()) {
            effectiveDiffElements.addAll(DiffUtil.getEffectiveDiffElements(diffElement));
        }
        return effectiveDiffElements;
    }

    public static EList<DiffElement> getEffectiveDiffElements(DiffElement diffElement) {
        BasicEList<DiffElement> effectiveDiffElements = new BasicEList<DiffElement>();
        if (!(diffElement instanceof DiffGroup)) {
            effectiveDiffElements.add(diffElement);
        }
        for (DiffElement subDiffElement : diffElement.getSubDiffElements()) {
            effectiveDiffElements.addAll(DiffUtil.getEffectiveDiffElements(subDiffElement));
        }
        return effectiveDiffElements;
    }

    public static EList<DiffElement> getEffectiveDiffElements(EObject eObject, DiffModel diffModel) {
        BasicEList<DiffElement> effectiveDiffElements = new BasicEList<DiffElement>();
        for (DiffElement diffElement : DiffUtil.getEffectiveDiffElements(diffModel)) {
            EObject leftElement = DiffUtil.getLeftElement(diffElement);
            EObject rightElement = DiffUtil.getRightElement(diffElement);
            if ((leftElement == null || !leftElement.equals(eObject)) && (rightElement == null || !rightElement.equals(eObject))) continue;
            effectiveDiffElements.add(diffElement);
        }
        return effectiveDiffElements;
    }

    public static EObject getLeftElement(DiffElement object) {
        EObject leftElement = null;
        leftElement = (EObject)ClassUtils.invokeMethod(object, "getLeftElement", new Object[0]);
        return leftElement;
    }

    public static EObject getRightElement(DiffElement object) {
        EObject rightElement = null;
        rightElement = (EObject)ClassUtils.invokeMethod(object, "getRightElement", new Object[0]);
        return rightElement;
    }

    public static EObject getRightParent(DiffElement object) {
        EObject rightParent = null;
        rightParent = (EObject)ClassUtils.invokeMethod(object, "getRightParent", new Object[0]);
        return rightParent;
    }

    public static EObject getRightTarget(DiffElement object) {
        EObject rightElement;
        EObject rightTarget = null;
        rightTarget = (EObject)ClassUtils.invokeMethod(object, "getRightTarget", new Object[0]);
        if (rightTarget == null && (rightElement = DiffUtil.getRightElement(object)) != null) {
            return rightElement.eContainer();
        }
        return rightTarget;
    }

    public static EObject getLeftParent(DiffElement object) {
        EObject leftParent = null;
        leftParent = (EObject)ClassUtils.invokeMethod(object, "getLeftParent", new Object[0]);
        return leftParent;
    }

    public static EObject getLeftTarget(DiffElement object) {
        EObject leftElement;
        EObject leftTarget = null;
        leftTarget = (EObject)ClassUtils.invokeMethod(object, "getLeftTarget", new Object[0]);
        if (leftTarget == null && (leftElement = DiffUtil.getLeftElement(object)) != null) {
            return leftElement.eContainer();
        }
        return leftTarget;
    }

    public static EList<DiffElement> shallowCopy(Collection<DiffElement> diffElements) {
        BasicEList<DiffElement> copiedDiffElements = new BasicEList<DiffElement>();
        for (DiffElement diffElement : diffElements) {
            DiffElement newDiffElement;
            if (diffElement instanceof DiffGroup) {
                DiffGroup newDiffGroup = DiffFactory.eINSTANCE.createDiffGroup();
                newDiffGroup.getSubDiffElements().addAll(DiffUtil.shallowCopy(diffElement.getSubDiffElements()));
                copiedDiffElements.add(newDiffGroup);
                continue;
            }
            if (diffElement instanceof AttributeChangeLeftTarget) {
                newDiffElement = DiffFactory.eINSTANCE.createAttributeChangeLeftTarget();
                newDiffElement.setAttribute(((AttributeChangeLeftTarget)diffElement).getAttribute());
                newDiffElement.setLeftElement(((AttributeChangeLeftTarget)diffElement).getLeftElement());
                newDiffElement.setLeftTarget(((AttributeChangeLeftTarget)diffElement).getLeftTarget());
                newDiffElement.setRightElement(((AttributeChangeLeftTarget)diffElement).getRightElement());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (diffElement instanceof AttributeChangeRightTarget) {
                newDiffElement = DiffFactory.eINSTANCE.createAttributeChangeRightTarget();
                newDiffElement.setAttribute(((AttributeChangeRightTarget)diffElement).getAttribute());
                newDiffElement.setLeftElement(((AttributeChangeRightTarget)diffElement).getLeftElement());
                newDiffElement.setRightTarget(((AttributeChangeRightTarget)diffElement).getRightTarget());
                newDiffElement.setRightElement(((AttributeChangeRightTarget)diffElement).getRightElement());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (diffElement instanceof UpdateAttribute) {
                newDiffElement = DiffFactory.eINSTANCE.createUpdateAttribute();
                newDiffElement.setAttribute(((UpdateAttribute)diffElement).getAttribute());
                newDiffElement.setLeftElement(((UpdateAttribute)diffElement).getLeftElement());
                newDiffElement.setRightElement(((UpdateAttribute)diffElement).getRightElement());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (diffElement instanceof ConflictingDiffElement) continue;
            if (diffElement instanceof CopyElementLeftTarget) {
                newDiffElement = CopyDiffFactory.eINSTANCE.createCopyElementLeftTarget();
                newDiffElement.setLeftElement(((CopyElementLeftTarget)diffElement).getLeftElement());
                newDiffElement.setRightParent(((CopyElementLeftTarget)diffElement).getRightParent());
                newDiffElement.setCopiedRightElement(((CopyElementLeftTarget)diffElement).getCopiedRightElement());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (diffElement instanceof ModelElementChangeLeftTarget) {
                newDiffElement = DiffFactory.eINSTANCE.createModelElementChangeLeftTarget();
                newDiffElement.setLeftElement(((ModelElementChangeLeftTarget)diffElement).getLeftElement());
                newDiffElement.setRightParent(((ModelElementChangeLeftTarget)diffElement).getRightParent());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (diffElement instanceof ModelElementChangeRightTarget) {
                newDiffElement = DiffFactory.eINSTANCE.createModelElementChangeRightTarget();
                newDiffElement.setLeftParent(((ModelElementChangeRightTarget)diffElement).getLeftParent());
                newDiffElement.setRightElement(((ModelElementChangeRightTarget)diffElement).getRightElement());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (diffElement instanceof MoveModelElement) {
                newDiffElement = DiffFactory.eINSTANCE.createMoveModelElement();
                newDiffElement.setLeftTarget(((MoveModelElement)diffElement).getLeftTarget());
                newDiffElement.setLeftElement(((MoveModelElement)diffElement).getLeftElement());
                newDiffElement.setRightTarget(((MoveModelElement)diffElement).getRightTarget());
                newDiffElement.setRightElement(((MoveModelElement)diffElement).getRightElement());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (diffElement instanceof ReferenceChangeLeftTarget) {
                newDiffElement = DiffFactory.eINSTANCE.createReferenceChangeLeftTarget();
                newDiffElement.setLeftTarget(((ReferenceChangeLeftTarget)diffElement).getLeftTarget());
                newDiffElement.setLeftElement(((ReferenceChangeLeftTarget)diffElement).getLeftElement());
                newDiffElement.setRightTarget(((ReferenceChangeLeftTarget)diffElement).getRightTarget());
                newDiffElement.setRightElement(((ReferenceChangeLeftTarget)diffElement).getRightElement());
                newDiffElement.setReference(((ReferenceChangeLeftTarget)diffElement).getReference());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (diffElement instanceof ReferenceChangeRightTarget) {
                newDiffElement = DiffFactory.eINSTANCE.createReferenceChangeRightTarget();
                newDiffElement.setLeftTarget(((ReferenceChangeRightTarget)diffElement).getLeftTarget());
                newDiffElement.setLeftElement(((ReferenceChangeRightTarget)diffElement).getLeftElement());
                newDiffElement.setRightTarget(((ReferenceChangeRightTarget)diffElement).getRightTarget());
                newDiffElement.setRightElement(((ReferenceChangeRightTarget)diffElement).getRightElement());
                newDiffElement.setReference(((ReferenceChangeRightTarget)diffElement).getReference());
                copiedDiffElements.add(newDiffElement);
                continue;
            }
            if (!(diffElement instanceof UpdateReference)) continue;
            newDiffElement = DiffFactory.eINSTANCE.createUpdateReference();
            newDiffElement.setLeftTarget(((UpdateReference)diffElement).getLeftTarget());
            newDiffElement.setLeftElement(((UpdateReference)diffElement).getLeftElement());
            newDiffElement.setRightTarget(((UpdateReference)diffElement).getRightTarget());
            newDiffElement.setRightElement(((UpdateReference)diffElement).getRightElement());
            newDiffElement.setReference(((UpdateReference)diffElement).getReference());
            copiedDiffElements.add(newDiffElement);
        }
        return copiedDiffElements;
    }

    public static EStructuralFeature getUpdatedFeature(DiffElement diffElement) {
        if (diffElement instanceof ReferenceChange) {
            return ((ReferenceChange)diffElement).getReference();
        }
        if (diffElement instanceof AttributeChange) {
            return ((AttributeChange)diffElement).getAttribute();
        }
        if (diffElement instanceof ModelElementChangeRightTarget) {
            return ((ModelElementChangeRightTarget)diffElement).getRightElement().eContainingFeature();
        }
        if (diffElement instanceof ModelElementChangeLeftTarget) {
            return ((ModelElementChangeLeftTarget)diffElement).getLeftElement().eContainmentFeature();
        }
        return null;
    }

    public static void debugPrint(DiffModel diff, PrintStream out) {
        out.println("====== Diff Model ======");
        EList<DiffElement> ownedElements = diff.getOwnedElements();
        for (DiffElement diffElement : ownedElements) {
            DiffUtil.debugPring(diffElement, out);
        }
    }

    public static void debugPring(DiffElement diffElement, PrintStream out) {
        DiffUtil.debugPring(diffElement, out, "");
    }

    private static void debugPring(DiffElement diffElement, PrintStream out, String offset) {
        out.println(diffElement);
        if (diffElement.getSubDiffElements().size() > 0) {
            for (DiffElement subDiff : diffElement.getSubDiffElements()) {
                offset = String.valueOf(offset) + "  ";
                out.print(offset);
                DiffUtil.debugPring(subDiff, out, offset);
            }
        }
    }
}

