/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.match.engine.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.core.match.MatchPlugin;
import org.modelversioning.core.match.engine.IMatchEngine;
import org.modelversioning.core.match.engine.IMatchEngineSelector;
import org.modelversioning.core.match.engine.impl.EMFCompareMatchEngine;
import org.modelversioning.core.match.engine.impl.UUIDMatchEngine;

public class DefaultMatchEngineSelector
implements IMatchEngineSelector {
    public static final String IMATCH_ENGINE_ID = "org.modelversioning.core.match.engine";
    private IMatchEngine uuidMatchEngine = new UUIDMatchEngine();
    private IMatchEngine emfCompareMatchEngine = new EMFCompareMatchEngine();
    private Set<IMatchEngine> matchEngines = new HashSet<IMatchEngine>();

    public DefaultMatchEngineSelector() {
        this.init(true);
    }

    public DefaultMatchEngineSelector(boolean includeExtensions) {
        this.init(includeExtensions);
    }

    private void init(boolean includeExtensions) {
        this.matchEngines.add(this.uuidMatchEngine);
        this.matchEngines.add(this.emfCompareMatchEngine);
        if (includeExtensions) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(IMATCH_ENGINE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                Status status;
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                try {
                    Object matchEngine = configElement.createExecutableExtension("class");
                    this.matchEngines.add((IMatchEngine)matchEngine);
                }
                catch (CoreException e) {
                    status = new Status(4, "org.modelversioning.core.match", "Failed to load contributed match engine", e);
                    MatchPlugin.getDefault().getLog().log(status);
                }
                catch (ClassCastException e) {
                    status = new Status(4, "org.modelversioning.core.match", "Failed to load contributed match engine", e);
                    MatchPlugin.getDefault().getLog().log(status);
                }
                ++n2;
            }
        }
    }

    @Override
    public IMatchEngine selectEngine(Resource resource1, Resource resource2) {
        return this.getBestMatchEngine(resource1, resource2);
    }

    @Override
    public IMatchEngine selectEngine(Resource origin, Resource resource1, Resource resource2) {
        return this.getBestMatchEngine(origin, resource1, resource2);
    }

    @Override
    public IMatchEngine selectEngine(EObject origin, EObject eObject1, EObject eObject2) {
        return this.getBestMatchEngine(origin, eObject1, eObject2);
    }

    @Override
    public IMatchEngine selectEngine(EObject eObject1, EObject eObject2) {
        return this.getBestMatchEngine(eObject1, eObject2);
    }

    private IMatchEngine getBestMatchEngine(Resource ... resources) {
        BasicEList<EObject> rootObjects = new BasicEList<EObject>();
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            rootObjects.addAll(resource.getContents());
            ++n2;
        }
        return this.getBestMatchEngine(rootObjects.toArray(new EObject[rootObjects.size()]));
    }

    private IMatchEngine getBestMatchEngine(EObject ... eObjects) {
        IMatchEngine bestMatchEngine = null;
        int bestAcceptRate = 0;
        for (IMatchEngine matchEngine : this.matchEngines) {
            int acceptRate = matchEngine.accept(eObjects);
            if (acceptRate <= 0 || bestMatchEngine != null && acceptRate <= bestAcceptRate) continue;
            bestMatchEngine = matchEngine;
            bestAcceptRate = acceptRate;
        }
        return bestMatchEngine;
    }
}

