/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.match.engine.impl;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.core.match.MatchException;
import org.modelversioning.core.match.engine.IMatchEngine;
import org.modelversioning.core.util.EcoreUtil;
import org.modelversioning.core.util.UUIDUtil;

public class EMFCompareMatchEngine
implements IMatchEngine {
    @Override
    public MatchModel generateMatchModel(Resource resource1, Resource resource2) throws MatchException {
        org.eclipse.emf.compare.match.engine.IMatchEngine engine = EMFCompareMatchEngine.getBestMatchEngine(resource1, resource2);
        try {
            MatchModel matchModel = engine.modelMatch(EcoreUtil.getFirstRootObject(resource2), EcoreUtil.getFirstRootObject(resource1), null);
            return this.improveMatchModel(matchModel, resource2, resource1);
        }
        catch (InterruptedException e) {
            throw new MatchException(e);
        }
    }

    @Override
    public MatchModel generateMatchModel(EObject eObject1, EObject eObject2) throws MatchException {
        org.eclipse.emf.compare.match.engine.IMatchEngine engine = EMFCompareMatchEngine.getBestMatchEngine(eObject1.eResource(), eObject2.eResource());
        try {
            MatchModel matchModel = engine.contentMatch(eObject2, eObject1, null);
            matchModel.getRightRoots().clear();
            matchModel.getRightRoots().add(eObject2);
            matchModel.getLeftRoots().clear();
            matchModel.getLeftRoots().add(eObject1);
            return this.improveMatchModel(matchModel, eObject2.eResource(), eObject1.eResource());
        }
        catch (InterruptedException e) {
            throw new MatchException(e);
        }
    }

    private MatchModel improveMatchModel(MatchModel matchModel, Resource resource2, Resource resource1) {
        BasicEList<UnmatchElement> unmatchedElements = new BasicEList<UnmatchElement>();
        unmatchedElements.addAll(matchModel.getUnmatchedElements());
        for (UnmatchElement unmatchElement : unmatchedElements) {
            EObject right;
            EObject oppositeObject = null;
            oppositeObject = Side.RIGHT.equals(unmatchElement.getSide()) ? UUIDUtil.getObject(resource2, UUIDUtil.getUUID(unmatchElement.getElement())) : UUIDUtil.getObject(resource1, UUIDUtil.getUUID(unmatchElement.getElement()));
            if (oppositeObject == null) continue;
            Match2Elements match2Elements = null;
            match2Elements = Side.LEFT.equals(unmatchElement.getSide()) ? this.addMatch2Elements(unmatchElement.getElement(), oppositeObject, matchModel) : this.addMatch2Elements(oppositeObject, unmatchElement.getElement(), matchModel);
            TreeIterator<EObject> leftContents = match2Elements.getLeftElement().eAllContents();
            while (leftContents.hasNext()) {
                EObject left = (EObject)leftContents.next();
                right = UUIDUtil.getObject(resource1, UUIDUtil.getUUID(left));
                if (right != null) {
                    this.addMatch2Elements(left, right, matchModel);
                    continue;
                }
                this.addUnmatchElement(left, Side.LEFT, matchModel);
            }
            TreeIterator<EObject> rightContents = match2Elements.getRightElement().eAllContents();
            while (rightContents.hasNext()) {
                right = (EObject)rightContents.next();
                EObject left = UUIDUtil.getObject(resource2, UUIDUtil.getUUID(right));
                if (left != null) {
                    this.addMatch2Elements(left, right, matchModel);
                    continue;
                }
                this.addUnmatchElement(right, Side.RIGHT, matchModel);
            }
            matchModel.getUnmatchedElements().remove(unmatchElement);
        }
        return matchModel;
    }

    private void addUnmatchElement(EObject eObject, Side side, MatchModel matchModel) {
        UnmatchElement unmatchElement = MatchFactory.eINSTANCE.createUnmatchElement();
        unmatchElement.setSide(side);
        unmatchElement.setElement(eObject);
        matchModel.getUnmatchedElements().add(unmatchElement);
    }

    private Match2Elements addMatch2Elements(EObject left, EObject right, MatchModel matchModel) {
        Match2Elements match2Elements = MatchFactory.eINSTANCE.createMatch2Elements();
        match2Elements.setSimilarity(1.0);
        match2Elements.setLeftElement(left);
        match2Elements.setRightElement(right);
        EObject containerOfRightElm = match2Elements.getRightElement().eContainer();
        Match2Elements match = this.getMatch2ElementsOfRightObject(containerOfRightElm, matchModel);
        if (match == null) {
            EObject containerOfLeftElm = match2Elements.getLeftElement().eContainer();
            match = this.getMatch2ElementsOfLeftObject(containerOfLeftElm, matchModel);
            if (match != null) {
                match.getSubMatchElements().add(match2Elements);
            } else {
                matchModel.getMatchedElements().add(match2Elements);
            }
        } else {
            match.getSubMatchElements().add(match2Elements);
        }
        return match2Elements;
    }

    private Match2Elements getMatch2ElementsOfRightObject(EObject eObject, MatchModel matchModel) {
        for (MatchElement matchElement : matchModel.getMatchedElements()) {
            if (matchElement instanceof Match2Elements && UUIDUtil.getUUID(eObject).equals(UUIDUtil.getUUID(((Match2Elements)matchElement).getRightElement()))) {
                return (Match2Elements)matchElement;
            }
            TreeIterator<EObject> treeIterator = matchElement.eAllContents();
            while (treeIterator.hasNext()) {
                EObject nextChild = (EObject)treeIterator.next();
                if (!(nextChild instanceof Match2Elements)) continue;
                Match2Elements match2Elements = (Match2Elements)nextChild;
                if (!UUIDUtil.getUUID(eObject).equals(UUIDUtil.getUUID(match2Elements.getRightElement()))) continue;
                return match2Elements;
            }
        }
        return null;
    }

    private Match2Elements getMatch2ElementsOfLeftObject(EObject eObject, MatchModel matchModel) {
        for (MatchElement matchElement : matchModel.getMatchedElements()) {
            if (matchElement instanceof Match2Elements && UUIDUtil.getUUID(eObject).equals(UUIDUtil.getUUID(((Match2Elements)matchElement).getLeftElement()))) {
                return (Match2Elements)matchElement;
            }
            TreeIterator<EObject> treeIterator = matchElement.eAllContents();
            while (treeIterator.hasNext()) {
                EObject nextChild = (EObject)treeIterator.next();
                if (!(nextChild instanceof Match2Elements)) continue;
                Match2Elements match2Elements = (Match2Elements)nextChild;
                if (!UUIDUtil.getUUID(eObject).equals(UUIDUtil.getUUID(match2Elements.getLeftElement()))) continue;
                return match2Elements;
            }
        }
        return null;
    }

    @Override
    public MatchModel generateMatchModel(Resource origin, Resource resource1, Resource resource2) throws MatchException {
        org.eclipse.emf.compare.match.engine.IMatchEngine engine = EMFCompareMatchEngine.getBestMatchEngine(origin, resource1, resource2);
        try {
            return engine.modelMatch(EcoreUtil.getFirstRootObject(resource1), EcoreUtil.getFirstRootObject(resource2), EcoreUtil.getFirstRootObject(origin), null);
        }
        catch (InterruptedException e) {
            throw new MatchException(e);
        }
    }

    private static org.eclipse.emf.compare.match.engine.IMatchEngine getBestMatchEngine(Resource ... resources) {
        return MatchService.getBestMatchEngine(resources);
    }

    @Override
    public int accept(EObject ... eObjects) {
        return 1;
    }
}

