/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.match.engine.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.core.match.MatchException;
import org.modelversioning.core.match.engine.IMatchEngine;
import org.modelversioning.core.util.EcoreUtil;
import org.modelversioning.core.util.UUIDUtil;

public class UUIDMatchEngine
implements IMatchEngine {
    private Set<EObject> unmatched = new HashSet<EObject>();

    @Override
    public int accept(EObject ... eObjects) {
        EObject[] eObjectArray = eObjects;
        int n = eObjects.length;
        int n2 = 0;
        while (n2 < n) {
            EObject root = eObjectArray[n2];
            String uuid = UUIDUtil.getUUID(root);
            if (uuid == null) {
                return 0;
            }
            ++n2;
        }
        return 2;
    }

    @Override
    public MatchModel generateMatchModel(Resource resource1, Resource resource2) throws MatchException {
        this.unmatched.clear();
        MatchModel matchModel = MatchFactory.eINSTANCE.createMatchModel();
        matchModel.getLeftRoots().addAll(resource1.getContents());
        matchModel.getRightRoots().addAll(resource2.getContents());
        matchModel.getMatchedElements().addAll(this.createMatch2Elements(resource2.getContents(), resource1, matchModel.getUnmatchedElements(), 0));
        matchModel.getUnmatchedElements().addAll(this.findUnMatchedElements(resource1.getContents(), resource2, false));
        return matchModel;
    }

    @Override
    public MatchModel generateMatchModel(EObject eObject1, EObject eObject2) throws MatchException {
        this.unmatched.clear();
        MatchModel matchModel = MatchFactory.eINSTANCE.createMatchModel();
        matchModel.getLeftRoots().add(eObject1);
        matchModel.getRightRoots().add(eObject2);
        BasicEList<EObject> list2 = new BasicEList<EObject>();
        list2.add(eObject2);
        matchModel.getMatchedElements().addAll(this.createMatch2Elements(list2, eObject1.eResource(), matchModel.getUnmatchedElements(), 0, eObject1));
        BasicEList<EObject> list1 = new BasicEList<EObject>();
        list1.add(eObject1);
        matchModel.getUnmatchedElements().addAll(this.findUnMatchedElements(list1, eObject2.eResource(), false, eObject2));
        return matchModel;
    }

    private EList<Match2Elements> createMatch2Elements(EList<EObject> leftObjects, Resource rightResource, EList<UnmatchElement> unmatchedElements, int level) {
        return this.createMatch2Elements(leftObjects, rightResource, unmatchedElements, level, null);
    }

    private EList<Match2Elements> createMatch2Elements(EList<EObject> leftObjects, Resource rightResource, EList<UnmatchElement> unmatchedElements, int level, EObject matchOnlyRoot2) {
        BasicEList<Match2Elements> match2Elements = new BasicEList<Match2Elements>();
        if (leftObjects != null && leftObjects.size() > 0) {
            for (EObject leftObject : leftObjects) {
                boolean containedByRoot2;
                EObject rightObject = UUIDUtil.getObject(rightResource, UUIDUtil.getUUID(leftObject));
                boolean bl = containedByRoot2 = matchOnlyRoot2 == null || rightObject == null || rightObject.equals(matchOnlyRoot2) || EcoreUtil.createParentList(rightObject).contains(matchOnlyRoot2);
                if (rightObject != null && containedByRoot2) {
                    Match2Elements match2Element = MatchFactory.eINSTANCE.createMatch2Elements();
                    match2Element.setLeftElement(leftObject);
                    match2Element.setRightElement(rightObject);
                    match2Element.setSimilarity(1.0);
                    if (level < 1) {
                        match2Element.getSubMatchElements().addAll(this.createMatch2Elements(leftObject.eContents(), rightResource, unmatchedElements, level + 1, matchOnlyRoot2));
                    }
                    match2Elements.add(match2Element);
                } else if (leftObject instanceof EGenericType && containedByRoot2) {
                    Match2Elements match2ElementGeneric = this.matchGenericType((EGenericType)leftObject, rightResource);
                    if (match2ElementGeneric != null) {
                        match2Elements.add(match2ElementGeneric);
                    } else if (!this.isUnmatchedAlready(EcoreUtil.createParentList(leftObject))) {
                        unmatchedElements.add(this.createUnMatchElement(leftObject, Side.LEFT, false));
                    }
                } else if (!this.isUnmatchedAlready(EcoreUtil.createParentList(leftObject))) {
                    unmatchedElements.add(this.createUnMatchElement(leftObject, Side.LEFT, false));
                }
                if (level < 1) continue;
                match2Elements.addAll(this.createMatch2Elements(leftObject.eContents(), rightResource, unmatchedElements, level + 1, matchOnlyRoot2));
            }
        }
        return match2Elements;
    }

    private Match2Elements matchGenericType(EGenericType leftObject, Resource rightResource) {
        EObject leftParent = leftObject.eContainer();
        EObject rightParent = UUIDUtil.getObject(rightResource, UUIDUtil.getUUID(leftParent));
        EStructuralFeature feature = leftObject.eContainingFeature();
        if (leftParent != null && rightParent != null) {
            String rightName;
            boolean isEqual = false;
            Object rightObject = rightParent.eGet(feature);
            if (leftObject.getEClassifier() == null) {
                return null;
            }
            String leftName = leftObject.getEClassifier().getName();
            if (feature.isMany() && rightObject != null) {
                int leftIndex = ((List)leftParent.eGet(feature)).indexOf(leftObject);
                List rightList = (List)rightObject;
                if (rightList.size() > leftIndex) {
                    rightObject = rightList.get(leftIndex);
                }
            }
            if (rightObject != null && rightObject instanceof EGenericType && leftName.equals(rightName = ((EGenericType)rightObject).getEClassifier().getName())) {
                isEqual = true;
            }
            if (isEqual) {
                Match2Elements match2Elements = MatchFactory.eINSTANCE.createMatch2Elements();
                match2Elements.setLeftElement(leftObject);
                match2Elements.setRightElement((EObject)rightObject);
                match2Elements.setSimilarity(1.0);
                return match2Elements;
            }
        }
        return null;
    }

    private boolean isUnmatchedAlready(EObject eObject) {
        return this.unmatched.contains(eObject);
    }

    private boolean isUnmatchedAlready(Collection<EObject> eObjects) {
        for (EObject eObject : eObjects) {
            if (!this.isUnmatchedAlready(eObject)) continue;
            return true;
        }
        return false;
    }

    private EList<UnmatchElement> findUnMatchedElements(EList<EObject> eObjects, Resource resource, boolean remote) {
        return this.findUnMatchedElements(eObjects, resource, remote, null);
    }

    private EList<UnmatchElement> findUnMatchedElements(EList<EObject> eObjects, Resource resource, boolean remote, EObject matchOnlyRoot) {
        BasicEList<UnmatchElement> unMatchElements = new BasicEList<UnmatchElement>();
        for (EObject eObject : eObjects) {
            boolean haveMatch;
            EObject matchingObject = UUIDUtil.getObject(resource, UUIDUtil.getUUID(eObject));
            boolean bl = haveMatch = matchingObject != null && (matchOnlyRoot == null || matchingObject.equals(matchOnlyRoot) || EcoreUtil.createParentList(matchingObject).contains(matchOnlyRoot));
            if (!(eObject instanceof EGenericType || haveMatch || this.isUnmatchedAlready(EcoreUtil.createParentList(eObject)))) {
                unMatchElements.add(this.createUnMatchElement(eObject, Side.RIGHT, remote));
            }
            TreeIterator<EObject> eObjectIterator = eObject.eAllContents();
            while (eObjectIterator.hasNext()) {
                boolean haveSubMatch;
                EObject subEObject = (EObject)eObjectIterator.next();
                EObject matchingSubObject = UUIDUtil.getObject(resource, UUIDUtil.getUUID(subEObject));
                boolean bl2 = haveSubMatch = matchingSubObject != null && (matchOnlyRoot == null || EcoreUtil.createParentList(matchingSubObject).contains(matchOnlyRoot));
                if (subEObject instanceof EGenericType || haveSubMatch || this.isUnmatchedAlready(EcoreUtil.createParentList(subEObject))) continue;
                unMatchElements.add(this.createUnMatchElement(subEObject, Side.RIGHT, remote));
            }
        }
        return unMatchElements;
    }

    private UnmatchElement createUnMatchElement(EObject object, Side side, boolean remote) {
        UnmatchElement unMatchElement = null;
        unMatchElement = MatchFactory.eINSTANCE.createUnmatchElement();
        unMatchElement.setRemote(remote);
        unMatchElement.setSide(side);
        unMatchElement.setElement(object);
        this.unmatched.add(object);
        return unMatchElement;
    }

    @Override
    public MatchModel generateMatchModel(Resource origin, Resource resource1, Resource resource2) throws MatchException {
        this.unmatched.clear();
        MatchModel matchModel = MatchFactory.eINSTANCE.createMatchModel();
        matchModel.getMatchedElements().addAll(this.createMatch3Elements(origin.getContents(), resource1, resource2, matchModel.getUnmatchedElements(), 0));
        matchModel.getUnmatchedElements().addAll(this.findUnMatchedElements(resource1.getContents(), origin, false));
        matchModel.getUnmatchedElements().addAll(this.findUnMatchedElements(resource2.getContents(), origin, false));
        return matchModel;
    }

    private EList<Match3Elements> createMatch3Elements(EList<EObject> originObjects, Resource leftResource, Resource rightResource, EList<UnmatchElement> unmatchedElements, int level) {
        BasicEList<Match3Elements> match3Elementss = new BasicEList<Match3Elements>();
        if (originObjects != null && originObjects.size() > 0) {
            for (EObject originObject : originObjects) {
                EObject leftObject = UUIDUtil.getObject(leftResource, UUIDUtil.getUUID(originObject));
                EObject rightObject = UUIDUtil.getObject(rightResource, UUIDUtil.getUUID(originObject));
                if (rightObject != null && leftObject != null) {
                    Match3Elements match3Elements = MatchFactory.eINSTANCE.createMatch3Elements();
                    match3Elements.setOriginElement(originObject);
                    match3Elements.setLeftElement(leftObject);
                    match3Elements.setRightElement(rightObject);
                    match3Elements.setSimilarity(1.0);
                    if (level < 1) {
                        match3Elements.getSubMatchElements().addAll(this.createMatch3Elements(originObject.eContents(), leftResource, rightResource, unmatchedElements, level + 1));
                    } else {
                        match3Elementss.addAll(this.createMatch3Elements(originObject.eContents(), leftResource, rightResource, unmatchedElements, level + 1));
                    }
                    match3Elementss.add(match3Elements);
                    continue;
                }
                if (originObject instanceof EGenericType) {
                    Match3Elements Match3Elements2 = this.matchGenericType((EGenericType)originObject, leftResource, rightResource);
                    if (Match3Elements2 != null) {
                        match3Elementss.add(Match3Elements2);
                        continue;
                    }
                    if (this.isUnmatchedAlready(EcoreUtil.createParentList(originObject))) continue;
                    unmatchedElements.add(this.createUnMatchElement(originObject, Side.RIGHT, false));
                    continue;
                }
                if (leftObject != null) {
                    if (this.isUnmatchedAlready(EcoreUtil.createParentList(originObject))) continue;
                    unmatchedElements.add(this.createUnMatchElement(originObject, Side.RIGHT, true));
                    continue;
                }
                if (rightObject == null || this.isUnmatchedAlready(EcoreUtil.createParentList(originObject))) continue;
                unmatchedElements.add(this.createUnMatchElement(originObject, Side.LEFT, false));
            }
        }
        return match3Elementss;
    }

    private Match3Elements matchGenericType(EGenericType originObject, Resource leftResource, Resource rightResource) {
        EObject parent = originObject.eContainer();
        EObject leftParent = UUIDUtil.getObject(leftResource, UUIDUtil.getUUID(parent));
        EObject rightParent = UUIDUtil.getObject(rightResource, UUIDUtil.getUUID(parent));
        if (leftParent != null && rightParent != null) {
            Object leftObject = leftParent.eGet(originObject.eContainingFeature());
            Object rightObject = rightParent.eGet(originObject.eContainingFeature());
            if (leftObject != null && rightObject != null && leftObject instanceof EObject && rightObject instanceof EObject) {
                Match3Elements Match3Elements2 = MatchFactory.eINSTANCE.createMatch3Elements();
                Match3Elements2.setOriginElement(originObject);
                Match3Elements2.setLeftElement((EObject)leftObject);
                Match3Elements2.setRightElement((EObject)rightObject);
                Match3Elements2.setSimilarity(1.0);
                return Match3Elements2;
            }
        }
        return null;
    }
}

