/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EcoreUtil {
    public static List<EObject> createParentList(EObject eObject) {
        ArrayList<EObject> parentsList = new ArrayList<EObject>();
        if (eObject == null) {
            return parentsList;
        }
        EObject parentObject = eObject;
        while ((parentObject = parentObject.eContainer()) != null) {
            parentsList.add(parentObject);
        }
        return parentsList;
    }

    public static EObject findLeastCommonParentObject(EObject eObject1, EObject eObject2) {
        List<EObject> parents1 = EcoreUtil.createParentList(eObject1);
        List<EObject> parents2 = EcoreUtil.createParentList(eObject2);
        if (eObject1.eContainer() == null && eObject2.eContainer() == null && eObject1.equals(eObject2)) {
            return eObject1;
        }
        if (eObject1.eContainer() == null || parents2.contains(eObject1)) {
            return eObject1;
        }
        if (eObject2.eContainer() == null || parents1.contains(eObject2)) {
            return eObject2;
        }
        return EcoreUtil.findLeastCommonParentObject(parents1, parents2);
    }

    public static EObject findLeastCommonParentObject(List<EObject> parents1, List<EObject> parents2) {
        for (EObject currentParent : parents1) {
            if (!parents2.contains(currentParent)) continue;
            return currentParent;
        }
        return null;
    }

    public static EObject getFirstRootObject(Resource resource) {
        if (resource != null && !resource.getContents().isEmpty()) {
            return (EObject)resource.getContents().get(0);
        }
        return null;
    }
}

