/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;

public class ModelDiagramUtil {
    public static boolean containsDiagram(Resource resource) {
        NotationPackage.eINSTANCE.getNsURI();
        if (resource.getContents().size() < 1) {
            return false;
        }
        try {
            Diagram diagram = (Diagram)resource.getContents().get(0);
            diagram.getElement();
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static Collection<IFile> getModelFilesFromDiagram(Resource resourceContainingDiagram) {
        NotationPackage.eINSTANCE.getNsURI();
        Assert.isTrue(ModelDiagramUtil.containsDiagram(resourceContainingDiagram), "Specified resource is no diagram");
        Assert.isTrue(resourceContainingDiagram.getURI().hasAbsolutePath(), "Diagram resource path is not absolute");
        if (resourceContainingDiagram.getContents().size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<IFile> modelFileList = new ArrayList<IFile>();
        for (EObject diagramEObject : resourceContainingDiagram.getContents()) {
            if (!(diagramEObject instanceof Diagram)) continue;
            try {
                Diagram diagram = (Diagram)diagramEObject;
                URI modelURI = EcoreUtil.getURI(diagram.getElement());
                URI resolvedModelURI = modelURI.resolve(resourceContainingDiagram.getURI());
                String fileString = resolvedModelURI.toFileString();
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileString));
                modelFileList.add(iFile);
            }
            catch (ClassCastException classCastException) {}
        }
        return Collections.unmodifiableCollection(modelFileList);
    }

    public static String getPlatformResourceURI(IFile file) {
        if (file.getProject() != null) {
            return String.valueOf(file.getProject().getName()) + "/" + file.getProjectRelativePath();
        }
        return file.getFullPath().toOSString();
    }
}

