/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.core.util;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class UUIDUtil {
    private static final String NOT_CONTAINED_BY_XML_RESOURCE = "The specified argument is not contained by a XMLResource. ";

    public static String getUUID(EObject eObject) {
        String objectID = null;
        if (eObject != null && eObject.eResource() instanceof XMIResource) {
            objectID = ((XMIResource)eObject.eResource()).getID(eObject);
        }
        return objectID;
    }

    public static void setUUID(EObject object, String id) {
        if (object != null && object.eResource() instanceof XMIResource) {
            ((XMIResource)object.eResource()).setID(object, id);
        }
    }

    public static void copyUUID(EObject source, EObject target) {
        if (UUIDUtil.getUUID(source) != null) {
            UUIDUtil.setUUID(target, UUIDUtil.getUUID(source));
        }
    }

    public static void copyUUID(EObject source, EcoreUtil.Copier copier) {
        UUIDUtil.copyUUID(source, (EObject)copier.get(source));
    }

    public static void copyUUIDs(EObject source, EcoreUtil.Copier copier) {
        UUIDUtil.copyUUID(source, (EObject)copier.get(source));
        TreeIterator<EObject> treeIterator = source.eAllContents();
        while (treeIterator.hasNext()) {
            EObject next = (EObject)treeIterator.next();
            UUIDUtil.copyUUID(next, (EObject)copier.get(next));
        }
    }

    public static EObject getObject(Resource resource, String uuid) {
        if (uuid == null) {
            return null;
        }
        return resource.getEObject(uuid);
    }

    public static void removeUUIDs(EObject eObject) {
        UUIDUtil.throwExceptionIfNotXMLResource(eObject);
        UUIDUtil.setUUID(eObject, null);
        TreeIterator<EObject> treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject contentObject = (EObject)treeIterator.next();
            UUIDUtil.setUUID(contentObject, null);
        }
    }

    public static void addUUIDs(EObject eObject) {
        UUIDUtil.throwExceptionIfNotXMLResource(eObject);
        UUIDUtil.addUUID(eObject);
        TreeIterator<EObject> treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            UUIDUtil.addUUID((EObject)treeIterator.next());
        }
    }

    public static void addUUID(EObject eObject) {
        UUIDUtil.throwExceptionIfNotXMLResource(eObject);
        if (UUIDUtil.getUUID(eObject) == null) {
            UUIDUtil.setUUID(eObject, EcoreUtil.generateUUID());
        }
    }

    private static void throwExceptionIfNotXMLResource(EObject eObject) {
        if (eObject.eResource() == null || !(eObject.eResource() instanceof XMLResource)) {
            throw new IllegalArgumentException(NOT_CONTAINED_BY_XML_RESOURCE);
        }
    }
}

