/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.merge.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DifferenceKind;
import org.modelversioning.conflictreport.ConflictReport;
import org.modelversioning.conflictreport.conflict.AddAdd;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflictreport.conflict.OverlappingChange;
import org.modelversioning.conflictreport.conflict.Violation;
import org.modelversioning.conflictreport.conflict.ViolationSeverity;
import org.modelversioning.merge.IMergeStrategy;

public class ConflictAwareMergeStrategy
implements IMergeStrategy {
    @Override
    public boolean shouldMerge(DiffElement diffElement, ConflictReport conflictReport) {
        if (!diffElement.getKind().equals(DifferenceKind.DELETION) && diffElement.getIsHiddenBy().isEmpty()) {
            EList<Conflict> conflicts = conflictReport.getConflicts(diffElement);
            if (!this.shouldMergeConflict(conflicts) && !diffElement.getKind().equals(DifferenceKind.ADDITION)) {
                return false;
            }
            conflicts = conflictReport.getConflicts(conflictReport.getDependentModelChange(diffElement));
            if (!this.shouldMergeConflict(conflicts) && !diffElement.getKind().equals(DifferenceKind.ADDITION)) {
                return false;
            }
            EList<DiffElement> equivalentChanges = conflictReport.getEquivalentChanges(diffElement);
            if (!this.shouldMergeEquivalentChange(diffElement, equivalentChanges, conflictReport.getEquivalentPreferredChanges())) {
                return false;
            }
            equivalentChanges = conflictReport.getEquivalentChanges(conflictReport.getDependentModelChange(diffElement));
            return this.shouldMergeEquivalentChange(conflictReport.getDependentModelChange(diffElement), equivalentChanges, conflictReport.getEquivalentPreferredChanges());
        }
        return false;
    }

    private boolean shouldMergeConflict(EList<Conflict> conflicts) {
        for (Conflict conflict : conflicts) {
            if ((!(conflict instanceof OverlappingChange) || conflict instanceof AddAdd) && (!(conflict instanceof Violation) || ((Violation)conflict).getSeverity().equals(ViolationSeverity.WARNING))) continue;
            return false;
        }
        return true;
    }

    private boolean shouldMergeEquivalentChange(DiffElement change, EList<DiffElement> equivalentChanges, EList<DiffElement> equivalentPreferredChanges) {
        return equivalentChanges == null || equivalentChanges.size() <= 0 || equivalentPreferredChanges.contains(change);
    }
}

