/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.merge.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.conflictreport.ConflictReport;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflictreport.conflict.DeleteUpdate;
import org.modelversioning.conflictreport.conflict.DeleteUse;
import org.modelversioning.core.util.EcoreUtil;
import org.modelversioning.merge.IMergeStrategy;

public class ConflictTolerantMergeStrategy
implements IMergeStrategy {
    @Override
    public boolean shouldMerge(DiffElement diffElement, ConflictReport conflictReport) {
        if (!conflictReport.hasConflictingChange(diffElement)) {
            DiffElement deletion;
            EObject deletedTargetValue;
            return !this.isRemoveReferenceTarget(diffElement) || (deletedTargetValue = this.getDeletedTargetValue(diffElement)) == null || this.shouldMerge(deletion = this.getDeletion(deletedTargetValue, diffElement, conflictReport), conflictReport);
        }
        EList<Conflict> conflicts = conflictReport.getConflicts(diffElement);
        for (Conflict conflict : conflicts) {
            if (!(conflict instanceof DeleteUse) && !(conflict instanceof DeleteUpdate) || diffElement instanceof ModelElementChangeRightTarget) continue;
            return true;
        }
        return false;
    }

    private DiffModel getDiffModel(DiffElement diffElement, ConflictReport conflictReport) {
        DiffModel leftDiff = conflictReport.getLeftVersion().getDiff();
        DiffModel rightDiff = conflictReport.getRightVersion().getDiff();
        if (EcoreUtil.createParentList(diffElement).contains(leftDiff)) {
            return leftDiff;
        }
        return rightDiff;
    }

    private EObject getDeletedTargetValue(DiffElement diffElement) {
        if (diffElement instanceof UpdateReference) {
            UpdateReference updateReference = (UpdateReference)diffElement;
            return updateReference.getLeftTarget();
        }
        if (diffElement instanceof ReferenceChangeRightTarget) {
            ReferenceChangeRightTarget referenceChangeRightTarget = (ReferenceChangeRightTarget)diffElement;
            return referenceChangeRightTarget.getRightTarget();
        }
        return null;
    }

    private boolean isRemoveReferenceTarget(DiffElement diffElement) {
        UpdateReference updateReference;
        return diffElement instanceof UpdateReference ? (updateReference = (UpdateReference)diffElement).getRightTarget() == null : diffElement instanceof ReferenceChangeRightTarget;
    }

    private DiffElement getDeletion(EObject eObject, DiffElement removeRefValueDiffElement, ConflictReport conflictReport) {
        DiffModel diffModel = this.getDiffModel(removeRefValueDiffElement, conflictReport);
        TreeIterator<EObject> allContents = diffModel.eAllContents();
        while (allContents.hasNext()) {
            ModelElementChangeRightTarget deletion;
            EObject next = (EObject)allContents.next();
            if (!(next instanceof ModelElementChangeRightTarget) || !(deletion = (ModelElementChangeRightTarget)next).getRightElement().equals(eObject)) continue;
            return deletion;
        }
        return null;
    }
}

