/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.merge.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.conflictreport.ConflictReport;
import org.modelversioning.core.diff.propagation.IPropagationMappingProvider;
import org.modelversioning.core.diff.propagation.impl.DiffPropagationEngine;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.core.util.UUIDUtil;
import org.modelversioning.merge.IMergeStrategy;
import org.modelversioning.merge.IMerger;

public class MergerImpl
implements IMerger,
IPropagationMappingProvider {
    private IMergeStrategy mergeStrategy = null;
    private Map<EObject, EObject> correspondenceMap = null;
    private ConflictReport conflictReport;
    private EcoreUtil.Copier copier = new EcoreUtil.Copier();
    ComparisonResourceSnapshot leftVersion;
    ComparisonResourceSnapshot rightVersion;

    @Override
    public void setMergeStrategy(IMergeStrategy mergeStrategy) {
        this.mergeStrategy = mergeStrategy;
    }

    @Override
    public IMergeStrategy getMergeStrategy() {
        return this.mergeStrategy;
    }

    @Override
    public void merge(ConflictReport conflictReport, Resource mergedModelResource, IProgressMonitor monitor) {
        this.leftVersion = conflictReport.getLeftVersion();
        this.rightVersion = conflictReport.getRightVersion();
        this.merge(conflictReport, this.leftVersion, this.rightVersion, mergedModelResource, monitor);
    }

    @Override
    public void merge(ConflictReport conflictReport, ComparisonResourceSnapshot leftVersion, ComparisonResourceSnapshot rightVersion, Resource mergedModelResource, IProgressMonitor monitor) {
        Assert.isNotNull(this.mergeStrategy, "A merge strategy must be set before merging.");
        this.conflictReport = conflictReport;
        this.leftVersion = leftVersion;
        this.rightVersion = rightVersion;
        monitor.beginTask("Merging all changes", 5);
        monitor.subTask("Copying the original model");
        Collection<EObject> mergedModelRoots = this.copier.copyAll(leftVersion.getMatch().getLeftRoots());
        this.copier.copyReferences();
        mergedModelResource.getContents().addAll(mergedModelRoots);
        for (Map.Entry entry : this.copier.entrySet()) {
            UUIDUtil.copyUUID((EObject)entry.getKey(), (EObject)entry.getValue());
        }
        monitor.worked(1);
        this.mergeInplace(conflictReport, leftVersion, rightVersion, mergedModelResource, monitor);
    }

    public void mergeInplace(ConflictReport conflictReport, ComparisonResourceSnapshot leftVersion, ComparisonResourceSnapshot rightVersion, Resource mergedModelResource, IProgressMonitor monitor) {
        EList<DiffElement> leftDiffElements = DiffUtil.getEffectiveDiffElements(leftVersion.getDiff());
        EList<DiffElement> rightDiffElements = DiffUtil.getEffectiveDiffElements(rightVersion.getDiff());
        leftDiffElements.removeAll(conflictReport.getEquivalentSubChanges());
        rightDiffElements.removeAll(conflictReport.getEquivalentSubChanges());
        try {
            monitor.subTask("Determining changes to merge");
            List<DiffElement> leftDiffElementsToPropagate = this.getDiffElementsToPropagate(conflictReport, leftDiffElements);
            List<DiffElement> rightDiffElementsToPropagate = this.getDiffElementsToPropagate(conflictReport, rightDiffElements);
            monitor.worked(1);
            monitor.subTask("Applying the changes");
            DiffPropagationEngine leftPropagationEngine = new DiffPropagationEngine();
            leftPropagationEngine.propagate(leftDiffElementsToPropagate, leftVersion.getMatch(), (IPropagationMappingProvider)this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(1);
            DiffPropagationEngine rightPropagationEngine = new DiffPropagationEngine();
            rightPropagationEngine.propagate(rightDiffElementsToPropagate, rightVersion.getMatch(), (IPropagationMappingProvider)this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(1);
            monitor.subTask("Retrieving trace from merged model to original models");
            this.fillCorrespondenceMap(this.copier);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    private List<DiffElement> getDiffElementsToPropagate(ConflictReport conflictReport, List<DiffElement> diffElements) {
        ArrayList<DiffElement> diffElementsToPropagate = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diffElements) {
            if (!this.mergeStrategy.shouldMerge(diffElement, conflictReport)) continue;
            diffElementsToPropagate.add(diffElement);
        }
        return diffElementsToPropagate;
    }

    private void fillCorrespondenceMap(EcoreUtil.Copier copier) {
        this.correspondenceMap = new HashMap<EObject, EObject>();
        for (Map.Entry entry : copier.entrySet()) {
            this.correspondenceMap.put((EObject)entry.getKey(), (EObject)entry.getValue());
            this.correspondenceMap.put((EObject)entry.getValue(), (EObject)entry.getKey());
        }
    }

    @Override
    public EObject getCorrespondingOriginalObject(EObject eObject) {
        return this.getCorrespondingObject(eObject);
    }

    @Override
    public EObject getCorrespondingMergedObject(EObject eObject) {
        return this.getCorrespondingObject(eObject);
    }

    private EObject getCorrespondingObject(EObject eObject) {
        if (eObject == null || this.correspondenceMap == null) {
            return null;
        }
        return this.correspondenceMap.get(eObject);
    }

    @Override
    public Map<EObject, EObject> getObjectCorrespondences() {
        return Collections.unmodifiableMap(this.correspondenceMap);
    }

    @Override
    public Collection<EObject> getCounterpartObjects(EObject eObject) {
        HashSet<EObject> counterparts = new HashSet<EObject>();
        EObject counterpart = (EObject)this.copier.get(eObject);
        counterparts.add(counterpart);
        return counterparts;
    }

    @Override
    public EObject getCounterpartObject(EObject eObject, DiffElement diffElement, EObject context) {
        EObject counterpart = (EObject)this.copier.get(eObject);
        return counterpart;
    }

    @Override
    public boolean isInOriginModel(EObject object) {
        EObject rootContainer = EcoreUtil.getRootContainer(object);
        return this.leftVersion.getMatch().getLeftRoots().contains(rootContainer);
    }

    public EcoreUtil.Copier getCopier() {
        return this.copier;
    }

    public void setCopier(EcoreUtil.Copier copier) {
        this.copier = copier;
    }
}

