/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IterationType implements Enumerator
{
    FOR_ALL(0, "FOR_ALL", "FOR_ALL"),
    FOR_SOME(1, "FOR_SOME", "FOR_SOME");

    public static final int FOR_ALL_VALUE = 0;
    public static final int FOR_SOME_VALUE = 1;
    private static final IterationType[] VALUES_ARRAY;
    public static final List<IterationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IterationType[]{FOR_ALL, FOR_SOME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IterationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IterationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IterationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IterationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IterationType get(int value) {
        switch (value) {
            case 0: {
                return FOR_ALL;
            }
            case 1: {
                return FOR_SOME;
            }
        }
        return null;
    }

    private IterationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

