/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.FeatureCondition;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.operations.OperationSpecification;

public class OperationPrinter {
    private File file;
    private FileWriter fw;
    private OperationSpecification operation;

    public OperationPrinter(OperationSpecification operation, String path, String fileName) {
        this.operation = operation;
        try {
            this.file = new File(String.valueOf(path) + "\\" + fileName);
            this.fw = new FileWriter(this.file);
            this.writeHeader();
            this.writeln("----------------Differences----------------");
            this.writeDifferences(operation.getDifferenceModel().getDiff());
            this.writeln("----------------Preconditions----------------");
            this.writeConditions(operation.getPreconditions());
            this.writeln("----------------PostConditions");
            this.writeConditions(operation.getPostconditions());
            this.fw.flush();
            this.fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeConditions(ConditionsModel model) throws IOException {
        this.writeTemplate(model.getRootTemplate());
    }

    private void writeTemplate(Template template) throws IOException {
        this.writeln("Symbol: " + template.getName());
        for (Condition c : template.getSpecifications()) {
            this.writeCondtion(c);
        }
        for (Template s : template.getSubTemplates()) {
            this.writeTemplate(s);
        }
    }

    private void writeCondtion(Condition c) throws IOException {
        if (c instanceof FeatureCondition) {
            FeatureCondition fc = (FeatureCondition)c;
            if (fc.isActive()) {
                this.writeln("(X) " + fc.getFeature().toString());
            } else {
                this.writeln("( ) " + fc.getFeature().getName());
            }
            this.writeln(fc.getExpression());
        }
    }

    private void writeln(String text) throws IOException {
        this.fw.write(String.valueOf(text) + "\n");
    }

    private void writeHeader() throws IOException {
        this.writeln("Operation: " + this.operation.getName());
        this.writeln("Description: " + this.operation.getDescription());
        this.writeln("Modeling Language: " + this.operation.getModelingLanguage());
        this.writeln("Title Template: " + this.operation.getTitleTemplate());
        this.writeln("Version: " + this.operation.getVersion());
    }

    private void writeDifferences(EObject element) throws IOException {
        boolean set = false;
        if (element instanceof DiffModel) {
            DiffModel dm = (DiffModel)element;
            this.writeln(dm.getLeftRoots() + " " + dm.getRightRoots());
        }
        if (!set && element instanceof DiffElement) {
            this.writeln(element.toString());
        }
        if (element instanceof DiffElement) {
            for (DiffElement de : ((DiffElement)element).getSubDiffElements()) {
                this.writeDifferences(de);
            }
            return;
        }
        if (element instanceof DiffModel) {
            for (DiffElement de : ((DiffModel)element).getOwnedElements()) {
                this.writeDifferences(de);
            }
            return;
        }
    }
}

