/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.util.ConditionsUtil;
import org.modelversioning.core.diff.DiffSignature;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.core.match.util.MatchUtil;
import org.modelversioning.operations.OperationSpecification;
import org.modelversioning.operations.TemplateAffection;

public class OperationSignature
extends DiffSignature {
    private OperationSpecification operationSpecification = null;
    private Map<Template, Set<TemplateAffection>> preConditionAffectionMap = new HashMap<Template, Set<TemplateAffection>>();
    private Map<Template, Set<TemplateAffection>> postConditionAffectionMap = new HashMap<Template, Set<TemplateAffection>>();
    private Map<EObject, Template> preConditionRepToTemplateMap = null;
    private Map<EObject, Template> postConditionRepToTemplateMap = null;

    public OperationSignature(OperationSpecification operationSpecification) {
        super(operationSpecification.getDifferenceModel().getDiff());
        Assert.isNotNull(operationSpecification);
        this.operationSpecification = operationSpecification;
        this.initializePreconditionRepToTemplateMap();
        this.initializePostconditionRepToTemplateMap();
    }

    private void initializePreconditionRepToTemplateMap() {
        this.preConditionRepToTemplateMap = ConditionsUtil.getRepresentativeToTemplateMap(this.operationSpecification.getPreconditions());
        Set<EObject> representatives = this.preConditionRepToTemplateMap.keySet();
        for (DiffElement diffElement : super.getSignatureElements()) {
            Template template;
            EObject element = DiffUtil.getRightElement(diffElement);
            EObject parent = DiffUtil.getRightParent(diffElement);
            EObject target = DiffUtil.getRightTarget(diffElement);
            EObject leftTarget = DiffUtil.getLeftTarget(diffElement);
            if (leftTarget != null) {
                EObject matchingObject;
                leftTarget = matchingObject = MatchUtil.getMatchingObject(leftTarget, this.operationSpecification.getDifferenceModel().getMatch());
            }
            if (element != null && representatives.contains(element)) {
                template = this.preConditionRepToTemplateMap.get(element);
                this.addToPreCondAffectionMap(template, diffElement, TemplateAffection.AffectionKind.ELEMENT);
            }
            if (parent != null && representatives.contains(parent)) {
                template = this.preConditionRepToTemplateMap.get(parent);
                this.addToPreCondAffectionMap(template, diffElement, TemplateAffection.AffectionKind.PARENT);
            }
            if (target != null && representatives.contains(target)) {
                template = this.preConditionRepToTemplateMap.get(target);
                this.addToPreCondAffectionMap(template, diffElement, TemplateAffection.AffectionKind.TARGET);
            }
            if (leftTarget == null || !representatives.contains(leftTarget)) continue;
            template = this.preConditionRepToTemplateMap.get(leftTarget);
            this.addToPreCondAffectionMap(template, diffElement, TemplateAffection.AffectionKind.OPPOSITE_TARGET);
        }
    }

    private void initializePostconditionRepToTemplateMap() {
        this.postConditionRepToTemplateMap = ConditionsUtil.getRepresentativeToTemplateMap(this.operationSpecification.getPostconditions());
        Set<EObject> representatives = this.postConditionRepToTemplateMap.keySet();
        for (DiffElement diffElement : super.getSignatureElements()) {
            Template template;
            EObject element = DiffUtil.getLeftElement(diffElement);
            EObject parent = DiffUtil.getLeftParent(diffElement);
            EObject target = DiffUtil.getLeftTarget(diffElement);
            EObject rightTarget = DiffUtil.getRightTarget(diffElement);
            if (rightTarget != null) {
                EObject matchingObject;
                rightTarget = matchingObject = MatchUtil.getMatchingObject(rightTarget, this.operationSpecification.getDifferenceModel().getMatch());
            }
            if (element != null && representatives.contains(element)) {
                template = this.postConditionRepToTemplateMap.get(element);
                this.addToPostCondAffectionMap(template, diffElement, TemplateAffection.AffectionKind.ELEMENT);
            }
            if (parent != null && representatives.contains(parent)) {
                template = this.postConditionRepToTemplateMap.get(parent);
                this.addToPostCondAffectionMap(template, diffElement, TemplateAffection.AffectionKind.PARENT);
            }
            if (target != null && representatives.contains(target)) {
                template = this.postConditionRepToTemplateMap.get(target);
                this.addToPostCondAffectionMap(template, diffElement, TemplateAffection.AffectionKind.TARGET);
            }
            if (rightTarget == null || !representatives.contains(rightTarget)) continue;
            template = this.postConditionRepToTemplateMap.get(rightTarget);
            this.addToPostCondAffectionMap(template, diffElement, TemplateAffection.AffectionKind.OPPOSITE_TARGET);
        }
    }

    private void addToPreCondAffectionMap(Template template, DiffElement change, TemplateAffection.AffectionKind affectionKind) {
        Set<Object> affectionKindSet = null;
        if (!this.preConditionAffectionMap.containsKey(template)) {
            affectionKindSet = new HashSet();
            this.preConditionAffectionMap.put(template, affectionKindSet);
        } else {
            affectionKindSet = this.preConditionAffectionMap.get(template);
        }
        affectionKindSet.add(new TemplateAffection(affectionKind, template, change));
    }

    private void addToPostCondAffectionMap(Template template, DiffElement change, TemplateAffection.AffectionKind affectionKind) {
        Set<Object> affectionKindSet = null;
        if (!this.postConditionAffectionMap.containsKey(template)) {
            affectionKindSet = new HashSet();
            this.postConditionAffectionMap.put(template, affectionKindSet);
        } else {
            affectionKindSet = this.postConditionAffectionMap.get(template);
        }
        affectionKindSet.add(new TemplateAffection(affectionKind, template, change));
    }

    public OperationSpecification getOperationSpecification() {
        return this.operationSpecification;
    }

    public Set<Template> getAffectedPreconditionTemplates() {
        return Collections.unmodifiableSet(this.preConditionAffectionMap.keySet());
    }

    public Set<Template> getAffectedPostconditionTemplates() {
        return Collections.unmodifiableSet(this.postConditionAffectionMap.keySet());
    }

    public Set<TemplateAffection> getAffectingChanges(Template template) {
        if (this.preConditionAffectionMap.containsKey(template)) {
            return Collections.unmodifiableSet(this.preConditionAffectionMap.get(template));
        }
        if (this.postConditionAffectionMap.containsKey(template)) {
            return Collections.unmodifiableSet(this.postConditionAffectionMap.get(template));
        }
        return Collections.emptySet();
    }

    public Set<TemplateAffection> getAffectingChanges(Template template, TemplateAffection.AffectionKind kind) {
        HashSet<TemplateAffection> affectingChanges = new HashSet<TemplateAffection>();
        for (TemplateAffection affection : this.getAffectingChanges(template)) {
            if (!kind.equals((Object)affection.getAffectionKind())) continue;
            affectingChanges.add(affection);
        }
        return affectingChanges;
    }

    @Override
    public void debugPring(PrintStream out) {
        out.println(String.valueOf(this.operationSpecification.getName()) + ":");
        super.debugPring(out);
    }
}

